<?php
class Calendarista_GcalProfileController extends Calendarista_BaseController{
	private $gcalProfileRepo;
	private $bookedAvailabilityRepo;
	private $id;
	private $userId;
	private $code;
	public function __construct($createCallback, $updateCallback, $deleteCallback){
		if (!(array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_gcal_profile')){
			return;
		}
		if(!Calendarista_NonceHelper::valid()){
			return;
		}
		$this->gcalProfileRepo = new Calendarista_GcalProfileRepository();
		parent::__construct($createCallback, $updateCallback, $deleteCallback);
		$this->id = isset($_GET['id']) ? (int)$_GET['id'] : null;
		$this->userId = isset($_GET['userid']) ? (int)$_GET['userid'] : null;
		$this->code = isset($_GET['code']) ? sanitize_text_field($_GET['code']) : null;
		if($this->code !== null && $this->userId !== null){
			new Calendarista_GCalService($this->userId);
			//redirect back to page to clear querystring.
		}
		if (array_key_exists('calendarSync', $_POST)){
			$this->calendarSync($calendarSyncCallback);
		}
	}
	public function calendarSync($callback){
		$userId = (int)$this->getPostValue('calendarSync');
		$service = new Calendarista_GCalService($userId);
		$result = $service->sync();
		$this->executeCallback($callback, array($result));
	}
	public function calendarDelete($callback){
		$profileId = (int)$this->getPostValue('calendarDelete');
		$gcalRepo = new Calendarista_GcalRepository();
		$gcalRepo->deleteByGcalProfileId($profileId);
		$result = $this->gcalProfileRepo->delete($profileId);
		$this->executeCallback($callback, array($result));
	}
	public function deleteAllCalendars($userId){
		$service = new Calendarista_GCalService($userId);
		return $service->deleteAllCalendars();
	}
	public function create($callback){
		$userId = null;
		$createUserResult = array('isNew'=>false);
		$clientId = (string)$this->getPostValue('clientId');
		$clientSecret = (string)$this->getPostValue('clientSecret');
		$user = Calendarista_PermissionHelper::getUserInfo();
		$result = false;
		if($user){
			$email = $user['email'];
			$userId = $user['userId'];
			if(!$this->userHasProfile($userId)){
				$result = $this->gcalProfileRepo->insert(array(
					'userId'=>$userId
					, 'clientId'=>trim($clientId)
					, 'clientSecret'=>trim($clientSecret)
					, 'accessToken'=>null
				));
			}
		}
		$this->executeCallback($callback, array($result));
	}
	public function update($callback){
		$id = (int)$_POST['calendarista_update'];
		$clientId = (string)$this->getPostValue('clientId');
		$clientSecret = (string)$this->getPostValue('clientSecret');
		$result = $this->gcalProfileRepo->update(array(
			'id'=>$id
			, 'clientId'=>$clientId
			, 'clientSecret'=>$clientSecret
			, 'accessToken'=>null
		));
		$this->executeCallback($callback, array($result, $id));
	}
	public function delete($deleteCallback){
		$profileId = $_POST['calendarista_delete'];
		$gcalRepo = new Calendarista_GcalRepository();
		$gcalRepo->deleteByGcalProfileId($profileId);
		$result = $this->gcalProfileRepo->delete($profileId);
		$this->executeCallback($deleteCallback, array($result));
	}
	protected function userHasProfile($userId){
		$profile = $this->gcalProfileRepo->readByUserId($userId);
		return $profile !== false;
	}
}
?>