<?php
class Calendarista_GeneralSettingsController extends Calendarista_BaseController{
	private $repo;
	private $id;
	const PAGE_UNIQUE_ID = 1;
	public function __construct($createCallback = null, $updateCallback = null, $deleteCallback = null){
		if (!(array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_generalsettings')){
				return;
		}
		if(!Calendarista_NonceHelper::valid()){
			return;
		}
		$this->repo = new Calendarista_GeneralSettingsRepository();
		parent::__construct($createCallback, $updateCallback, $deleteCallback);
	}
	public function create($callback){
		$generalSetting = new Calendarista_GeneralSetting($_POST);
		$generalSetting->cancelBookingUrl = null;
		if($this->generalSetting->enableUserCancelBooking){
			$generalSetting->cancelBookingUrl = self::registerCancelPage();
		}else{
			$generalSetting->cancelBookingUrl = null;
			self::deleteCancelPage();
		}
		$result = $this->repo->insert($generalSetting);
		$this->executeCallback($callback, array($result));
	}
	public function update($callback){
		$old = $this->generalSetting;
		$new = new Calendarista_GeneralSetting(array_merge($old->toArray(), $_POST));
		if($old->enableUserCancelBooking != $new->enableUserCancelBooking){
			//setting has changed
			if($new->enableUserCancelBooking){
				$new->cancelBookingUrl = self::registerCancelPage();
			}else{
				$new->cancelBookingUrl = null;
				self::deleteCancelPage();
			}
		}
		$result = $this->repo->update($new);
		$this->executeCallback($callback, array($result));
	}
	public function delete($callback){
		$appKey = $this->generalSetting->appKey;
		$result = $this->repo->delete($this->generalSetting->id);
		if($appKey){
			//maintain appKey
			$generalSetting = new Calendarista_GeneralSetting();
			$generalSetting->appKey = $appKey;
			$this->repo->insert($generalSetting);
		}
		self::deleteCancelPage();
		$this->executeCallback($callback, array($result));
	}
	public static function registerCancelPage(){
		self::deleteCancelPage();
		$result;
		try{
			$pages = new WP_Query(array( 
				'meta_key'=>CALENDARISTA_META_KEY_NAME
				, 'post_type'=>'page'
			));
			$attrs = array(
				'title'=>__('Cancel Appointment', 'calendarista')
				, 'content'=>'[calendarista-cancel-appointment]'
			);
			if(!self::hasPage($pages, self::PAGE_UNIQUE_ID)){
				$id = wp_insert_post(array(
					'post_title'=>$attrs['title']
					, 'post_content'=>$attrs['content']
					, 'post_type'=>'page'
					, 'post_status'=>'publish'
					, 'show_ui'=>false
					, 'show_in_menu' =>false
					, 'show_in_admin_bar'=>false
					, 'comment_status'=> 'closed'
					, 'ping_status'=>'closed'
					, 'exclude_from_search' =>true
				));
				add_post_meta($id, CALENDARISTA_META_KEY_NAME, self::PAGE_UNIQUE_ID);
				$result = get_page_link($id);
			}
		}catch(Exception $e){
			Calendarista_ErrorLogHelper::insert($e->getMessage());
			$result = false;
		}
		return $result;
	}
	
	protected static function hasPage($pages, $pageId){
		foreach($pages->posts as $page){
			$result = get_post_meta($page->ID, CALENDARISTA_META_KEY_NAME, true);
			if($result != '' && (int)$result == $pageId){
				return true;
			}
		}
		return false;
	}
	
	protected static function deleteCancelPage(){
		$args = array( 
			'meta_key'=>CALENDARISTA_META_KEY_NAME
			, 'post_type'=>'page'
		);
		try{
			$pages = new WP_Query($args);
			foreach($pages->posts as $page){
				$result = get_post_meta($page->ID, CALENDARISTA_META_KEY_NAME, true);
				if($result != '' && (int)$result == self::PAGE_UNIQUE_ID){
					wp_delete_post($page->ID, true);
					break;
				}
			}
		}catch(Exception $e){
			Calendarista_ErrorLogHelper::insert($e->getMessage());
		}
	}
}
?>