<?php
class Calendarista_PayPalController extends Calendarista_BaseController
{
	private $repo;
	private $setting;
	public function __construct($createCallback, $updateCallback, $deleteCallback)
	{
		if (!(array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_paypal')){
				return;
		}
		if(!Calendarista_NonceHelper::valid()){
			return;
		}
		$this->repo = new Calendarista_PaymentSettingRepository();
		$this->setting = new Calendarista_PayPalSetting($_POST);
		parent::__construct($createCallback, $updateCallback, $deleteCallback);
	}
	
	public function create($callback){
		$result = $this->repo->insert($this->setting);
		$this->executeCallback($callback, array($result));
	}
	
	public function update($callback){
		$result = $this->repo->update($this->setting);
		$this->executeCallback($callback, array($result));
	}
	
	public function delete($callback){
		$result = $this->repo->delete($this->setting->id);
		$this->executeCallback($callback, array($result));
	}
}
?>