<?php
class Calendarista_DynamicField extends Calendarista_EntityBase{
	public $id;
	public $projectId;
	public $availabilityId;
	public $label;
	public $cost;
	public $byOptional;
	public $limitBySeat;
	public $required;
	public $fixedCost;
	public $data = null;
	public function __construct($args){
		if(array_key_exists('projectId', $args)){
			$this->projectId = (int)$args['projectId'];
		}
		if(array_key_exists('availabilityId', $args)){
			$this->availabilityId = (int)$args['availabilityId'];
		}
		if(array_key_exists('label', $args)){
			$this->label = $this->decode((string)$args['label']);
		}
		if(array_key_exists('cost', $args)){
			$this->cost = (double)$args['cost'];
		}
		if(array_key_exists('byOptional', $args)){
			$this->byOptional = (bool)$args['byOptional'];
		}
		if(array_key_exists('limitBySeat', $args)){
			$this->limitBySeat = (bool)$args['limitBySeat'];
		}
		if(array_key_exists('required', $args)){
			$this->required = (bool)$args['required'];
		}
		if(array_key_exists('data', $args) && isset($args['data'])){
			$this->data = is_array($args['data']) ? $args['data'] : (array)unserialize($args['data']);
		}
		if(array_key_exists('fixedCost', $args)){
			$this->fixedCost = (bool)$args['fixedCost'];
		}
		if(array_key_exists('id', $args)){
			$this->id = (int)$args['id'];
		}
		$this->updateResources();
		$this->init();
	}
	public function updateResources(){
		$this->registerWPML();
	}
	public function deleteResources(){
		$this->unregisterWPML();
	}
	protected function init(){
		$this->label = Calendarista_TranslationHelper::t('guest_label_' . $this->id, $this->label);
	}
	protected function registerWPML(){
		Calendarista_TranslationHelper::register('guest_label_' . $this->id, $this->label);
	}
	protected function unregisterWPML(){
		Calendarista_TranslationHelper::unregister('guest_label_' . $this->id);
	}
	public function toArray(){
		return array(
			'id'=>$this->id
			, 'projectId'=>$this->projectId
			, 'availabilityId'=>$this->availabilityId
			, 'label'=>$this->label
			, 'cost'=>$this->cost
			, 'byOptional'=>$this->byOptional
			, 'limitBySeat'=>$this->limitBySeat
			, 'required'=>$this->required
			, 'data'=>$this->data
			, 'fixedCost'=>$this->fixedCost
		);
	}
}
?>