<?php
class Calendarista_StripeSetting extends Calendarista_EntityBase
{
	public $id = -1;
	public $enabled;
	public $publishableKey;
	public $secretKey;
	public $paymentOperator = Calendarista_PaymentOperator::STRIPE;
	public $title;
	public $orderIndex = 1;
	public $enableInlineForm = true;
	public $imageUrl;
	public function __construct($args = array())
	{
		$this->title = __('Secure payment with Stripe', 'calendarista');
		if(array_key_exists('publishableKey', $args)){
			$this->publishableKey = (string)$args['publishableKey'];
		}
		if(array_key_exists('secretKey', $args)){
			$this->secretKey = (string)$args['secretKey'];
		}
		if(array_key_exists('enabled', $args)){
			$this->enabled = (bool)$args['enabled'];
		}
		if(array_key_exists('title', $args)){
			$this->title = (string)$args['title'];
		}
		if(array_key_exists('imageUrl', $args)){
			$this->imageUrl = (string)$args['imageUrl'];
		}
		if(array_key_exists('orderIndex', $args)){
			$this->orderIndex = (int)$args['orderIndex'];
		}
		if(array_key_exists('id', $args)){
			$this->id = (int)$args['id'];
		}
			$this->updateResources();
		$this->init();
	}
	public function updateResources(){
		$this->registerWPML();
	}
	public function deleteResources(){
		$this->unregisterWPML();
	}
	protected function init(){
		$this->title = Calendarista_TranslationHelper::t('stripe_title_' . $this->id, $this->title);
	}
	protected function registerWPML(){
		Calendarista_TranslationHelper::register('stripe_title_' . $this->id, $this->title);
	}
	protected function unregisterWPML(){
		Calendarista_TranslationHelper::unregister('stripe_title_' . $this->id);
	}
	public function toArray(){
		return array(
			'id'=>$this->id
			, 'publishableKey'=>$this->publishableKey
			, 'secretKey'=>$this->secretKey
			, 'enabled'=>$this->enabled
			, 'paymentOperator'=>$this->paymentOperator
			, 'title'=>$this->title
			, 'orderIndex'=>$this->orderIndex
			, 'enableInlineForm'=>$this->enableInlineForm
			, 'imageUrl'=>$this->imageUrl
		);
	}
}
?>