<?php
class Calendarista_TwocheckoutSetting extends Calendarista_EntityBase
{
	public $id = -1;
	public $enabled;
	public $accountNumber;
	public $publishableKey;
	public $privateKey;
	public $paymentOperator = Calendarista_PaymentOperator::TWOCHECKOUT;
	public $useSandbox = false;
	public $title;
	public $orderIndex = 2;
	public $enableInlineForm = true;
	public function __construct($args = array())
	{
		$this->operatorImageUrl = CALENDARISTA_PLUGINDIR . 'assets/img/rtaImage.png';
		$this->title = __('Secure payment with 2Checkout', 'calendarista');
		if(array_key_exists('accountNumber', $args)){
			$this->accountNumber = (string)$args['accountNumber'];
		}
		if(array_key_exists('publishableKey', $args)){
			$this->publishableKey = (string)$args['publishableKey'];
		}
		if(array_key_exists('privateKey', $args)){
			$this->privateKey = (string)$args['privateKey'];
		}
		if(array_key_exists('useSandbox', $args)){
			$this->useSandbox = (bool)$args['useSandbox'];
		}
		if(array_key_exists('enabled', $args)){
			$this->enabled = (bool)$args['enabled'];
		}
		if(array_key_exists('title', $args)){
			$this->title = (string)$args['title'];
		}
		if(array_key_exists('orderIndex', $args)){
			$this->orderIndex = (int)$args['orderIndex'];
		}
		if(array_key_exists('id', $args)){
			$this->id = (int)$args['id'];
		}
	}
	public function toArray(){
		return array(
			'id'=>$this->id
			, 'accountNumber'=>$this->accountNumber
			, 'privateKey'=>$this->privateKey
			, 'publishableKey'=>$this->publishableKey
			, 'useSandbox'=>$this->useSandbox
			, 'enabled'=>$this->enabled
			, 'paymentOperator'=>$this->paymentOperator
			, 'title'=>$this->title
			, 'orderIndex'=>$this->orderIndex
			, 'enableInlineForm'=>$this->enableInlineForm

		);
	}
}
?>