<?php
class Calendarista_GcalProfileRepository extends Calendarista_RepositoryBase
{
	public $wpdb;
	public $gcal_profile_table_name;
	public $user_table_name;
	public function __construct(){
		global $wpdb;
		$this->wpdb = &$wpdb;
		$this->gcal_profile_table_name = $wpdb->prefix . 'calendarista_gcal_profile';
		$this->user_table_name =  $wpdb->users;
	}
	public function read($id){
		$sql = "SELECT *
				FROM   $this->gcal_profile_table_name 
				WHERE  id = %d";
		$result = $this->wpdb->get_results( $this->wpdb->prepare($sql, $id));
		if($result){
			$r = $result[0];
			return array(
				'id'=>(int)$r->id
				, 'userId'=>(int)$r->userId
				, 'clientId'=>$r->clientId
				, 'clientSecret'=>$r->clientSecret
				, 'accessToken'=>$r->accessToken
			);
		}
		return false;
	}
	public function readByUserId($userId){
		$sql = "SELECT *
				FROM   $this->gcal_profile_table_name 
				WHERE  userId = %d";
		$result = $this->wpdb->get_results( $this->wpdb->prepare($sql, $userId));
		if($result){
			$r = $result[0];
			return array(
				'id'=>(int)$r->id
				, 'userId'=>(int)$r->userId
				, 'clientId'=>$r->clientId
				, 'clientSecret'=>$r->clientSecret
				, 'accessToken'=>$r->accessToken
			);
		}
		return false;
	}
	public function readAll($args){
		$pageIndex = isset($args['pageIndex']) ? $args['pageIndex'] : -1;
		$limit = isset($args['limit']) ? $args['limit'] : 5;
		$orderBy = isset($args['orderBy']) ? $args['orderBy'] : null;
		$order = isset($args['order']) ? $args['order'] : null;
		$userId = isset($args['userId']) ? $args['userId'] : null;
		if($pageIndex === null){
			$pageIndex = -1;
		}
		if($limit === null){
			$limit = 5;
		}
		if($orderBy === null){
			$orderBy = 'id';
		}
		if($order === null){
			$order = 'desc';
		}
		$query = "SELECT *
				FROM   $this->gcal_profile_table_name";
		$where = array();
		$params = array();
		if($userId){
			array_push($where, 'userId = %d');
			array_push($params, $userId);
		}
		if(count($where) > 0){
			$query .= ' WHERE ' . implode(' AND ', $where);
		}
		$query .= ' ORDER BY ' . $orderBy . ' ' . $order;
		if($pageIndex !== null && $pageIndex !== -1){
			$query .= ' LIMIT ' . $pageIndex . ', ' . $limit . ';';
		}
		$result = $this->wpdb->get_results(count($params) > 0 ? $this->wpdb->prepare($query, $params) : $query);
		if( is_array($result)){
			$query = "SELECT count(id) as total FROM $this->gcal_profile_table_name";
			if(count($where) > 0){
				$query .= ' WHERE ' . implode(' AND ', $where);
			}
			$records = $this->wpdb->get_results(count($params) > 0 ? $this->wpdb->prepare($query, $params) : $query);
			$resultset = array();
			foreach($result as $r){
				array_push($resultset, array(
					'id'=>(int)$r->id
					, 'userId'=>(int)$r->userId
					, 'clientId'=>$r->clientId
					, 'clientSecret'=>$r->clientSecret
					, 'accessToken'=>$r->accessToken
				));
			}
			return array('resultset'=>$resultset, 'total'=>(int)$records[0]->total);
		}
		return false;
	}
	public function insert($args){
		 $result = $this->wpdb->insert($this->gcal_profile_table_name,  array(
			'userId'=>$args['userId']
			, 'clientId'=>$args['clientId']
			, 'clientSecret'=>$args['clientSecret']
			, 'accessToken'=>$args['accessToken']
		  ), array('%d','%s','%s','%s'));
		  
		 if($result !== false){
			return $this->wpdb->insert_id;
		 }
		 return $result;
	}
	public function update($args){
		$result = $this->wpdb->update($this->gcal_profile_table_name,  array(
			'clientId'=>$args['clientId']
			, 'clientSecret'=>$args['clientSecret']
			, 'accessToken'=>$args['accessToken']
		), array('id'=>$args['id']), array('%s','%s','%s'));
		
		return $result;
	}
	
	public function delete($id){
		$sql = "DELETE FROM $this->gcal_profile_table_name WHERE id = %d";
		$rows_affected = $this->wpdb->query( $this->wpdb->prepare($sql, $id) );
		return $rows_affected;
	}
}
?>