<?php
class Calendarista_GcalRepository extends Calendarista_RepositoryBase
{
	public $wpdb;
	public $gcal_table_name;
	public function __construct(){
		global $wpdb;
		$this->wpdb = &$wpdb;
		$this->gcal_table_name = $wpdb->prefix . 'calendarista_gcal';
	}
	public function read($id){
		$sql = "SELECT *
				FROM   $this->gcal_table_name 
				WHERE  id = %d";
		$result = $this->wpdb->get_results($this->wpdb->prepare($sql, $id));
		if($result){
			$r = $result[0];
			return array(
				'id'=>(int)$r->id
				, 'gcalProfileId'=>(int)$r->gcalProfileId
				, 'calendarId'=>$r->calendarId
				, 'projectId'=>(int)$r->projectId
				, 'availabilityId'=>(int)$r->availabilityId
				, 'calendarName'=>$r->calendarName
				, 'projectName'=>$r->projectName
				, 'availabilityName'=>$r->availabilityName
			);
		}
		return false;
	}
	public function readByGcalProfileId($id){
		$sql = "SELECT *
				FROM   $this->gcal_table_name 
				WHERE  gcalProfileId = %d";
		$result = $this->wpdb->get_results( $this->wpdb->prepare($sql, $id));
		if($result){
			$resultset = array();
			foreach($result as $r){
				array_push($resultset, array(
					'id'=>(int)$r->id
					, 'gcalProfileId'=>(int)$r->gcalProfileId
					, 'calendarId'=>$r->calendarId
					, 'projectId'=>(int)$r->projectId
					, 'availabilityId'=>(int)$r->availabilityId
					, 'calendarName'=>$r->calendarName
					, 'projectName'=>$r->projectName
					, 'availabilityName'=>$r->availabilityName
				));
			}
			return $resultset;
		}
		return false;
	}
	public function readByProjectId($projectId){
		$sql = "SELECT *
				FROM   $this->gcal_table_name 
				WHERE  projectId = %d";
		$result = $this->wpdb->get_results( $this->wpdb->prepare($sql, $projectId));
		if($result){
			$resultset = array();
			foreach($result as $r){
				array_push($resultset, array(
					'id'=>(int)$r->id
					, 'gcalProfileId'=>(int)$r->gcalProfileId
					, 'calendarId'=>$r->calendarId
					, 'projectId'=>(int)$r->projectId
					, 'availabilityId'=>(int)$r->availabilityId
					, 'calendarName'=>$r->calendarName
					, 'projectName'=>$r->projectName
					, 'availabilityName'=>$r->availabilityName
				));
			}
			return $resultset;
		}
		return false;
	}
	public function readByCalendarId($calendarId){
		$sql = "SELECT *
				FROM   $this->gcal_table_name 
				WHERE  calendarId = %s";
		$result = $this->wpdb->get_results( $this->wpdb->prepare($sql, $calendarId));
		if($result){
			$resultset = array();
			foreach($result as $r){
				array_push($resultset, array(
					'id'=>(int)$r->id
					, 'gcalProfileId'=>(int)$r->gcalProfileId
					, 'calendarId'=>$r->calendarId
					, 'projectId'=>(int)$r->projectId
					, 'availabilityId'=>(int)$r->availabilityId
					, 'calendarName'=>$r->calendarName
					, 'projectName'=>$r->projectName
					, 'availabilityName'=>$r->availabilityName
				));
			}
			return $resultset;
		}
		return false;
	}
	public function readByAvailabilityId($availabilityId){
		$sql = "SELECT *
				FROM   $this->gcal_table_name 
				WHERE  availabilityId = %d";
		$result = $this->wpdb->get_results( $this->wpdb->prepare($sql, $availabilityId));
		if($result){
			$r = $result[0];
			return array(
				'id'=>(int)$r->id
				, 'gcalProfileId'=>(int)$r->gcalProfileId
				, 'calendarId'=>$r->calendarId
				, 'projectId'=>(int)$r->projectId
				, 'availabilityId'=>(int)$r->availabilityId
				, 'calendarName'=>$r->calendarName
				, 'projectName'=>$r->projectName
				, 'availabilityName'=>$r->availabilityName
			);
		}
		return false;
	}
	public function exists($args){
		$sql = "SELECT count(*) as result
				FROM   $this->gcal_table_name 
				WHERE  gcalProfileId = %d AND calendarId = %s AND availabilityId = %d";
		$result = $this->wpdb->get_results($this->wpdb->prepare($sql, $args['gcalProfileId'], $args['calendarId'], $args['availabilityId']));
		if($result){
			$r = $result[0];
			return (int)$r->result ? true : false;
		}
		return false;
	}
	public function readAll($args){
		$pageIndex = isset($args['pageIndex']) ? $args['pageIndex'] : -1;
		$limit = isset($args['limit']) ? $args['limit'] : 5;
		$orderBy = isset($args['orderBy']) ? $args['orderBy'] : null;
		$order = isset($args['order']) ? $args['order'] : null;
		$gcalProfileId = isset($args['gcalProfileId']) ? $args['gcalProfileId'] : null;
		if($pageIndex === null){
			$pageIndex = -1;
		}
		if($limit === null){
			$limit = 5;
		}
		if($orderBy === null){
			$orderBy = 'id';
		}
		if($order === null){
			$order = 'desc';
		}
		$query = "SELECT *
				FROM   $this->gcal_table_name";
		$where = array();
		$params = array();
		if($gcalProfileId){
			array_push($where, 'gcalProfileId = %d');
			array_push($params, $gcalProfileId);
		}
		if(count($where) > 0){
			$query .= ' WHERE ' . implode(' AND ', $where);
		}
		$query .= ' ORDER BY ' . $orderBy . ' ' . $order;
		if($pageIndex !== null && $pageIndex !== -1){
			$query .= ' LIMIT ' . $pageIndex . ', ' . $limit . ';';
		}
		$result = $this->wpdb->get_results(count($params) > 0 ? $this->wpdb->prepare($query, $params) : $query);
		if( is_array($result)){
			$query = "SELECT count(id) as total FROM $this->gcal_table_name";
			if(count($where) > 0){
				$query .= ' WHERE ' . implode(' AND ', $where);
			}
			$records = $this->wpdb->get_results(count($params) > 0 ? $this->wpdb->prepare($query, $params) : $query);
			$resultset = array();
			foreach($result as $r){
				array_push($resultset, array(
					'id'=>(int)$r->id
					, 'gcalProfileId'=>(int)$r->gcalProfileId
					, 'calendarId'=>$r->calendarId
					, 'projectId'=>(int)$r->projectId
					, 'availabilityId'=>(int)$r->availabilityId
					, 'calendarName'=>$r->calendarName
					, 'projectName'=>$r->projectName
					, 'availabilityName'=>$r->availabilityName
				));
			}
			return array('resultset'=>$resultset, 'total'=>(int)$records[0]->total);
		}
		return false;
	}
	public function insert($args){
		 $result = $this->wpdb->insert($this->gcal_table_name,  array(
			'gcalProfileId'=>$args['gcalProfileId']
			, 'calendarId'=>$args['calendarId']
			, 'projectId'=>$args['projectId']
			, 'availabilityId'=>$args['availabilityId']
			, 'calendarName'=>$args['calendarName']
			, 'projectName'=>$args['projectName']
			, 'availabilityName'=>$args['availabilityName']
		  ), array('%d', '%s','%d','%d','%s','%s','%s'));
		  
		 if($result !== false){
			return $this->wpdb->insert_id;
		 }
		 return $result;
	}
	public function update($args){
		$result = $this->wpdb->update($this->gcal_table_name,  array(
			'calendarId'=>$args['calendarId']
			, 'projectId'=>$args['projectId']
			, 'availabilityId'=>$args['availabilityId']
			, 'calendarName'=>$args['calendarName']
			, 'projectName'=>$args['projectName']
			, 'availabilityName'=>$args['availabilityName']
		), array('id'=>$args['id']), array('%s','%d','%d','%s','%s','%s'));
		
		return $result;
	}
	
	public function delete($id){
		$sql = "DELETE FROM $this->gcal_table_name WHERE id = %d";
		$rows_affected = $this->wpdb->query( $this->wpdb->prepare($sql, $id) );
		return $rows_affected;
	}
	public function deleteByGcalProfileId($id){
		$sql = "DELETE FROM $this->gcal_table_name WHERE gcalProfileId = %d";
		$rows_affected = $this->wpdb->query( $this->wpdb->prepare($sql, $id) );
		return $rows_affected;
	}
	public function deleteByGcalProfileIdAndAvailability($id, $availabilityId){
		$sql = "DELETE FROM $this->gcal_table_name WHERE gcalProfileId = %d AND availabilityId = %d";
		$rows_affected = $this->wpdb->query( $this->wpdb->prepare($sql, $id, $availabilityId) );
		return $rows_affected;
	}
}
?>