<?php
class Calendarista_GoogleCalendarJob{
	const HOOK = 'Calendarista_GoogleCalendarJobHook';
	//to instantiate, simply call register. Self contained schedule
	public function __construct(){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		if ($generalSetting->googleCalendarAltCronJob && !wp_next_scheduled(self::HOOK)){
			wp_schedule_event(time(), 'calendarista_everyminute', self::HOOK);
		}
	}
	public static function init(){
		Calendarista_GoogleCalendarHelper::syncAll();
	}
	public static function register(){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		if($generalSetting->googleCalendarAltCronJob){
			add_action(self::HOOK, array('Calendarista_GoogleCalendarJob', 'init'));
			return;
		}
		self::cancelAllSchedules();
	}
	public static function cancelAllSchedules(){
		$crons = _get_cron_array();
		foreach ($crons as $timestamp=>$hooks) { 
			foreach ((array)$hooks as $hook=>$params) {
				if(strpos($hook, self::HOOK)!== false){
					wp_clear_scheduled_hook($hook);
				}
			}
		}
	}
	public static function getSchedulesCount(){
		$crons = _get_cron_array();
		$result = 0;
		foreach ($crons as $timestamp=>$hooks) { 
			foreach ((array)$hooks as $hook=>$params) {
				if(strpos($hook, self::HOOK)!== false){
					++$result;
				}
			}
		}
		return $result;
	}
}

?>