<?php
class Calendarista_WooCommerceJob{
	const HOOK = 'Calendarista_WooCommerceJobHook';
	//to instantiate, simply call register. Self contained schedule
	public function __construct(){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		if ($generalSetting->wooCommerceAltCronJob && !wp_next_scheduled(self::HOOK)){
			wp_schedule_event(time(), 'calendarista_everyminute', self::HOOK);
		}
	}
	public static function init(){
		Calendarista_WooCommerceHelper::logUnregisterdOrders();
	}
	public static function register(){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		//new option to enable wooAltCronJob
		if($generalSetting->wooCommerceAltCronJob){
			add_action(self::HOOK, array('Calendarista_WooCommerceJob', 'init'));
			return;
		}
		self::cancelAllSchedules();
	}
	public static function cancelAllSchedules(){
		$crons = _get_cron_array();
		foreach ($crons as $timestamp=>$hooks) { 
			foreach ((array)$hooks as $hook=>$params) {
				if(strpos($hook, self::HOOK)!== false){
					wp_clear_scheduled_hook($hook);
				}
			}
		}
	}
	public static function getSchedulesCount(){
		$crons = _get_cron_array();
		$result = 0;
		foreach ($crons as $timestamp=>$hooks) { 
			foreach ((array)$hooks as $hook=>$params) {
				if(strpos($hook, self::HOOK)!== false){
					++$result;
				}
			}
		}
		return $result;
	}
}

?>