<?php
class Calendarista_DynamicFieldList extends Calendarista_List {
	public $perPage;
	public $orderBy;
	public $order;
	public $totalPages;
	public $count;
	function __construct(){
		$this->perPage = 10;
        parent::__construct( array(
            'singular'  => 'dynamicfield', 
            'plural'    => 'dynamicfield', 
            'ajax'      => false    
        ) );
    }
	function single_row( $item ) {
		static $row_class = '';
		$row_class = ( $row_class == '' ? 'alternate' : '' );
		$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
		if($item['id'] == $id){
			$row_class .= ' table-selected-row';
		}
		$row_class = $row_class ? ' class="' . $row_class . '"' : '';
		echo '<tr' . $row_class . '>';
		echo $this->single_row_columns( $item );
		echo '</tr>';
	}
    function column_default($item, $column_name){
        switch($column_name){
            default:
                return print_r($item,true); 
        }
    }
	function column_action($item){
		$result = array();
		$editUrl = esc_url(add_query_arg(array(
			'page'=>'calendarista-index',
			'calendarista-tab'=>4,
			'id'=>$item['id'], 
			'projectId'=>$item['projectId'],
			'availabilityId'=>$item['availabilityId']
		), 'admin.php'));
		array_push($result, sprintf(
			'<a class="button button-primary" id="edit_dynamic_field" href="%s">
				%s
			</a>'
			, $editUrl
			, __('Select', 'calendarista')
		));
		array_push($result, sprintf(
			'<button class="button button-primary" type="submit" name="calendarista_delete" value="%d">
				%s
			</button>'
			, $item['id']
			, __('Delete', 'calendarista')
		));
        return join('<br>', $result);
	}
	function column_label($item){
		return Calendarista_StringResourceHelper::decodeString($item['label']);
	}
	function column_limitBySeat($item){
		return $item['limitBySeat'] ? __('Yes', 'calendarista') : __('No', 'calendarista');
	}
	function column_required($item){
		return $item['required'] ? __('Yes', 'calendarista') : __('No', 'calendarista');
	}
	function column_byOptional($item){
		return $item['byOptional'] ? __('Yes', 'calendarista') : __('No', 'calendarista');
	}
	function column_fixedCost($item){
		return $item['fixedCost'] ? __('Yes', 'calendarista') : __('No', 'calendarista');
	}
	function column_cost($item){
		return $item['cost'] ? $item['cost'] : '0.00';
	}
	function column_data($item){
		return sprintf('%d - %d', $item['data'][0]['min'], $item['data'][0]['max']);
	}
    function get_columns(){
        $columns = array(
			'label'=>__('Guest label', 'calendarista')
			, 'limitBySeat'=>__('Limit by seat', 'calendarista')
			, 'required'=>__('Required', 'calendarista')
			, 'byOptional'=>__('Guest x Optional', 'calendarista')
			, 'fixedCost'=>__('Fixed Cost', 'calendarista')
			, 'cost'=>__('Cost', 'calendarista')
			, 'data'=>__('Min - Max', 'calendarista')
			, 'action'=>__('Action', 'calendarista')
        );
        return $columns;
    }
    function get_sortable_columns() {
        $sortable_columns = array();
        return $sortable_columns;
    }
    /**
		@description binds to data
	*/
    function bind() {

        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        
        $this->_column_headers = array($columns, $hidden, $sortable);
        $currentPage = $this->get_pagenum() - 1;
		if($currentPage){
			$currentPage = $currentPage * $this->perPage;
		}
		$allowedKeys = array('id', 'projectId', 'availabilityId', 'asc', 'desc');
		$this->orderBy = (!empty($_REQUEST[$this->orderByKey])) ? sanitize_text_field($_REQUEST[$this->orderByKey]) : 'id';
		if (!in_array($this->orderBy, $allowedKeys, true)) {
			return;
		}
        $this->order = (!empty($_REQUEST[$this->orderKey])) ? sanitize_text_field($_REQUEST[$this->orderKey]) : 'desc'; 
		if (!in_array($this->order, $allowedKeys, true)) {
			return;
		}
		$availabilityId = isset($_REQUEST['availabilityId']) ? (int)$_REQUEST['availabilityId'] : null;
		
		$repo = new Calendarista_DynamicFieldRepository();
		$result = $repo->readByAvailabilityId(array(
			'availabilityId'=>$availabilityId
			, 'pageIndex'=>$currentPage
			, 'limit'=>$this->perPage
			, 'orderBy'=>$this->orderBy
			, 'order'=>$this->order
		));
		$this->currentPage = $currentPage;
        $this->count = $result['total'];
		$this->items = array();
		if(!$this->count){
			return;
		}
		foreach($result['resultset'] as $rs){
			array_push($this->items, $rs->toArray());
		}
		$this->totalPages = ceil($this->count / $this->perPage);
        $this->set_pagination_args( array(
            'total_items' => $this->count,
            'per_page'    => $this->perPage,
            'total_pages' => $this->totalPages
        ) );
    }
	function get_table_classes() {
		return array('wp-list-table', 'calendarista',  'widefat', 'fixed', 'striped', 'calendarista-dynamic-field');
	}
	public function no_items() {
		echo __('No guest fields found. Ensure an availability is selected in the left pane.', 'calendarista');
	}
}
?>