<?php
class Calendarista_GoogleCalendarList extends Calendarista_List {
	public $perPage;
	public $orderBy;
	public $order;
	public $totalPages;
	public $count;
	public $availabilityId;
	function __construct( ){
		$this->perPage = 10;
        parent::__construct( array(
            'singular'  => 'gcal', 
            'plural'    => 'gcal', 
            'ajax'      => false    
        ) );
    }
	
	function single_row( $item ) {
		static $row_class = '';
		$row_class = ( $row_class == '' ? 'alternate' : '' );
		$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
		if($item['id'] == $id){
			$row_class .= ' table-selected-row';
		}
		$row_class = $row_class ? ' class="' . $row_class . '"' : '';
		echo '<tr' . $row_class . '>';
		echo $this->single_row_columns( $item );
		echo '</tr>';
	}
	
    function column_default($item, $column_name){
        switch($column_name){
            default:
                return print_r($item, true); 
        }
    }
	function column_action($item){
		$buttonGroups = array();
		array_push($buttonGroups, sprintf(
			'<button class="button button-primary" name="calendarista_sync" value="%d">
				<i class="glyphicon glyphicon-remove"></i> 
				%s
			</button>'
			, $item['id']
			, __('Sync', 'calendarista') 
		));
		array_push($buttonGroups, sprintf(
			'<button class="button button-primary" name="calendarista_delete" value="%d">
				<i class="glyphicon glyphicon-remove"></i> 
				%s
			</button>'
			, $item['id']
			, __('Delete', 'calendarista') 
		));
		array_push($buttonGroups, sprintf(
			'<button class="button button-primary" name="calendarista_delete_with_data" value="%d">
				<i class="glyphicon glyphicon-remove"></i> 
				%s
			</button>'
			, $item['gcalProfileId']
			, __('Delete**', 'calendarista') 
		));
        return join("&nbsp;", $buttonGroups);
	}
	function column_ck($item){
		return sprintf('<input type="checkbox" name="id[]" value="%d">', $item['id']);
	}
	function column_calendarName($item){
		return $item['calendarName'];
	}
	function column_serviceName($item){
		return $item['projectName'];
	}
	function column_availabilityName($item){
		return $item['availabilityName'];
	}
    function get_columns(){
        $columns = array(
			'ck'=>'<input type="checkbox" name="selectall">'
			, 'calendarName'=>__('Google calendar', 'calendarista')
			, 'serviceName'=>__('Service', 'calendarista')
			, 'availabilityName'=>__('Availability', 'calendarista')
			, 'action'=>__('Action', 'calendarista')
        );
        return $columns;
    }
    
    function get_sortable_columns() {
		//true means its already sorted
        $sortable_columns = array(
			'calendarName'=>array('calendarName', false)
			, 'serviceName'=>array('projectName', false)
        );
        return $sortable_columns;
    }
    
    /**
		@description binds to data
	*/
    function bind() {
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        $this->_column_headers = array($columns, $hidden, $sortable);
        $currentPage = $this->get_pagenum() - 1;
		if($currentPage){
			$currentPage = $currentPage * $this->perPage;
		}
		$allowedKeys = array('id', 'gcalProfileId', 'calendarId', 'projectId', 'availabilityId', 'asc', 'desc');
        $this->orderBy = (!empty($_REQUEST[$this->orderByKey])) ? sanitize_text_field($_REQUEST[$this->orderByKey]) : 'id';
		if (!in_array($this->orderBy, $allowedKeys, true)) {
			return;
		}
        $this->order = (!empty($_REQUEST[$this->orderKey])) ? sanitize_text_field($_REQUEST[$this->orderKey]) : 'desc';
		if (!in_array($this->order, $allowedKeys, true)) {
			return;
		}
		$userId = Calendarista_PermissionHelper::getUserId();
		$gcalProfileRepo = new Calendarista_GcalProfileRepository();
		$gcalProfile = $gcalProfileRepo->readByUserId($userId);
		if(!$gcalProfile){
			return;
		}
		$gcal = new Calendarista_GcalRepository();
        $result = $gcal->readAll(array(
			'pageIndex'=>$currentPage
			, 'limit'=>$this->perPage
			, 'orderBy'=>$this->orderBy
			, 'order'=>$this->order
			, 'gcalProfileId'=>$gcalProfile['id']
		));
        $this->count = $result['total'];
        $this->items = $result['resultset'];
		if(!$this->count){
			return;
		}
		$this->availabilityId = $this->items[0]['availabilityId'];
		$this->totalPages = ceil($this->count / $this->perPage);
        $this->set_pagination_args( array(
            'total_items' => $this->count,
            'per_page'    => $this->perPage,
            'total_pages' => $this->totalPages
        ) );
    }
	
	function get_table_classes() {
		return array('wp-list-table', 'calendarista',  'widefat', 'fixed', 'striped', 'calendarista-google-calendar-list');
	}
	public function no_items() {
		echo __('No services to sync to google calendar found.', 'calendarista');
	}
}
?>