<?php
class Calendarista_StaffList extends Calendarista_List {
	public $perPage;
	public $orderBy;
	public $order;
	public $totalPages;
	public $count;
	function __construct( ){
		$this->perPage = 10;
        parent::__construct( array(
            'singular'  => 'staff', 
            'plural'    => 'staff', 
            'ajax'      => false    
        ) );
    }
	
	function single_row( $item ) {
		static $row_class = '';
		$row_class = ( $row_class == '' ? 'alternate' : '' );
		$id = isset($_GET['id']) ? (int)$_GET['id'] : null;
		if($item['id'] == $id){
			$row_class .= ' table-selected-row';
		}
		$row_class = $row_class ? ' class="' . $row_class . '"' : '';
		echo '<tr' . $row_class . '>';
		echo $this->single_row_columns( $item );
		echo '</tr>';
	}
	
    function column_default($item, $column_name){
        switch($column_name){
            default:
                return print_r($item,true); 
        }
    }
	function column_action($item){
		$result = array();
		array_push($result, sprintf(
			'<button type="button" class="button button-primary" name="editStaff" 
				value="%d">
				%s
			</button>'
			, $item['id']
			, __('Edit', 'calendarista')
		));
        return join("\n", $result);
	}
	function column_ck($item){
		return sprintf('<input type="checkbox" name="members[]" value="%d">', $item['id']);
	}
	function column_name($item){
		return $item['name'];
	}
	function column_email($item){
		return $item['email'];
	}
	function column_projectName($item){
		return $item['projectName'];
	}
	function column_availabilityName($item){
		return $item['availabilityName'];
	}
	
    function get_columns(){
        $columns = array(
			'ck'=>'<input type="checkbox" name="selectall">'
			, 'name'=>__('Staff Name', 'calendarista')
			, 'email'=>__('Staff Email', 'calendarista')
			, 'projectName'=>__('Service', 'calendarista')
			, 'availabilityName'=>__('Availability', 'calendarista')
			, 'action'=>__('Action', 'calendarista')
        );
        return $columns;
    }
    
    function get_sortable_columns() {
		//true means its already sorted
        $sortable_columns = array(
			'name'=>array('name', false)
			, 'email'=>array('email', false)
            , 'projectName'=> array('serviceName', false)
			, 'availabilityName'=> array('availability', false)
        );
        return $sortable_columns;
    }
    
    /**
		@description binds to data
	*/
    function bind() {
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        
        $this->_column_headers = array($columns, $hidden, $sortable);
        $currentPage = $this->get_pagenum() - 1;
		if($currentPage){
			$currentPage = $currentPage * $this->perPage;
		}
		$this->currentPage = $currentPage;
		$allowedKeys = array('id', 'projectId', 'availabilityId', 'userId', 'name', 'email', 'asc', 'desc');
        $this->orderBy = (!empty($_REQUEST[$this->orderByKey])) ? sanitize_text_field($_REQUEST[$this->orderByKey]) : 'id';
		if (!in_array($this->orderBy, $allowedKeys, true)) {
			return;
		}
        $this->order = (!empty($_REQUEST[$this->orderKey])) ? sanitize_text_field($_REQUEST[$this->orderKey]) : 'desc'; 
		if (!in_array($this->order, $allowedKeys, true)) {
			return;
		}
		$projectId = isset($_REQUEST['projectId']) ? (int)$_REQUEST['projectId'] : null;
		$userId = isset($_REQUEST['userId']) ? (int)$_REQUEST['userId'] : null;
		$availabilityId = isset($_REQUEST['availabilityId']) ? (int)$_REQUEST['availabilityId'] : null;
		$name = isset($_REQUEST['name']) ? sanitize_text_field($_REQUEST['name']) : null;
		$email = isset($_REQUEST['email']) ? sanitize_email($_REQUEST['email']) : null;
		$orderBy = isset($args['orderBy']) ? sanitize_text_field($args['orderBy']) : 'id';
		$order = isset($args['order']) ? sanitize_text_field($args['order']) : 'asc';

		$staffRepository = new Calendarista_StaffRepository();
        $result = $staffRepository->readAll(array(
			'projectId'=>$projectId
			, 'availabilityId'=>$availabilityId
			, 'userId'=>$userId
			, 'name'=>$name
			, 'email'=>$email
			, 'pageIndex'=>$currentPage
			, 'limit'=>$this->perPage
			, 'orderBy'=>$this->orderBy
			, 'order'=>$this->order
		));
        $this->count = $result['total'];
        $this->items = $result['items'];
		if(!$this->count){
			return;
		}
		$this->totalPages = ceil($this->count / $this->perPage);
        $this->set_pagination_args( array(
            'total_items' => $this->count,
            'per_page'    => $this->perPage,
            'total_pages' => $this->totalPages
        ) );
    }
	
	function get_table_classes() {
		return array('wp-list-table', 'calendarista',  'widefat', 'fixed', 'striped', 'calendarista-staff-list');
	}
	public function no_items() {
		echo __('No staff members found.', 'calendarista');
	}
	public function printVariables(){
		$list = array(
			'<input type="hidden" name="paged" value="' . $this->get_pagenum() . '">'
			, '<input type="hidden" name="orderby" value="' .  $this->orderBy . '">'
			, '<input type="hidden" name="order" value="' . $this->order . '">'
		);
		echo implode('', $list);
	}
}
?>