<?php
class Calendarista_EmailTemplateHelper{
	public static $BOOKING_PAYMENT_RECEVIED = <<<EOT
Hello {{customer_name}},
<br>This is to confirm that we have received payment regarding your booking  for a {{service_name}} that begins on {{start_datetime}} 
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}}
{{/if_has_return_trip}}
{{#if_has_group_booking}}
<br>This is a booking for {{booked_seats_count}} seats.
{{/if_has_group_booking}}
{{#if_has_dynamic_fields}}
<br>{{{dynamic_fields}}}
{{/if_has_dynamic_fields}}
{{#if_has_cost}}
	<br>The total amount paid is {{total_amount_paid}}.
{{/if_has_cost}}
<br><br>
Invoice ID: {{invoice_id}}
<br>The {{site_name}} team
EOT;
	public static $BOOKING_CONFIRMATION = <<<EOT
Hello {{customer_name}},
<br>This is to confirm your booking for {{service_name}} that begins on {{start_datetime}} 
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}} 
{{/if_has_return_trip}}
{{#if_has_cost}}
	<br>The total cost of the booking is {{total_cost_value}} {{#if_has_return_trip}} and includes the return trip {{/if_has_return_trip}}
{{/if_has_cost}}
{{#if_has_group_booking}}
<br>This is a booking for {{booked_seats_count}} seats.
{{/if_has_group_booking}}
{{#if_has_dynamic_fields}}
<br>{{{dynamic_fields}}}
{{/if_has_dynamic_fields}}
<br>
{{#if_cancel_booking_enabled}}
if you wish to cancel your booking, please <a href="{{cancel_page_url}}">click here</a>. If the link does not work, copy and paste the URL below:
<br>
{{cancel_page_url}}
<br>
{{/if_cancel_booking_enabled}}
<br>Invoice ID: {{invoice_id}}
<br><br>Thank you for booking with us.
<br>The {{site_name}} team
EOT;
	public static $BOOKING_RECEIVED_SUCCESS = <<<EOT
Hello {{customer_name}},
<br>You have made a booking for {{service_name}} that begins on {{start_datetime}} 
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}}
{{/if_has_return_trip}}
{{#if_has_from_address}}
<br>Departure from {{from_address}}
{{/if_has_from_address}}
{{#if_has_waypoints}}
<br>
Stops on the way:
<br>
{{{stops}}}
{{/if_has_waypoints}}
{{#if_has_to_address}}
<br>Destination to {{to_address}}
{{/if_has_to_address}}
{{#if_has_distance}}
	<br>The total distance is for {{distance}} {{unitType}}.
{{/if_has_distance}}
{{#if_has_duration}}
	<br>The estimated duration is {{duration}}.
{{/if_has_duration}}
{{#if_has_optionals}}
	<br>The booking includes:
	<br>{{{optionals}}}
{{/if_has_optionals}}
{{#if_has_custom_form_fields}}
	<br>During the booking, you've also told us:
	<br>{{{custom_form_fields}}}
{{/if_has_custom_form_fields}}
{{#if_has_cost}}
	<br>The total cost of the booking is {{total_cost_value}} {{#if_has_return_trip}} and includes the return trip {{/if_has_return_trip}}
{{/if_has_cost}}
{{#if_has_group_booking}}
<br>This is a booking for {{booked_seats_count}} seats.
{{/if_has_group_booking}}
{{#if_has_dynamic_fields}}
<br>{{{dynamic_fields}}}
{{/if_has_dynamic_fields}}
<br><br>
Invoice ID: {{invoice_id}}
<br><br>Thank you for booking with us.
<br>The {{site_name}} team
EOT;
	public static $BOOKING_CANCELLED = <<<EOT
Hello {{customer_name}},
<br>Your booking for {{service_name}} that begins on {{start_datetime}}
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}} 
{{/if_has_return_trip}}
has been cancelled and is no longer valid.
<br>
Invoice ID: {{invoice_id}}
<br><br>Thank you for having booked with us.
<br>The {{site_name}} team
EOT;
	public static $BOOKING_CANCELLED_ALERT = <<<EOT
Hello {{service_provider_name}},
<br>A booking for {{service_name}} that begins on {{start_datetime}} 
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}} 
{{/if_has_return_trip}}
has been cancelled by the customer and is no longer valid.
<br>
Invoice ID: <a href="{{appointment_management_url}}">{{invoice_id}}</a>
<br>The {{site_name}} team
EOT;
	public static $BOOKING_REMINDER = <<<EOT
Hello {{customer_name}},
<br>Your booking for {{service_name}} that begins on {{start_datetime}}
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}} 
{{/if_has_return_trip}}
<br>
Invoice ID: {{invoice_id}}
<br><br>Thank you for having booked with us.
<br>The {{site_name}} team
EOT;
	public static $NEW_BOOKING_RECEIVED = <<<EOT
Hello {{service_provider_name}},
<br>A booking for {{service_name}} that begins on {{start_datetime}} 
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}} 
{{/if_has_return_trip}}
has been made. 
<br><br>
Invoice ID: <a href="{{appointment_management_url}}">{{invoice_id}}</a>
<br><br>The {{site_name}} team
EOT;
	public static $COUPON = <<<EOT
Hello {{customer_name}},
<br>You have received a {{discount_amount}} coupon. You can redeem this coupon during checkout. 
<br>The coupon code is: <strong>{{coupon_code}}</strong>.
{{#if_limited_by_service}}
<br><br>This coupon can be claimed on {{service_name}} only.
{{/if_limited_by_service}}
<br><br>When it comes to saving money, we are your friend.
<br>The {{site_name}} team
EOT;
	public static $PAYMENT_REQUIRED = <<<EOT
Hello {{customer_name}},
<br>Your booking for {{service_name}} is pending payment.
<br>
Payment instructions below:
<br><br>
Invoice ID: {{invoice_id}}
<br><br>Thank you.
<br>The {{site_name}} team
EOT;
	public static $BOOKING_HAS_CHANGED = <<<EOT
Hello {{customer_name}},
<br>This is to inform you that your booking for {{service_name}} has been changed and now begins on {{start_datetime}} 
{{#if_has_end_date}} 
	through {{end_datetime}} 
{{/if_has_end_date}} 
{{#if_has_return_trip}} 
	and a return trip on {{end_datetime}} 
{{/if_has_return_trip}}
{{#if_has_cost}}
	<br>The total cost of the booking is {{total_cost_value}} {{#if_has_return_trip}} and includes the return trip {{/if_has_return_trip}}
{{/if_has_cost}}
{{#if_has_group_booking}}
<br>This is a booking for {{booked_seats_count}} seats.
{{/if_has_group_booking}}
{{#if_has_dynamic_fields}}
<br>{{{dynamic_fields}}}
{{/if_has_dynamic_fields}}
<br><br>
Invoice ID: {{invoice_id}}
<br><br>Thank you for booking with us.
<br>The {{site_name}} team
EOT;
	public static $GDPR = <<<EOT
Hello {{customer_name}},
<br>This is to inform you that if you ever need to download a copy of your appointments to verify the data stored on your account, 
you may do so by following the link below:
{{gdpr_url}}
<br><br>
You may also use the above link to delete your appointment history and associated data.
<br>
Please do not share this link with anyone and ensure you access it from a secure location.
<br><br>Thank you for booking with us.
<br>The {{site_name}} team
EOT;
	public static $APPOINTMENT_OUT_OF_STOCK = <<<EOT
Hello {{customer_name}},
<br>The appointment you tried to book is no longer available. If you tried paying for it, we did not charge you. Feel free to book another available date.
<br>The {{site_name}} team
EOT;
	public static $GOOGLE_CALENDAR_AUTHENTICATION_FAILURE = <<<EOT
Hello {{service_provider_name}},
<br>This is to let you know that an error has occurred when trying to sync your appointment to Google Calendar. 
To view the error, please go to the Settings -> Error Log page. 
<br>
<br>Google will invalidate your authentication token from time to time so this is the most likely cause.
In order to resolve, please go to the Settings -> Connect page. If you do not see the "Authorize" button, click update on the Google profile once. 
<br>
This will enable the Authorize button. Use it to authenticate again.
<br><br>The {{site_name}} team
EOT;
	public static $BOOKING_THANKYOU_REMINDER = <<<EOT
Hello {{customer_name}},
Please rate us if you have time.
<br><br>Thank you for having booked with us.
<br>The {{site_name}} team
EOT;
	public static $MASTER_TEMPLATE = <<<EOT
			
<html>
	<head>
		<meta name="viewport" content="width=device-width">
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
				<title>{{site_name}}</title>
			</head>
			<body style="height: 100%; width: 100% !important;margin: 0 !important;color:{{body_font_color}};background-color:#ffffff">
				<!-- HEADER -->
				<table style="width: 100%;color:{{header_font_color}};background-color:{{header_background_color}}">
					<tr>
						<td></td>
						<td style="margin: 0 auto !important;max-width: 600px !important;">
							<div style="margin: 0 auto; padding: 15px; max-width: 600px;">
								<table style="width: 100%;">
									<tr>
										<td>
											<!--Your logo goes below-->
											{{#has_header_image}}
											<img src="{{header_image}}" style="max-width: 100%;">
											{{/has_header_image}}
											</td>
											<td align="right">
												<h6 class="collapse" style="margin: 0!important; padding: 0; margin-bottom: 15px; text-transform: uppercase;">
													{{{site_title}}}
												</h6>
											</td>
										</tr>
									</table>
								</div>
							</td>
							<td></td>
						</tr>
					</table>
					<!-- /HEADER -->
					<!-- BODY -->
					<table style="width: 100%;">
						<tr>
							<td></td>
							<td style="margin: 0 auto!important;max-width: 600px!important;">
								<div class="content" style="margin: 0 auto; padding: 15px; max-width: 600px;">
									<table style="width: 100%;">
										<tr>
											<td>
													<!--Your content goes below-->
													{{{mail_content}}}
											</td>
										</tr>
									</table>
								</div>
							</td>
							<td></td>
						</tr>
					</table>
					<!-- /BODY -->
					<!-- FOOTER -->
					<table style="width: 100%;">
						<tr>
							<td></td>
							<td style="margin: 0 auto !important;max-width: 600px !important;">
								<div style="margin: 0 auto; padding: 15px; max-width: 600px;">
									<table style="width: 100%;">
										<tr>
											<td align="center" >
												<p style="margin: 0; padding: 0; margin-bottom: 10px;">
													<!--Your footer goes below-->
													@ Copyright {{current_year}} 
													<a href="{{site_url}}">{{site_name}}</a>. All rights reserved.
												</p>
											</td>
										</tr>
									</table>
								</div>
							</td>
							<td></td>
						</tr>
					</table>
					<!-- /FOOTER -->
				</body>
			</html>
EOT;
	public static function getTemplates(){
		return array(
			array('emailType'=>0, 'name'=>'master_template', 'subject'=>__('Master template', 'calendarista'), 'content'=>self::$MASTER_TEMPLATE)
			, array('emailType'=>1, 'name'=>'new_booking_received', 'subject'=>__('New booking received', 'calendarista'), 'content'=>self::$NEW_BOOKING_RECEIVED)
			, array('emailType'=>2, 'name'=>'booking_received_successfully', 'subject'=>__('Booking received successfully', 'calendarista'), 'content'=>self::$BOOKING_RECEIVED_SUCCESS)
			, array('emailType'=>3, 'name'=>'booking_confirmation', 'subject'=>__('Booking confirmation', 'calendarista'), 'content'=>self::$BOOKING_CONFIRMATION)
			, array('emailType'=>4, 'name'=>'booking_cancelled', 'subject'=>__('Booking cancelled', 'calendarista'), 'content'=>self::$BOOKING_CANCELLED)
			, array('emailType'=>5, 'name'=>'booking_reminder', 'subject'=>__('Booking reminder', 'calendarista'), 'content'=>self::$BOOKING_REMINDER)
			, array('emailType'=>6, 'name'=>'booking_payment_received', 'subject'=>__('Booking payment received', 'calendarista'), 'content'=>self::$BOOKING_PAYMENT_RECEVIED)
			, array('emailType'=>7, 'name'=>'discount_coupon_awarded', 'subject'=>__('Discount coupon awarded', 'calendarista'), 'content'=>self::$COUPON)
			, array('emailType'=>8, 'name'=>'payment_required', 'subject'=>__('Payment required', 'calendarista'), 'content'=>self::$PAYMENT_REQUIRED)
			, array('emailType'=>9, 'name'=>'booking_has_changed', 'subject'=>__('Booking has changed', 'calendarista'), 'content'=>self::$BOOKING_HAS_CHANGED)
			, array('emailType'=>10, 'name'=>'gdpr', 'subject'=>__('General data protection regulation', 'calendarista'), 'content'=>self::$GDPR)
			, array('emailType'=>11, 'name'=>'booking_cancelled_alert', 'subject'=>__('Booking cancelled alert', 'calendarista'), 'content'=>self::$BOOKING_CANCELLED_ALERT)
			, array('emailType'=>12, 'name'=>'appointment_out_of_stock', 'subject'=>__('Appointment out of stock', 'calendarista'), 'content'=>self::$APPOINTMENT_OUT_OF_STOCK)
			, array('emailType'=>13, 'name'=>'google_calendar_authentication_failure', 'subject'=>__('Google Calendar authentication failure', 'calendarista'), 'content'=>self::$GOOGLE_CALENDAR_AUTHENTICATION_FAILURE)
			, array('emailType'=>14, 'name'=>'booking_thankyou_reminder', 'subject'=>__('Booking thankyou reminder', 'calendarista'), 'content'=>self::$BOOKING_THANKYOU_REMINDER)
		);
	}
	public static function getTemplate($emailType){
		$templates = self::getTemplates();
		return isset($templates[$emailType]) ? new Calendarista_EmailSetting($templates[$emailType]) : null;
	}
	public static function sendNotifications($order){
		$emails = array();
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		$emailer = null;
		if($generalSetting->enableGDPR){
			$authRepo = new Calendarista_AuthRepository();
			$password = Calendarista_AuthRepository::genPassword($order->email);
			$authRepo->insert(array('password'=>$password, 'userEmail'=>$order->email));
			$emailer = new Calendarista_GdprEmailer($order->email, $order->fullName, $password);
		}
		if($generalSetting->autoNotifyAdminNewBooking){
			$staffMembers = Calendarista_PermissionHelper::readStaffMembers(2/*include staffmember object*/, $order->availabilityId);
			if($staffMembers && count($staffMembers) > 0){
				foreach($staffMembers as $staff){
					array_push($emails, array('address'=>$staff['email'], 'type'=>Calendarista_EmailType::NEW_BOOKING_RECEIVED));
				}
			}else{
				array_push($emails, array('type'=>Calendarista_EmailType::NEW_BOOKING_RECEIVED));
			}
		}
		if($generalSetting->notifyBookingReceivedSuccessfully){
			array_push($emails, array('type'=>Calendarista_EmailType::BOOKING_RECEIVED_SUCCESS));
		}
		if($generalSetting->autoApproveBooking && $generalSetting->notifyBookingConfirmation){
			array_push($emails, array('type'=>Calendarista_EmailType::BOOKING_CONFIRMATION));
		}
		foreach($emails as $email){
			$notification = new Calendarista_NotificationEmailer(array(
				'orderId'=>$order->id
				, 'emailType'=>$email['type']
			));
			if(isset($email['address'])){
				$notification->send($email['address']);
			}else{
				$notification->send();
			}
		}
		if($emailer){
			$emailer->send();
		}
	}
	public function sendGdprEmail($customerName, $customerEmail){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		if($generalSetting->enableGDPR){
			$authRepo = new Calendarista_AuthRepository();
			$password = Calendarista_AuthRepository::genPassword($customerEmail);
			$authRepo->insert(array('password'=>$password, 'userEmail'=>$customerEmail));
			$emailer = new Calendarista_GdprEmailer($customerEmail, $customerName, $password);
			$emailer->send();
		}
	}
}
?>