<?php
class Calendarista_TranslationHelper{
	public static function register($name, $value, $multiLine = false){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		$translationEngine = $generalSetting->translationEngine;
		if(in_array($translationEngine, array(1, 2)) && function_exists('icl_register_string')){
			icl_register_string('calendarista', $name, stripcslashes($value));
		}
	}
	
	public static function unregister($name){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		$translationEngine = $generalSetting->translationEngine;
		//no polylang alternative
		if(in_array($translationEngine, array(1, 2)) && function_exists('icl_unregister_string')){
			icl_unregister_string('calendarista', $name);
		}
	}
	
	public static function t($name, $value){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		$translationEngine = $generalSetting->translationEngine;
		if($translationEngine === 1 && function_exists('icl_t')){
			return icl_t('calendarista', $name, stripcslashes((string)$value));
		}else if($translationEngine === 2 && function_exists('pll__')){
			return pll__(stripcslashes($value));
		}
		return stripcslashes((string)$value);
	}
	
	public static function registerEmailResource(){
		$templates = Calendarista_EmailTemplateHelper::getTemplates();
		foreach($templates as $template){
			$name = 'email_template_' . $template['name'];
			$result = self::t($name, '');
			if($result){
				//already registered, bailout
				break;
			}
			$emailSettingRepository = new Calendarista_EmailSettingRepository($template['emailType']);
			$emailSetting = $emailSettingRepository->read();
			if(!$emailSetting){
				$emailSetting = Calendarista_EmailTemplateHelper::getTemplate($template['emailType']);
			}
			$emailSetting->updateResources();
		}
	}
	public static function requiresTranslation(){
		$generalSetting = Calendarista_GeneralSettingHelper::get();
		if(!$generalSetting->translationEngine){
			return false;
		}
		//resource greedy check and pretty useless, hence discontinued.
		/*
		require_once ABSPATH . '/wp-admin/includes/plugin.php';
		if($generalSetting->translationEngine === 1 && is_plugin_active('sitepress-multilingual-cms/sitepress.php')){
			return true;
		}else if($generalSetting->translationEngine === 2 && 
							(is_plugin_active('polylang/polylang.php') || is_plugin_active('polylang-pro/polylang.php'))){
			return true;
		}*/
		return true;
	}
	public static function internationalization($pluginName = 'calendarista', $rootFolder = null){
		if(!$rootFolder){
			$rootFolder = CALENDARISTA_LANGUAGES_FOLDER;
		}
		$locale = apply_filters('plugin_locale',  get_locale(), $pluginName);
		$mofile = sprintf('%s-%s.mo', $pluginName, $locale);

		$langFileLocal  = WP_PLUGIN_DIR . '/' . CALENDARISTA_LANGUAGES_FOLDER . $mofile;
		$langFileGlobal = WP_LANG_DIR . '/' . $pluginName . '/' . $mofile;

		if (file_exists($langFileGlobal)){
			//the wordpress /wp-content/languages/calendarista directory
			load_textdomain($pluginName, $langFileGlobal);
		}elseif(file_exists($langFileLocal)){
			//this plugins languages directory
			load_textdomain($pluginName, $langFileLocal);
		}else{
			//default language file
			load_plugin_textdomain($pluginName, false, $rootFolder);
		}
	}
}
?>