<?php
require_once CALENDARISTA_TWILIO;
use Twilio\Rest\Client;
class Calendarista_TwilioHelper{
    public function __construct() { 
		
	}
	public function sendMessage($message, $to){
		$setting = Calendarista_GeneralSettingHelper::get();
		try {
            $client = new Client($setting->twilioAccountSID, $setting->twilioAuthToken);
			$to = preg_replace('/^[0]{2}/', '+', $to);
			if($setting->twilioCountryCode && substr($to, 0, 1) !== '+'){
				$to = preg_replace('/^[0]{2}/', '+', $setting->twilioCountryCode) . $to;
			}else{
				$to = preg_replace('/^[0]{2}/', '+', $to);
			}
			$from = preg_replace('/^[0]{2}/', '+', $setting->twilioFromNumber);
            $response = $client->messages->create(
                $to,
                array(
                    "from" =>$from
                    , "body" =>$message
                )
            );
        } catch (Exception $e) {
            Calendarista_ErrorLogHelper::insert($e->getMessage());
        }
	}
}
?>