<?php
class Calendarista_UpdatesRequestHelper{
	private function __construct() { }
	//calendarista-updates
	public static function verify($code){
		$verifyUrl = 'https://updates.calendarista.com/verify.php?code='.$code;
		return self::request($code, $verifyUrl);
	}
	public static function test($code){
		$testUrl = 'https://updates.calendarista.com/rs.php?code='.$code;
		return self::request($code, $testUrl);
	}
    public static function request($code, $url){
		//setting the header for the rest of the api
		$header   = array();
		$header[] = 'Content-length: 0';
		$header[] = 'Content-type: text/plain; charset=utf-8';
		
		$ch_verify = curl_init($url);

		curl_setopt($ch_verify, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch_verify, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch_verify, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch_verify, CURLOPT_CONNECTTIMEOUT, 20);
		curl_setopt($ch_verify, CURLOPT_REFERER, home_url());
		curl_setopt($ch_verify, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');

		$res = curl_exec($ch_verify);
		if ($res === false){
            $errno = curl_errno($ch_verify);
            $errstr = curl_error($ch_verify);
            curl_close($ch_verify);
			Calendarista_ErrorLogHelper::insert("cURL error: [$errno] $errstr");
			return false;
        }
		curl_close($ch_verify);
		if ($res != ''){
			return is_numeric($res) ? (int)$res : $res;  
		}else{
			return false;
		}
    }
}
?>