<?php
class Calendarista_BookingDynamicFieldsTmpl extends Calendarista_TemplateBase{
	public $seats = 0;
	public $seatsMax = 0;
	public $appointment;
	public $dynamicFields;
	public $availability;
	public $defaultValue;
	public function __construct(){
		parent::__construct();
		//we only need the selected seat value, if none is provided then select the first min/max found and use that.
		//if there is no min/max, then bail out.
		$availabilityId = (int)$this->getPostValue('availabilityId');
		$this->appointment = (int)$this->getPostValue('appointment', -1);
		$this->seats = (int)$this->getPostValue('seats');
		$this->seatsMax = (int)$this->getPostValue('seatsMax');
		//begin
		//check the selected seat value and based on that select the 
		// seat whose min/max corresponds. if no match is found, min defaults to 1 and max defaults to seat value
		$repo = new Calendarista_DynamicFieldRepository();
		$result = $repo->readByAvailabilityId(array('availabilityId'=>$availabilityId));
		$repo = new Calendarista_AvailabilityRepository();
		$this->availability = $repo->read($availabilityId);
		$this->dynamicFields = $result['resultset'];
		$this->defaultValue = trim($this->stringResources['GUESTS_NONE']);
		$this->render();
	}
	public function getFieldValue($items){
		if(count($items) === 0){
			return null;
		}
		return $items[0];
	}
	public function selectField($id, $value){
		$items = $this->getViewStateValue('dynamicFields');
		if(!is_array($items)){
			return null;
		}
		foreach($items as $item){
			if($item['id'] == $id && $item['value'] == $value){
				return 'selected=selected';
			}
		}
		return null;
	}
	public function render(){
		$seats = $this->seats;
	?>
	<?php foreach($this->dynamicFields as $field):?>
	<?php 
		$val = $this->getFieldValue($field->data);
		if($field->limitBySeat){
			if($this->availability->selectableSeats || $val['max'] > $this->seatsMax){
				$val['max'] = $this->seatsMax;
			}
			$seats = $this->availability->selectableSeats ? $this->seats : 0;
		}else{
			$seats = 0;
		}
		if(!$val || count($val) === 0){continue;}
	?>
	<div class="col-xl-12">
		<div class="form-group">
			<label class="form-control-label calendarista-typography--caption1" for="calendarista_dynamicfield_<?php echo $field->id ?>">
				<?php echo Calendarista_StringResourceHelper::decodeString($field->label) ?>
			</label>
			<div>
				<select id="calendarista_dynamicfield_<?php echo $field->id ?>"
					name="calendarista_dynamicfield_<?php echo $field->id ?>"
					class="form-select calendarista-dynamicfield <?php echo $field->required ? 'calendarista_parsley_validated' : '' ?>"
					<?php echo $field->required ? 'data-parsley-required="true"' : '' ?>
					data-calendarista-limit="<?php echo $field->limitBySeat ? 1 : 0 ?>">
					<?php if($this->defaultValue != ''):?>
					<option value=""><?php echo $this->defaultValue ?></option>
					<?php endif; ?>
					<?php for($i = 0; $i <= $val['max']; $i++): ?>
					<?php if($i < $val['min'] || ($seats && ($i > $seats))){continue;} ?>
					<option value="<?php echo $i ?>" data-calendarista-value="<?php echo $i ?>"
						<?php echo $this->selectField($field->id, $i); ?>><?php echo $i ?></option>
					<?php endfor; ?>
				</select>
			</div>
		</div>
	</div>
	<?php endforeach; ?>
<?php
	}
}
