<?php
class Calendarista_PaymentWooCommerceTmpl extends Calendarista_TemplateBase{
	public $wooCartURL;
	public $currency;
	public $fullName;
	public $firstname;
	public $lastname;
	public $email;
	public $optionalCost;
	public $subTotalAmount;
	public $totalAmount;
	public $totalAmountBeforeDeposit;
	public $fullAmountDiscount;
	public $itemName;
	public $summary;
	public $availabilityList;
	public $optionals;
	public $customFormElements;
	public $dynamicFields;
	public $seats;
	public $depositNotification;
	public $thumbnail;
	public $wooSetting;
	public $stagingId;
	public function __construct($setting, $stagingId){
		parent::__construct();
		$this->wooSetting = $setting;
		$this->stagingId = $stagingId;
		if(!has_filter('calendarista_checkout_summary')) {
			return;
		}
		$checkoutSummary = apply_filters('calendarista_checkout_summary', false);
		if($checkoutSummary['totalAmount'] > 0){
			$this->fullname = $checkoutSummary['name'];
			$this->firstname = $checkoutSummary['firstname'];
			$this->lastname = $checkoutSummary['lastname'];
			$this->email = $checkoutSummary['email'];
			$this->optionalCost = $checkoutSummary['optionalCost'];
			$this->subTotalAmount = $checkoutSummary['subTotalAmount'];
			$this->totalAmount = $checkoutSummary['totalAmount'];
			$this->totalAmountBeforeDeposit = $checkoutSummary['totalAmountBeforeDeposit'];
			$this->fullAmountDiscount = $checkoutSummary['fullAmountDiscount'];
			$this->currency = $checkoutSummary['currency'];
			$this->summary = apply_filters('calendarista_checkout_summary_field', $checkoutSummary['summary'], $this->viewState);
			$this->availabilityList = $checkoutSummary['availabilityList'];
			$this->optionals = implode('', $checkoutSummary['optionals']);
			if($this->optionals){
				$this->optionals = sprintf('<table><tbody>%s</tbody></table>', $this->optionals); 
			}
			$this->customFormElements = $checkoutSummary['customFormElements'];
			$this->dynamicFields = $checkoutSummary['dynamicFields'];
			$this->seats = $checkoutSummary['seats'];
			$this->thumbnail = $checkoutSummary['thumbnail'];
			$this->depositNotification = $checkoutSummary['depositNotification'];
			$this->itemName = sprintf($this->stringResources['PAYMENT_ITEM_NAME'], $checkoutSummary['serviceName'], $this->availabilityList ? '' : $checkoutSummary['availabilityName']);
			$this->confirmUrl = $this->getConfirmUrl($this->requestUrl, $stagingId);
			$this->wooCartURL = $this->generalSetting->wooCommerceCheckoutUrl;
			$this->render();
		}
	}
	public function getUpfrontAmount($val){
		$fullAmountDiscount = $this->fullAmountDiscount;
		if($fullAmountDiscount && $this->seats > 1){
			$fullAmountDiscount = $fullAmountDiscount * $this->seats;
		}
		if($fullAmountDiscount > 0 && 
			$this->totalAmountBeforeDeposit > $fullAmountDiscount){
			$discountedValue = $this->totalAmountBeforeDeposit - $fullAmountDiscount;
			return $discountedValue;
		}else if($this->totalAmountBeforeDeposit > 0){
			return $this->totalAmountBeforeDeposit;
		}
		return $val;
	}
	public function render(){
	?>
		<form action="<?php echo $this->wooCartURL ?>" method="post" id="payment-operator-<?php echo sprintf('%d-%d', $this->wooSetting->id, $this->projectId) ?>" 
			data-calendarista-payment-operator="woo" data-calendarista-original-total="<?php echo $this->totalAmount ?>">
			<input type="hidden" name="add-to-cart" value="<?php echo $this->wooSetting->wooProductId ?>" />
			<input type="hidden" name="calendarista_seats" value="<?php echo $this->seats ?>"/>
			<input type="hidden" name="calendarista_summary" value="<?php echo htmlentities(serialize($this->summary)) ?>" />
			<input type="hidden" name="calendarista_availability_list" value="<?php echo $this->availabilityList ? htmlentities(serialize($this->availabilityList)) : '' ?>" />
			<input type="hidden" name="calendarista_optionals" value="<?php echo htmlentities(serialize($this->optionals)) ?>" />
			<input type="hidden" name="calendarista_custom_form_elements" value="<?php echo htmlentities(serialize($this->customFormElements)) ?>" />
			<input type="hidden" name="calendarista_dynamic_fields" value="<?php echo htmlentities(serialize($this->dynamicFields)) ?>" />
			<input type="hidden" name="calendarista_deposit" value="<?php echo htmlentities(serialize($this->depositNotification)) ?>" />
			<input type="hidden" name="calendarista_thumbnail" value="<?php echo $this->thumbnail ?>">
			<input type="hidden" name="calendarista_currency_code" value="<?php echo $this->currency ?>">
			<input type="hidden" name="calendarista_staging_id" value="<?php echo $this->stagingId ?>">
			<input type="hidden" name="calendarista_item_name" value="<?php echo $this->itemName ?>">
			<input type="hidden" name="calendarista_optional_cost" value="<?php echo $this->optionalCost ?>">
			<input type="hidden" name="calendarista_subtotal_amount" value="<?php echo $this->subTotalAmount ?>">
			<input type="hidden" name="calendarista_amount" value="<?php echo $this->totalAmount ?>">
			<input type="hidden" name="calendarista_upfront_amount" value="<?php echo $this->getUpfrontAmount($this->totalAmount) ?>">
			<input type="hidden" name="calendarista_amount_before_deposit" value="<?php echo $this->totalAmountBeforeDeposit ?>">
			<input type="hidden" name="calendarista_full_name" value="<?php echo $this->fullName ?>">
			<input type="hidden" name="billing_first_name" value="<?php echo $this->firstname?>">
			<input type="hidden" name="billing_last_name" value="<?php echo $this->lastname ?>">
			<input type="hidden" name="billing_email" value="<?php echo $this->email ?>">
			<input type="hidden" name="calendarista_return" value="<?php echo $this->confirmUrl ?>">
			<input type="hidden" name="calendarista_cancel_return" value="<?php echo $this->requestUrl ?>">
			<input type="hidden" name="calendarista_notify_url" value="<?php echo sprintf('%s?calendarista_handler=woo', home_url('/'))?>">
			<input type="hidden" name="calendarista_full_amount_discount" value="<?php echo $this->fullAmountDiscount ?>">
			<input type="hidden" name="calendarista_full_amount_discount_label" value="<?php echo $this->stringResources['PAYMENT_FULL_AMOUNT_DISCOUNT_LABEL'] ?>">
			<input type="hidden" name="calendarista_full_amount_paid_label" value="<?php echo $this->stringResources['PAYMENT_FULL_AMOUNT_PAID_LABEL'] ?>">
			<input type="hidden" name="upfrontPayment" value="0">
		</form>
	<?php
	}
}?>

