<?php
class Calendarista_UserProfileTmpl extends Calendarista_TemplateBase{
	public $upcomingLabel;
	public $historyLabel;
	public $enableEdit;
	public $editPolicy;
	public function __construct($upcomingLabel, $historyLabel, $enableEdit, $editPolicy){
		$this->upcomingLabel = $upcomingLabel;
		$this->historyLabel = $historyLabel;
		$this->enableEdit = $enableEdit;
		$this->editPolicy = $editPolicy;
		parent::__construct();
		$this->render();
	}
	public function render(){
	?>
		<div id="calendarista_userprofile" class="calendarista">
			<div class="card">
					<ul class="nav nav-tabs calendarista-typography--caption1">
					  <li class="nav-item">
						<a class="nav-link active" data-calendarista-index="1" aria-current="page" href="#"><?php echo $this->upcomingLabel ?></a>
					  </li>
					  <li class="nav-item">
						<a class="nav-link" data-calendarista-index="2" href="#"><?php echo $this->historyLabel ?></a>
					  </li>
					  <li class="nav-item">
						<span class="nav-link">
							<div id="spinner_userprofile" class="spinner-border calendarista-user-profile-spinner text-primary calendarista-invisible" role="status">
							  <span class="sr-only"><?php echo $this->stringResources['AJAX_SPINNER']?></span>
							</div>
						</span>
					  </li>
					</ul>
				<div class="card-body">
					<div class="container">
						<div class="col-xl-12 calendarista-row-single calendarista-userprofile-placeholder"></div>
						<?php if($this->enableEdit): ?>
						<div id="calendarista-edit-appointments-modal" class="calendarista"
							title="<?php echo __('Edit appointment', 'calendarista') ?>">
							<div class="container-fluid">
								<div id="calendarista-edit-appointment-placeholder"></div>
							</div>
						</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
		(function(){
			"use strict";
			function init(){
				new Calendarista.userprofile({
					'id': 'calendarista_userprofile'
					, 'ajaxUrl': '<?php echo $this->ajaxUrl ?>'
					, 'enableEdit': <?php echo $this->enableEdit ? 'true' : 'false' ?>
					, 'editPolicy': <?php echo $this->editPolicy ? $this->editPolicy : 0 ?>
					, 'pluginDir': '<?php echo CALENDARISTA_PLUGINDIR ?>'
				});
			}
			<?php if($this->notAjaxRequest):?>
			if (window.addEventListener){
			  window.addEventListener('load', onload, false); 
			} else if (window.attachEvent){
			  window.attachEvent('onload', onload);
			}
			function onload(e){
				init();
			}
			<?php else: ?>
			init();
			<?php endif; ?>
		})();
		</script>
	<?php
	}
}