<?php
class Calendarista_EditStaffTemplate extends Calendarista_ViewBase{
	public $id;
	public $staff;
	public $availabilityId;
	public $partialRender = false;
	public $availabilities = array();
	function __construct( ){
		parent::__construct(false, true, 'calendarista-staff');
		$this->id = (isset($_POST['id']) && $_POST['id']) ? (int)$_POST['id'] : null;
		$this->availabilityId = isset($_POST['availabilityId']) ? (int)$_POST['availabilityId'] : null;
		new Calendarista_StaffController(
			array($this, 'create')
			, array($this, 'update')
			, array($this, 'delete')
		);
		if($this->id !== null){
			$staffRepo = new Calendarista_StaffRepository();
			$this->staff = $staffRepo->read($this->id);
			if($this->staff){
				$this->selectedProjectId = $this->staff['projectId'];
				$this->availabilityId = $this->staff['availabilityId'];
			}
		}
		if(!$this->staff){
			$this->staff = array(
				'projectId'=>null
				, 'availabilityId'=>null
				, 'name'=>null
				, 'email'=>null
			);
		}
		if($this->selectedProjectId !== -1){
			$repo = new Calendarista_AvailabilityRepository();
			$this->availabilities = $repo->readAll($this->selectedProjectId);
			if(!$this->availabilities){
				$this->availabilities = array();
			}
		}
		if(!$this->partialRender){
			$this->render();
		}
	}
	function create($result, $email){
		if($result){
			$this->partialRender = true;
			return $this->createNotification($email);
		}
		?>
		<div class="wrap">
			<div class="calendarista-notice error notice is-dismissible">
				<p><?php echo sprintf(__('Failed. Ensure that %s is a registered user in WordPress.', 'calendarista'), $email); ?></p>
			</div>
			<hr>
		</div>
		<?php
	}
	function update($result, $email){
		if($result){
			return $this->updateNotification($email);
		}
		?>
		<div class="wrap">
			<div class="calendarista-notice error notice is-dismissible">
				<p><?php echo sprintf(__('Failed. Ensure that %s is a registered user in WordPress.', 'calendarista'), $email); ?></p>
			</div>
			<hr>
		</div>
		<?php
	}
	function delete($id, $result){
		if($result){
			$this->partialRender = true;
			$this->deleteNotification($id);
		}
	}
	function createNotification($email){
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo sprintf(__('%s staff member can now manage selected service', 'calendarista'), $email); ?></p>
			</div>
			<hr>
		</div>
		<?php
	}
	public function updateNotification($name) {
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo sprintf(__('The staff member %s has been updated', 'calendarista'), $name); ?></p>
			</div>
			<hr>
		</div>
		<?php
	}
	public function deleteNotification($id) {
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo __('The staff member has been deleted', 'calendarista'); ?></p>
			</div>
			<hr>
		</div>
		<?php
	}
	public function render(){
	?>
	<div class="wrap">
		<form id="form1" data-parsley-validate method="post">
			<input type="hidden" name="id" value="<?php echo $this->id; ?>">
			<input type="hidden" name="calendarista_nonce" value="<?php echo wp_create_nonce('calendarista-ajax-nonce') ?>"/>
			<table class="form-table">
				<tbody>
					<tr>
						<th scope="row">
							<label for="projectId">
								<?php echo __('Service', 'calendarista') ?>
							</label>
						</th>
						<td>
							<?php if(is_null($this->id)): ?>
							<?php $this->renderProjectSelectList(true, __('Select a services', 'calendarista'), true, true) ?>
							<span id="spinner_availability_list" class="calendarista-spinner calendarista-invisible">
								<img src="<?php echo CALENDARISTA_PLUGINDIR ?>assets/img/transparent.gif">
							</span>
							<?php else: ?>
							<?php echo $this->staff['projectName'] ?>
							<?php endif; ?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="availabilityId"><?php echo __('Availability', 'calendarista')?></label>
						</th>
						<td>
							<?php if(is_null($this->id)): ?>
							<select name="availabilityId" data-parsley-required="true" class="calendarista_parsley_validated" data-parsley-errors-messages-disabled="true">
								<option value=""><?php echo __('Select an availability', 'calendarista') ?></option>
								<?php if($this->availabilities):?>
									<?php foreach($this->availabilities as $availability):?>
										<option value="<?php echo $availability->id ?>" <?php echo $availability->id === $this->availabilityId ? 'selected' : ''?>><?php echo $availability->name ?></option>
									<?php endforeach;?>
								<?php endif;?>
							</select> 
							<?php else: ?>
							<?php echo $this->staff['availabilityName'] ?>
							<?php endif; ?>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="name"><?php echo __('Staff name', 'calendarista')?></label>
						</th>
						<td>
						  <input type="text" 
								id="name" 
								name="name" 
								class="regular-text calendarista_parsley_validated"
								data-parsley-required="true"
								data-parsley-trigger="change" 
								value="<?php echo $this->staff['name']?>">
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="email"><?php echo __('Staff email', 'calendarista')?></label>
						</th>
						<td>
						  <input type="text" 
								id="email" 
								name="email" 
								class="regular-text calendarista_parsley_validated"
								data-parsley-required="true"
								data-parsley-trigger="change" 
								data-parsley-type="email"
								value="<?php echo $this->staff['email']?>">
						</td>
					</tr>
				</tbody>
			</table>
		</form>
	</div>
		<script type="text/javascript">
			(function($, wp){
				var calendarista = window['calendarista'] ? window['calendarista'] : function(){};
				calendarista.createDelegate = function (instance, method) {
					return function () {
						return method.apply(instance, arguments);
					};
				};
				calendarista.editStaff = function(options){
					var context = this;
					$(window).ready(function(){
						context.init(options);
					});
				};
				calendarista.editStaff.prototype.init = function(options){
					var context = this;
					this.ajaxUrl = wp.url;
					this.nonce = wp.nonce;
					this.requestUrl = options['requestUrl'];
					this.actionGetAvailabilities = 'calendarista_get_availabilities';
					this.$root = $('#form1');
					this.$searchFilterProjectList = this.$root.find('select[name="projectId"]');
					this.$availabilityList = this.$root.find('select[name="availabilityId"]');
					this.ajax1 = new Calendarista.ajax({'ajaxUrl': this.ajaxUrl, 'id': 'availability_list'});
					this.$searchFilterProjectList.on('change', function(e){
						var val = parseInt($(this).val(), 10)
							, model = [
								{ 'name': 'projectId', 'value': val}
								, { 'name': 'defaultLabel', 'value': '<?php echo __("Select an availability", "calendarista") ?>'}
								, { 'name': 'defaultValue', 'value': ''}
								, { 'name': 'action', 'value': context.actionGetAvailabilities }
								, { 'name': 'calendarista_nonce', 'value': context.nonce }
							];
						context.ajax1.request(context, context.availabilitiesResponse, $.param(model));
					});
				};
				calendarista.editStaff.prototype.availabilitiesResponse = function(result){
					this.$availabilityList[0].length = 0;
					this.$availabilityList.append(result);
				};
			window['calendarista'] = calendarista;
		})(window['jQuery'], window['calendarista_wp_ajax']);
		new calendarista.editStaff({
			'requestUrl': '<?php echo $_SERVER['REQUEST_URI'] ?>'
		});
		</script>
		<?php
	}
}