<?php
class Calendarista_SetupStep1Template extends Calendarista_ViewBase{
	public $calendarMode;
	public $wooProducts;
	public $fields;
	public $welcome;
	function __construct( ){
		parent::__construct(false, true, 'calendarista-setup');
		$this->calendarMode = Calendarista_CalendarMode::toArray();
		$this->wooProducts = Calendarista_WooCommerceHelper::getProducts();
		$this->fields = $this->getFields();
		$this->welcome = isset($_GET['welcome']) ? true : false;
		$this->render();
	}
	function getFields(){
		$result = array('name'=>null, 'calendarMode'=>0, 'paymentsMode'=>-1, 'wooProductId'=>null);
		if(isset($_POST['name'])){
			$result['name'] = $_POST['name'];
		}
		if(isset($_POST['calendarMode'])){
			$result['calendarMode'] = (int)$_POST['calendarMode'];
		}
		if(isset($_POST['paymentsMode'])){
			$result['paymentsMode'] = (int)$_POST['paymentsMode'];
		}
		if(isset($_POST['wooProductId'])){
			$result['wooProductId'] = (int)$_POST['wooProductId'];
		}
		return $result;
	}
	public function render(){
	?>
		<div id="step" data-calendarista-next-step-id="2" data-calendarista-prev-step-id="1">
			<?php if($this->welcome): ?>
			<h1><?php echo __('Welcome to Calendarista', 'calendarista') ?></h1>
			<p class="description"><?php echo __('This wizard uses the bare minimum options required to configure a service. If you need more advanced features, you may edit the service later. If this is your first time or if you are an advanced user and want a quick configuration, we highly advice you to use this wizard.', 'calendarista') ?></p>
			<?php endif; ?>
			<table class="form-table">
				<tbody>
					<tr>
						<td>
							<div><label for="name"><?php echo __('The name of your service', 'calendarista') ?></label></div>
							<input id="name" name="name" type="text" 
								class="regular-text calendarista_parsley_validated" 
								data-parsley-required="true" 
								data-parsley-pattern="^[^<>'`\u0022]+$"
								value="<?php echo Calendarista_StringResourceHelper::decodeString($this->fields['name']) ?>" />
						</td>
					</tr>
					<tr>
						<td>
							<div><label for="calendarMode"><?php echo __('The date and time selection mode', 'calendarista') ?></label></div>
							<select id="calendarMode" name="calendarMode">
								<?php foreach($this->calendarMode as $mode):?>
								<option value="<?php echo $mode['key']?>"
									<?php echo $this->fields['calendarMode'] === $mode['key'] ? "selected" : ""?>><?php echo $mode['value'] ?></option>
							   <?php endforeach;?>
							</select>
						</td>
					</tr>
					<tr>
						<td>
							<div>
								<label for=""><?php echo __('Do you want to accept payments?', 'calendarista')?></label>
							</div>
							<ul>
								<li>
									<label for="">
										<input name="paymentsMode"
											value="-1"
											type="radio" <?php echo $this->fields['paymentsMode'] === -1 ? "checked" : ""?> /> 
											<?php echo __('No', 'calendarista')?>
									</label>
								</li>
								<li>
									<label for="">
										<input name="paymentsMode" 
											value="0"
											type="radio" <?php echo $this->fields['paymentsMode'] === 0 ? "checked" : ""?> /> 
											<?php echo __('Collect payment offline', 'calendarista')?>
									</label>
								</li>
								<li>
									<label for="">
											<input name="paymentsMode" 
												value="1"
												type="radio" <?php echo $this->fields['paymentsMode'] === 1 ? "checked" : ""?> /> 
												<?php echo __('Enable online payments', 'calendarista')?>
									</label>
								</li>
								<li>
									<label for="">
										<input name="paymentsMode" 
											value="2"
											type="radio" <?php echo $this->fields['paymentsMode'] === 2 ? "checked" : ""?> /> 
											<?php echo __('Enable online payments and offline mode', 'calendarista')?>
									</label>
								</li>
								<li>
									<label>
										<input name="paymentsMode"
											value="3"
											type="radio" <?php echo $this->fields['paymentsMode'] === 3 ? "checked" : "" ?> <?php echo $this->wooProducts->have_posts() ? '' : 'disabled' ?> />
											<select data-parsley-required="true" class="calendarista_parsley_validated" name="wooProductId" <?php echo $this->fields['paymentsMode'] !== 3 ? "disabled" : "" ?>>
											<option value=""><?php echo __('Select a WooCommerce product', 'calendarista') ?></option>
											<?php if ($this->wooProducts->have_posts()): ?>
											<?php foreach ($this->wooProducts->posts as $post) :?>
												<option value="<?php echo $post->ID ?>" <?php echo $this->fields['wooProductId'] === $post->ID ? 'selected=selected' : '' ?>><?php echo $post->post_title ?></option>
											<?php endforeach; endif; ?>
										</select>
										<?php if (!$this->wooProducts->have_posts()): ?>
											<p class="description"><?php echo __('In order to enable payments via WooCommerce, you must have already created one or more WooCommerce products of type Calendarista in WooCommerce->Products page.', 'calendarista') ?></p>
										<?php endif; ?>
									</label>
								</li>
							</ul>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		<script type="text/javascript">
			(function($, wp){
				var calendarista = window['calendarista'] ? window['calendarista'] : function(){};
				calendarista.createDelegate = function (instance, method) {
					return function () {
						return method.apply(instance, arguments);
					};
				};
				calendarista.setupStep1 = function(options){
					var context = this;
					$(window).ready(function(){
						context.init(options);
					});
				};
				calendarista.setupStep1.prototype.init = function(options){
					var context = this;
					this.ajaxUrl = wp.url;
					this.nonce = wp.nonce;
					this.requestUrl = options['requestUrl'];
					this.$paymentModes = $('input[name="paymentsMode"]');
					this.$wooProductId = $('select[name="wooProductId"]');
					this.$paymentModes.on('change', function(){
						var val = parseInt($(this).val(), 10);
						context.$wooProductId.parsley().reset();
						if(!context.$wooProductId.is(':disabled')){
							context.$wooProductId.prop('disabled', true);
						}
						if(val === 3/*woocommerce*/){
							context.$wooProductId.prop('disabled', false);
						}
					});
				};
			window['calendarista'] = calendarista;
		})(window['jQuery'], window['calendarista_wp_ajax']);
		new calendarista.setupStep1({'requestUrl': '<?php echo $this->requestUrl ?>'});
		</script>
		<?php
	}
}