<?php
class Calendarista_UpdatesTemplate extends Calendarista_ViewBase{
	public $setting;
	public $demoRequest;
	function __construct(){
		parent::__construct(false, true, 'calendarista-settings');
		new Calendarista_UpdatesController(
			array($this, 'updatedPurchaseCodeNotification')
			, array($this, 'resetPurchaseCodeNotification')
		);
		//add new method in controller for manually updating plugin
		$generalSettingsRepository = new Calendarista_GeneralSettingsRepository();
		$this->setting = $generalSettingsRepository->read();
		if(Calendarista_NetworkHelper::isLocalhost()){
			$this->localhostNotice();
		}
		$this->demoRequest = Calendarista_PermissionHelper::isAdmin() ? false : apply_filters('calendarista_demo_request', null);
		$this->render();
	}
	public function localhostNotice() {
		?>
		<div class="wrap">
			<div class="calendarista-notice error notice is-dismissible">
				<p><?php echo __('Purchase code can be registered only on a live instance of your site that is not running on localhost.', 'calendarista'); ?></p>
			</div>
		</div>
		<?php
	}
	public function updatedPurchaseCodeNotification($result){
		switch ($result){
			case -2:
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo __('Purchase code can be registered only on a live instance of your site that is not running on localhost.', 'calendarista') ?></p>
			</div>
			<hr>
		</div>
		<?php
			break;
			case -1:
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo __('The purchase code supplied is invalid. Please follow the instructions and paste your purchase code correctly or contact support.', 'calendarista') ?></p>
			</div>
			<hr>
		</div>
		<?php
			break;
			case 0:
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo __('You might have already registered the purchase code previously. Contact our support and we will do the correction manually for you.', 'calendarista') ?></p>
			</div>
			<hr>
		</div>
		<?php
			break;
			default:
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo __('Your purchase code has been stored. You will receive notification as soon as a new update is available. Thank you for supporting us.', 'calendarista') ?></p>
			</div>
			<hr>
		</div>
		<?php
		}
	}
	public function resetPurchaseCodeNotification($result) {
		?>
		<div class="wrap">
			<div class="calendarista-notice updated notice is-dismissible">
				<p><?php echo __('Purchase code has been reset to factory default.', 'calendarista'); ?></p>
			</div>
		</div>
		<?php
	}
	public function render(){
	?>
		<div class="wrap">
			<form data-parsley-validate action="<?php echo $this->requestUrl ?>" method="post">
				<input type="hidden" name="controller" value="calendarista_updates">
				<input type="hidden" name="calendarista_nonce" value="<?php echo wp_create_nonce('calendarista-ajax-nonce') ?>"/>
				<table class="form-table">
					<tbody>
						<tr>
							<td>
								<div><label for="purchaseCode"><?php echo __('Your purchase code', 'calendarista') ?></label></div>
								<input id="purchaseCode" name="purchaseCode" type="text" 
									class="regular-text" 
									data-parsley-required="true"
									value="<?php echo !$this->demoRequest ? $this->setting->purchaseCode : '' ?>" <?php echo Calendarista_NetworkHelper::isLocalhost() ? 'disabled=disabled' : '' ?> />
								<p class="description">
									<strong><?php echo __('Note:', 'calendarista') ?></strong>&nbsp;
									<?php echo sprintf(__('To retrieve you purchase code, follow this %s', 'calendarista'), sprintf('<a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-can-I-find-my-Purchase-Code-">%s</a>', __("guide", "calendarista"))) ?>
									<?php if($this->setting->purchaseCode):?>
									<br>
										<?php echo __('If you register your purchase code on localhost, then make sure you reset in order to reuse it on your live site.', 'calendarista') ?>
									<?php endif; ?>
								</p>
							</td>
						</tr>
					</tbody>
				</table>
				<p class="submit">
					<input type="submit" name="calendarista_update" id="calendarista_update" class="button button-primary" value="<?php echo __('Save changes', 'calendarista') ?>" <?php echo $this->demoRequest ? 'disabled' : '' ?>>
					<?php if($this->setting->purchaseCode):?>
					<input type="submit" name="calendarista_delete" id="calendarista_delete" class="button button-primary" value="<?php echo __('Reset', 'calendarista') ?>" <?php echo $this->demoRequest ? 'disabled' : '' ?>>
					<?php endif; ?>
				</p>
			</form>
		</div>
		<script type="text/javascript">
			(function($, wp){
				var calendarista = window['calendarista'] ? window['calendarista'] : function(){};
				calendarista.createDelegate = function (instance, method) {
					return function () {
						return method.apply(instance, arguments);
					};
				};
				calendarista.update = function(options){
					var context = this;
					$(window).ready(function(){
						context.init(options);
					});
				};
				calendarista.update.prototype.init = function(options){
					var context = this;
					this.ajaxUrl = wp.url;
					this.nonce = wp.nonce;
					this.requestUrl = options['requestUrl'];
				};
			window['calendarista'] = calendarista;
		})(window['jQuery'], window['calendarista_wp_ajax']);
		new calendarista.update({
			'requestUrl': '<?php echo $this->requestUrl ?>'
		});
		</script>
		<?php
	}
}