<?php
class Calendarista_WhitelabelTemplate extends Calendarista_ViewBase{
	public $setting;
	public $generalSettingsRepository;
	function __construct( ){
		parent::__construct(false, true, 'calendarista-settings');
		$this->generalSettingsRepository = new Calendarista_GeneralSettingsRepository();
		$this->setting = $this->generalSettingsRepository->read();
		if ((array_key_exists('controller', $_POST) 
			&& $_POST['controller'] == 'calendarista_whitelabel')){
				if(!Calendarista_NonceHelper::valid()){
					return;
				}
				if (array_key_exists('calendarista_create', $_POST)){
					$this->create();
				}else if(array_key_exists('calendarista_update', $_POST)){
					$this->update();
				}else if(array_key_exists('calendarista_delete', $_POST)){
					$this->delete();
				}
		}
		$this->render();
	}
	public function populateSetting(){
		$brandName = trim($this->getPostValue('brandName'));
		$this->setting->brandName = $brandName ? $brandName : null;
		$this->setting->disablePlacesPage = $this->getPostValue('disablePlacesPage') == '0' ? false : true;
		$this->setting->disableSalesPage = $this->getPostValue('disableSalesPage') == '0' ? false : true;
		$this->setting->disableStaffPage = $this->getPostValue('disableStaffPage') == '0' ? false : true;
		$this->setting->disableSeasonsPage = $this->getPostValue('disableSeasonsPage') == '0' ? false : true;
		$this->setting->disableMapPage = $this->getPostValue('disableMapPage') == '0' ? false : true;
		return $this->setting;
	}
	public function create(){
		$this->populateSetting();
		$result = $this->generalSettingsRepository->insert($this->setting);
		$this->createdNotice();
	}
	public function update(){
		$this->populateSetting();
		$result = $this->generalSettingsRepository->update($this->setting);
		$this->updatedNotice();
	}
	public function delete(){
		$this->setting->brandName = null;
		$this->setting->disablePlacesPage = false;
		$this->setting->disableSalesPage = false;
		$this->setting->disableStaffPage = false;
		$this->setting->disableSeasonsPage = false;
		$this->setting->disableMapPage = false;
		$result = $this->generalSettingsRepository->update($this->setting);
		$this->deletedNotice();
	}
	public function createdNotice() {
		?>
		<div class="index updated notice is-dismissible">
			<p><?php echo __('The settings have been saved. Refresh the page to view the change.', 'calendarista'); ?></p>
		</div>
		<?php
	}
	public function updatedNotice() {
		?>
		<div class="index updated notice is-dismissible">
			<p><?php echo __('The settings have been changed. Refresh the page to view the change.', 'calendarista'); ?></p>
		</div>
		<?php
	}
	public function deletedNotice() {
		?>
		<div class="index updated notice is-dismissible">
			<p><?php echo __('The settings have been removed. Refresh the page to view the change.', 'calendarista'); ?></p>
		</div>
		<?php
	}
	public function render(){
	?>
		<div class="wrap">
			<form data-parsley-validate action="<?php echo $this->requestUrl ?>" method="post">
				<input type="hidden" name="controller" value="calendarista_whitelabel"/>
				<input type="hidden" name="id" value="<?php echo $this->setting->id ?>"/>
				<input type="hidden" name="calendarista_nonce" value="<?php echo wp_create_nonce('calendarista-ajax-nonce') ?>"/>
				<table class="form-table">
					<tbody>
						<tr>
							<th scope="row">
								<label for=""><?php echo __('Brand Name', 'calendarista')?></label>
							</th>
							<td>
							 <input type="text" 
								id="brandName" 
								name="brandName" 
								class="regular-text" 
								value="<?php echo $this->setting->brandName ?>" />
								<p class="description"><?php echo __('The name of your brand', 'calendarista')?></p>
							</td>
						</tr>
						<tr>
							<th scope="row">
								<label for=""><?php echo __('Hide complexity', 'calendarista')?></label>
							</th>
							<td>
							<input name="disablePlacesPage" type="hidden" value="0">
							<input name="disablePlacesPage" 
									type="checkbox" <?php echo $this->setting->disablePlacesPage ? "checked" : ""?> /> 
								<?php echo __('Hide Places page', 'calendarista')?>
							<br>
							<input name="disableSalesPage" type="hidden" value="0">
							<input name="disableSalesPage" 
									type="checkbox" <?php echo $this->setting->disableSalesPage ? "checked" : ""?> /> 
								<?php echo __('Hide Sales page', 'calendarista')?>
							<br>
							<input name="disableStaffPage" type="hidden" value="0">
							<input name="disableStaffPage" 
									type="checkbox" <?php echo $this->setting->disableStaffPage ? "checked" : ""?> /> 
								<?php echo __('Hide Staff page', 'calendarista')?>
							<br>	
							<input name="disableSeasonsPage" type="hidden" value="0">
							<input name="disableSeasonsPage" 
									type="checkbox" <?php echo $this->setting->disableSeasonsPage ? "checked" : ""?> /> 
								<?php echo __('Hide Season page', 'calendarista')?>
							<br>	
							<input name="disableMapPage" type="hidden" value="0">
							<input name="disableMapPage" 
									type="checkbox" <?php echo $this->setting->disableMapPage ? "checked" : ""?> /> 
								<?php echo __('Hide Map page', 'calendarista')?>
							</td>
						</tr>
					</body>
				</table>
				<p class="submit">
				<?php if($this->setting->id === -1) :?>
					<button class="button button-primary" name="calendarista_create"><?php echo __('Save', 'calendarista') ?></button>
				<?php else:?>
					<button class="button button-primary" 
							name="calendarista_update" 
							value="<?php echo $this->setting->id?>">
							<?php echo __('Save', 'calendarista') ?>
					</button>
					<button class="button button-primary" 
							name="calendarista_delete" 
							value="<?php echo $this->setting->id?>">
							<?php echo __('Reset', 'calendarista') ?>
					</button>
				<?php endif;?>
				</p>
			</form>
		</div>
		<script type="text/javascript">
			(function($, wp){
				var calendarista = window['calendarista'] ? window['calendarista'] : function(){};
				calendarista.createDelegate = function (instance, method) {
					return function () {
						return method.apply(instance, arguments);
					};
				};
				calendarista.assets = function(options){
					var context = this;
					$(window).ready(function(){
						context.init(options);
					});
				};
				calendarista.assets.prototype.init = function(options){
					var context = this;
					this.ajaxUrl = wp.url;
					this.nonce = wp.nonce;
					this.requestUrl = options['requestUrl'];
				};
			window['calendarista'] = calendarista;
		})(window['jQuery'], window['calendarista_wp_ajax']);
		new calendarista.assets({'requestUrl': '<?php echo $this->requestUrl ?>'});
		</script>
	<?php
	}
}