/**
 * Custom JS script loaded on Widgets page (admin)
 * @license   GPL2+
 *
 * @package   GravityView-Calendar-Ext
 * @author    Katz Web Services, Inc.
 * @link      https://www.gravitykit.com
 * @copyright Copyright 2019, Katz Web Services, Inc.
 *
 * globals jQuery, GV_CALENDAR_WIDGET, GV_CALENDAR_WIDGET_DATA
 */

( function( $ ) {

	if ( ! window.GV_CALENDAR_WIDGET && ! window.GV_CALENDAR_WIDGET.forms ) {
		return;
	}

	'use strict';

	GV_CALENDAR_WIDGET.init = function( widget_id ) {
		// Do not initialize widget instance
		if ( ! widget_id || widget_id.match( /__i__/ ) || ! GV_CALENDAR_WIDGET_DATA[ widget_id ] ) {
			return;
		}

		var $widget = $( 'div[id*="' + widget_id + '"]' );
		var $form_selection = $widget.find( '.form_selection > select' );
		var $feed_selection = $widget.find( '.feed_selection > select' );
		var $empty_feed = $widget.find( '.empty_feed' );
		var form_id = GV_CALENDAR_WIDGET_DATA[ widget_id ].form_id;
		var feed_id = GV_CALENDAR_WIDGET_DATA[ widget_id ].feed_id;

		var hide_conditional_elements = function() {
			$feed_selection.parent().hide();
			$empty_feed.hide();
		};

		var handle_save_button_state = function() {
			$widget.find( '#widget-' + widget_id + '-savewidget' ).prop( 'disabled', ! form_id || ! feed_id );
		};

		$.each( GV_CALENDAR_WIDGET.forms, function( i, item ) {
			$form_selection.append( $( '<option>', {
				value: item.id,
				text: item.title,
			} ) );
		} );

		var populate_feeds = function() {
			$feed_selection.find( 'option:gt(0)' ).remove();
			$feed_selection.val( '' );

			$.each( GV_CALENDAR_WIDGET.feeds[ form_id ], function( i, item ) {
				$feed_selection.append( $( '<option>', {
					value: item.id,
					text: item.title,
				} ) );
			} );
		};

		$form_selection.on( 'change', function( e ) {
			e.stopPropagation();

			form_id = $( e.target ).val();
			feed_id = null;

			hide_conditional_elements();

			if ( ! GV_CALENDAR_WIDGET.feeds[ form_id ] ) {
				var link = $empty_feed.find( 'a' ).attr( 'href' ).replace( /id=.*?$/, 'id=' + form_id );

				$empty_feed.find( 'a' ).attr( 'href', link );
				$empty_feed.show();
			} else {
				populate_feeds();

				$feed_selection.parent().show();
			}

			handle_save_button_state();
		} );

		$feed_selection.on( 'change', function( e ) {
			e.stopPropagation();

			feed_id = $( e.target ).val();

			handle_save_button_state();
		} );

		// Set initial form state
		if ( form_id ) {
			var _feed_id = feed_id; // store a copy of the feed ID as it is reset when the form is changed (or initially set as below)

			$form_selection.val( form_id ).trigger( 'change' );
			$feed_selection.val( _feed_id );
		}
	};

	// Initialize new widget after it's added
	$( document ).on( 'widget-added', function( e, widget ) {
		var widget_id = /widget-\d+_(.*?)$/.exec( $( widget ).attr( 'id' ) );

		if ( ! widget_id ) {
			return;
		}

		GV_CALENDAR_WIDGET_DATA[ widget_id[ 1 ] ] = {
			form_id: null,
			feed_id: null,
		};

		GV_CALENDAR_WIDGET.init( widget_id[ 1 ] );
	} );

}( jQuery ) );
