---
title: Filters
sidebar: auto
---

# Developer Filters

## Plugin paths

### `gravityview_calendar_script_src`

Modify the FullCalendar core script used.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$src` | `string` |  `{URL of plugin directory}/lib/fullcalendar/main.js` | Unique identifier for support user. |

### `gravityview/calendar/default_locale`

Override default calendar locale (automatically set to 'en' or WP language code)

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$default_fc_locale` | `string` |  WordPress language code | FullCalendar locale |

### `gravityview/calendar/scripts/fullcalendar/locales_dir_url`

Modify the URL to FullCalendar locales. This can be used to point to your own translations.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$locales_url` | `string` |  `{URL of plugin directory}/lib/fullcalendar/locales/` | URL to FullCalendar locales directory |

## FullCalendar overrides

### `gravityview/calendar/options` 

Modify all FullCalendar options in an array.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$calendar_options` | `array` |  | Array of settings used when rendering FullCalendar |
| `$form_id` | `int` |  Current form ID | The ID of the form connected to the calendar |
| `$feed_id` | `int` |  Current feed ID | The ID of the calendar feed currently being shown |


#### To set [`showNonCurrentDates`](https://fullcalendar.io/docs/showNonCurrentDates) to false

Here's an example of modifying the Calendar output to disable [`showNonCurrentDates`](https://fullcalendar.io/docs/showNonCurrentDates), but only for Calendar feed #5:

```php
add_filter( 'gravityview/calendar/options', function ( $calendar_options, $form_id, $feed_id ) {
    // Only modify the setting for Calendar #5
    if( 5 !== $feed_id ) {
        return $calendar_options;  
    }
    
    $calendar_options['showNonCurrentDates'] = false;
    
    return  $calendar_options;
}, 10, 3 );
```

### `gravityview/calendar/extra_options`

Modify extra options used in the plugin's UI that aren't standard to FullCalendar.

This is a way to pass additional data to the FullCalendar configuration object in a way that won't affect initialization. For example, `navigateToEvents` is a custom calendar option and will throw an error if used to initialize a FullCalendar instance in the UI. 

This filter is internal, but you may want to use it for similar reasons. 

## Rendering & content overrides

### `gravityview/calendar/settings/entry_status`

Modify the status used to find matching entries. If set to `false`, no status will be defined and all entries will be returned.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$status` | `string`, `false` | `'active'` | Gravity Forms entry status. Options: `'active'`, `'spam'`, `'trash'`, or `false` |

### `gravityview/calendar/settings/sort_order`

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$sort_order` | `array` | `[ 'key' => {start date}, 'direction' => 'ASC' ]` | Sort order with `key` and `direction` values. |
| `$form_id` | `int` |  Current form ID | ID of the current feed being processed |
| `$field_map` | `array` |  Current feed ID | [Gravity Forms field map](https://docs.gravityforms.com/field_map-field/) array of feed fields mapped to calendar settings (e.g., start_time, end_time) |

```php
/**
 * Overrides the sort order to be sorted by form field #3 when using Calendar #22 
 */
add_filter( 'gravityview/calendar/settings/sort_order', function ( $sort_order, $feed_id, $field_map ) {

    if( 22 !== $feed_id ) {
        return  $sort_order;
    }

    return array(
        'key' => 3,
        'direction' => 'DESC',
    );
    
}, 10, 3 );
```

### `gravityview/calendar/events/source_data`

Used to populate the form entries that are displayed in the calendar. You can override by filtering the entries using a priority greater than `10`.

Note: `$from_date` and `$to_date` values are created with `strtotime()` from Start Date and End Date field values. They are false if there was an error parsing the value when creating the timestamp.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$entries` | `array` | `[]` | Form entries with `title`, `start`, `end`, and `description` (optional) keys. |
| `$feed_id` | `int` | `0` | ID of the current feed being processed |
| `$from_date` | `int`, `false`, `null` | `null` | Start date timestamp used to filter events. |
| `$to_date` | `int`, `false`, `null` | `null` | End date timestamp used to filter events. |

#### Entries are expected in the following format:

```php
array(
    array(
        'title' => 'Event One',
        'start' => '2022-04-12T10:30:00',
        'end'   => '2022-04-12T12:30:00',
        'description' => 'Optional description!',
    ),
    array(
        'title' => 'Event Two',
        'start' => '2022-05-13T10:30:00',
        'end'   => '2012-05-13T12:30:00',
        'description' => 'Description optional!'
    ),
    [...]
)
```

The entries array is parsed by the `GV_Extension_Calendar_Feed::calendar_events()` method, which transforms the array into the expected calendar format.

### `gravityview/calendar/events/exclude`

Prevent entries from being displayed in the calendar by returning an array of IDs. 

Note: If an entry ID is included in this list, **it will still be shown if the event is on the "include" list** (see the `gravityview/calendar/events/include` filter).

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$entry_ids` | `array` | `[]` or `int[]` | Array of entry IDs to be displayed based on feed settings. May be empty array. |
| `$form` | `array` | Current form | [Gravity Forms form object](https://docs.gravityforms.com/form-object/) connected to the calendar feed |
| `$feed` | `array` |  Current feed | Calendar [Gravity Forms feed object](https://docs.gravityforms.com/feed-object/) |
| `$field_map` | `array` |  Current feed ID | [Gravity Forms field map](https://docs.gravityforms.com/field_map-field/) array of feed fields mapped to calendar settings (e.g., start_time, end_time) |
| `$entries` | `array` | `[]` or `array[]` | Array of full entries from `$entry_ids`, instead of just the IDs. |


### `gravityview/calendar/events/include`

Show these events in the Calendar.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$entry_ids` | `array` | `[]` or `int[]` | Array of entry IDs to be displayed based on feed settings. May be empty array. |
| `$form` | `array` | Current form | [Gravity Forms form object](https://docs.gravityforms.com/form-object/) connected to the calendar feed |
| `$feed` | `array` |  Current feed | Calendar [Gravity Forms feed object](https://docs.gravityforms.com/feed-object/) |
| `$field_map` | `array` |  Current feed ID | [Gravity Forms field map](https://docs.gravityforms.com/field_map-field/) array of feed fields mapped to calendar settings (e.g., start_time, end_time) |
| `$entries` | `array` | `[]` or `array[]` | Array of full entries from `$entry_ids`, instead of just the IDs. |


### `gravityview/calendar/events/do_shortcodes` 

Modify whether to process shortcodes in the event title and event description.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$do_shortcode` | `bool` | `true` | True: Process shortcodes in title and description. False: don't! |
| `$form` | `array` | Current form | [Gravity Forms form object](https://docs.gravityforms.com/form-object/) connected to the calendar feed |
| `$feed` | `array` |  Current feed | Calendar [Gravity Forms feed object](https://docs.gravityforms.com/feed-object/) |
| `$field_map` | `array` |  Current feed ID | [Gravity Forms field map](https://docs.gravityforms.com/field_map-field/) array of feed fields mapped to calendar settings (e.g., start_time, end_time) |


### `gravityview/calendar/shortcode/render/element_attributes`

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$attributes` | `array` | See below | Array of HTML attributes to be applied to the calendar container |

| Key | Type | Default | Description
| ---  | ---  | --- | --- |
| `class` | `string` | `gv-fullcalendar` | CSS class for the container |
| `data-feed_id` | `int` | `$feed_id` | The ID of the feed being rendered. |
| `data-calendar_id` | `string` | `wp_generate_password()` | Simple hash to differentiate multiple calendars. | 
| `data-view_id` | `int` or `null` | $view_id` | The ID of the current View, if embedded inside a GravityView View |

--------

## Feed setting filters

### `gravityview/calendar/settings/total-event-limit`

Modify the total number of events displayed on a calendar.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$total_event_limit` | `int` | 1000 | Maximum total number of events to fetch |
| `$feed_id` | `int` |  Current feed ID | The ID of the calendar feed currently being shown |

### `gravityview/calendar/settings/fields/date`

Override the field types that are shown in the feed configuration when selecting Start Date and End Date.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$field_types` | `array` |  `['date', 'date_created', 'date_updated']` | Default field types used for populating the Start Date or End Date settings. |

#### Allow for text fields to be used in the feed configuration

If you allow entering dates into a text field—not recommended due to inconsistent formatting!—you may want to use the field as the "Start Date" or "End Date" values. The code below will allow that:

```php
/**
 * Add Text fields to the list of fields to display when selecting Start Date and End Date. 
 * 
 * @param array $field_types
 * 
 * @return array Field types, with "text" added.   
 */
add_filter( 'gravityview/calendar/settings/fields/date', function ( $field_types ) {

    $field_types[] = 'text';
    
    return $field_types;
} );
```

### `gravityview/calendar/settings/fields/time`

Override the field types that are shown in the feed configuration when selecting Start Time and End Time.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$field_types` | `array` |  `['time', 'date_created_time', 'date_updated_time']` | Default field types used for populating the Start Time or End Time settings. |

### `gravityview/calendar/settings/fields/location`

Override the field types that are shown in the feed configuration when selecting Event Location.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$field_types` | `array` |  `['address']` | Default field types used for populating the Event Location setting. |

### `gravityview/calendar/settings/fields/url`

Override the field types that are shown in the feed configuration when selecting Event URL.

| Parameter | Type | Default | Description |
| ---  | ---  | --- | --- |
| `$field_types` | `array` |  `['url', 'website']` | Default field types used for populating the Event URL setting. |

