<?php
/**
 * Plugin Name: GravityCalendar
 * Plugin URI:  https://www.gravitykit.com/products/calendar/
 * Description: Display entries in a FullCalendar on a page or in GravityView.
 * Version:     2.6.1
 * Author:      GravityKit
 * Author URI:  https://www.gravitykit.com
 * Text Domain: gk-gravitycalendar
 * License:     GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

require_once __DIR__ . '/vendor_prefixed/gravitykit/foundation/src/preflight_check.php';

if ( ! GravityKit\GravityCalendar\Foundation\should_load( __FILE__ ) ) {
	return;
}

if ( ! GravityKit\GravityCalendar\Foundation\meets_min_php_version_requirement( __FILE__, '7.4.0' ) ) {
	return;
}

define( 'GV_CALENDAR_TITLE', 'GravityCalendar' );

define( 'GV_CALENDAR_VERSION', '2.6.1' );

define( 'GV_CALENDAR_MIN_GF_VERSION', '2.6' );

define( 'GV_CALENDAR_FILE', __FILE__ );

/** @define "GV_CALENDAR_PATH" "./" */
define( 'GV_CALENDAR_PATH', plugin_dir_path( GV_CALENDAR_FILE ) );

define( 'GV_CALENDAR_RELATIVE_PATH', plugin_basename( GV_CALENDAR_FILE ) );

define( 'GV_CALENDAR_URL', plugin_dir_url( GV_CALENDAR_FILE ) );

define( 'GV_CALENDAR_SLUG', 'gravityview-calendar' );

define( 'GV_CALENDAR_FULLCALENDAR_VERSION', '5.11.3' );

require_once GV_CALENDAR_PATH . 'vendor/autoload.php';
require_once GV_CALENDAR_PATH . 'vendor_prefixed/autoload.php';

GravityKit\GravityCalendar\Foundation\Core::register( GV_CALENDAR_FILE );

/**
 * Register Calendar as a GF addon
 *
 * @return void
 */
function register_gravityview_calendar_addon() {
	$gf_version = class_exists( 'GFCommon' ) ? GFCommon::$version : '0.0';

	if ( version_compare( $gf_version, GV_CALENDAR_MIN_GF_VERSION, '<' ) ||
	     ! method_exists( 'GFForms', 'include_feed_addon_framework' ) ) {
		add_action( 'admin_notices', function () {
			$message = wpautop(
				strtr(
					esc_html__( '[plugin] requires [requirement] [version] or newer.', 'gk-gravitycalendar' ),
					[
						'[plugin]'      => GV_CALENDAR_TITLE,
						'[requirement]' => 'Gravity Forms',
						'[version]'     => GV_CALENDAR_MIN_GF_VERSION,
					]
				)
			);

			echo "<div class='error' style='padding: 1.25em 0 1.25em 1em;'>$message</div>";
		} );

		return;
	}

	if ( ! method_exists( 'GFForms', 'include_feed_addon_framework' ) ) {
		return;
	}

	require_once GV_CALENDAR_PATH . 'includes/class-calendar-widget.php';
	require_once GV_CALENDAR_PATH . 'includes/class-calendar-ajax.php';
	require_once GV_CALENDAR_PATH . 'includes/class-calendar-widget-block-helpers.php';
	require_once GV_CALENDAR_PATH . 'includes/class-calendar-feed.php';
	require_once GV_CALENDAR_PATH . 'includes/class-calendar-gf-admin.php';
	require_once GV_CALENDAR_PATH . 'includes/class-gravityview-widget-calendar.php';
	require_once GV_CALENDAR_PATH . 'includes/class-calendar-shortcode.php';
	require_once GV_CALENDAR_PATH . 'includes/gutenberg/class-calendar-gutenberg-blocks.php';
}

// Widgets need foundation to be initialized to calculate the secret.
add_action( 'gk/foundation/initialized', 'register_gravityview_calendar_addon' );
