<?php
/**
 * GravityCalendar Add-On - Gravity Forms Admin Customizations
 *
 * @package   GravityCalendar
 * @license   GPL2+
 * @author    Katz Web Services, Inc.
 * @link      https://www.gravitykit.com
 * @copyright Copyright 2019, Katz Web Services, Inc.
 */

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

add_filter( 'gform_toolbar_menu', 'gv_calendar_gform_toolbar_menu', 10, 2 );
add_action( 'gform_form_actions', 'gv_calendar_gform_toolbar_menu', 10, 2 );

/**
 * Add a GravityView menu to the Form Toolbar with connected views
 *
 * @since 1.1
 *
 * @param array $menu_items Menu items, as set in GFForms::top_toolbar()
 * @param int   $id         ID of the current Gravity form
 *
 * @return array Modified array
 */
function gv_calendar_gform_toolbar_menu( $menu_items = array(), $id = null ) {

	// Don't show on Trashed forms
	if ( 'trash' === rgget( 'filter' ) && 'gf_edit_forms' === rgget( 'page' ) ) {
		return $menu_items;
	}

	$gv_calendar    = GV_Extension_Calendar_Feed::get_instance();
	$calendar_feeds = $gv_calendar->get_feeds( $id );

	$priority = -1;

	if ( 'form_list' === GFForms::get_page() ) {
		$priority = 750;
	}

	// Short circuit to create just a top item when no calendars exist
	if ( empty( $calendar_feeds ) ) {

		$menu_items['gravityview-calendar'] = array(
			'label'        => esc_attr__( 'Create a Calendar', 'gk-gravitycalendar' ),
			'title'        => esc_attr__( 'Create a Calendar using this form as a data source', 'gk-gravitycalendar' ),
			'url'          => esc_url( admin_url( 'admin.php?page=gf_edit_forms&view=settings&subview=gravityview-calendar&fid=0&id=' . $id ) ),
			'menu_class'   => 'gv_calendar gf_form_toolbar_settings',
			'priority'     => $priority,
			'capabilities' => array( 'gravityview_calendar' ),
		);

		return $menu_items;

	}

	$sub_menu_items = array();

	// Create the submenu items array
	foreach ( (array) $calendar_feeds as $calendar ) {

		$label = empty( $calendar['meta']['feedName'] ) ? sprintf( __( 'No Title (Calendar #%d)', 'gk-gravitycalendar' ), $calendar['id'] ) : $calendar['meta']['feedName'];

		$sub_menu_items[] = array(
			'label' => esc_attr( $label ),
			'url'   => esc_url( admin_url( 'admin.php?page=gf_edit_forms&view=settings&subview=gravityview-calendar&fid=' . $calendar['id'] . '&id=' . $id ) ),
			'icon'  => '<i class="dashicons dashicons-calendar"></i>',
		);

	}

	// Add a final item to create a calendar
	$sub_menu_items[] = array(
		'label'        => esc_attr__( 'Create a Calendar', 'gk-gravitycalendar' ),
		'link_class'   => 'gv-calendar-create',
		'icon'         => '<i class="dashicons dashicons-plus"></i>',
		'title'        => esc_attr__( 'Create a Calendar using this form as a data source', 'gk-gravitycalendar' ),
		'url'          => esc_url( admin_url( 'admin.php?page=gf_edit_forms&view=settings&subview=gravityview-calendar&fid=0&id=' . $id ) ),
		'capabilities' => array( 'gravityview_calendar' ),
	);

	// Create the top menu to hold the submenu items
	$menu_items['gravityview-calendar'] = array(
		'label'          => __( 'Calendar Feeds', 'gk-gravitycalendar' ),
		'icon'           => '<i class="dashicons dashicons-calendar"></i>',
		'title'          => __( 'Calendars using this form as a data source', 'gk-gravitycalendar' ),
		'url'            => esc_url( admin_url( 'admin.php?page=gf_edit_forms&view=settings&subview=gravityview-calendar&id=' . $id ) ) . '#gravityview-calendar-group-heading',
		'menu_class'     => 'gv_calendar gf_form_toolbar_settings',
		'sub_menu_items' => $sub_menu_items,
		'priority'       => $priority,
		'capabilities'   => array( 'gravityview_calendar' ),
	);


	return $menu_items;
}
