<?php

namespace GravityKit\GravityCalendar\Gutenberg\Blocks\Block;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Calendar feed link block.
 *
 * @since 2.0
 */
class Link extends Block {

	const BLOCK_NAME = 'link';

	/**
	 * Renders `[gv_calendar_link]` shortcode.
	 *
	 * @since 2.0
	 *
	 * @param array $attributes Block attributes.
	 *
	 * @return string $output Rendered shortcode.
	 */
	static function render( $attributes = array() ) {
		if ( empty( $attributes['att_id'] ) ) {
			return esc_html__( 'Calendar feed ID is missing.', 'gk-gravitycalendar' );
		}

		$shortcode_attributes = array(
			'id'        => (int) rgar( $attributes, 'att_id' ),
			'text'      => rgar( $attributes, 'att_text' ),
			'webcal'    => rgar( $attributes, 'att_webcal' ),
			'target'    => rgar( $attributes, 'att_target_new_window' ),
			'html_link' => rgar( $attributes, 'att_html_link' ),
			'secret'    => (string) rgar( $attributes, 'att_secret' ),
		);

		if ( ! empty( $shortcode_attributes['target'] ) ) {
			$shortcode_attributes['target'] = '_blank';
		}

		$output = gv_calendar_link_shortcode_handler( $shortcode_attributes );

		$block_class = rgar( $attributes, 'className', '' );

		return sprintf( '<div class="gv-calendar-link %s">%s</div>', esc_attr( $block_class ), $output );
	}
}
