<?php
/**
 * @license MIT
 *
 * Modified by __root__ using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace GravityKit\GravityCalendar\Spatie\IcalendarGenerator\Builders;

use GravityKit\GravityCalendar\Spatie\IcalendarGenerator\Properties\Property;

class PropertyBuilder
{
    /** @var \GravityKit\GravityCalendar\Spatie\IcalendarGenerator\Properties\Property */
    private Property $property;

    public function __construct(Property $property)
    {
        $this->property = $property;
    }

    public function build(): array
    {
        $parameters = $this->resolveParameters();

        $value = $this->property->getValue();

        return array_map(
            fn (string $name) => $value !== null
                ? "{$name}{$parameters}:{$value}"
                : "{$name}{$parameters}",
            $this->property->getNameAndAliases()
        );
    }

    private function resolveParameters(): string
    {
        $parameters = '';

        foreach ($this->property->getParameters() as $parameter) {
            /** @var \GravityKit\GravityCalendar\Spatie\IcalendarGenerator\Properties\Parameter $parameter */
            $name = $parameter->getName();
            $value = $parameter->getValue();

            $parameters .= ";{$name}={$value}";
        }

        return $parameters;
    }
}
