<?php
/**
 * @license MIT
 *
 * Modified by __root__ using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */

namespace GravityKit\GravityCalendar\Spatie\IcalendarGenerator\Timezones;

use DateInterval;
use DateTimeInterface;
use GravityKit\GravityCalendar\Spatie\IcalendarGenerator\Enums\TimezoneEntryType;

class TimezoneTransition
{
    public DateTimeInterface $start;

    public DateInterval $offsetFrom;

    public DateInterval $offsetTo;

    public TimezoneEntryType $type;

    public function __construct(
        DateTimeInterface $start,
        DateInterval $offsetFrom,
        DateInterval $offsetTo,
        TimezoneEntryType $type
    ) {
        $this->start = $start;
        $this->offsetFrom = $offsetFrom;
        $this->offsetTo = $offsetTo;
        $this->type = $type;
    }
}
