<?php
/*
 * Copyright (c) 2022 LatePoint LLC. All rights reserved.
 */

/**
 * @var $notification_types array
 */
?>
<div class="latepoint-settings-w os-form-w">
  <form action="" data-os-action="<?php echo OsRouterHelper::build_route_name('settings', 'update'); ?>">
		<div class="notifications-types-wrapper mb-4">
		<?php
		foreach($notification_types as $notification_type){
			?>
				<div class="os-section-header"><h3><?php echo sprintf(__('%s Processors', 'latepoint'), $notification_type['label']); ?></h3></div>
				<?php if(!empty($notification_type['processors'])){ ?>
				<div class="mb-4">
					<div id="<?php echo $notification_type['code'].'_processors_list'; ?>" class="mb-4">
	        <div class="os-togglable-items-w">
		        <?php echo OsFormHelper::hidden_field('settings[notifications_'.$notification_type['code'].'_processor]', ''); ?>
						<?php foreach($notification_type['processors'] as $processor){ ?>
		          <div class="os-togglable-item-w" id="notificationProcessorToggler_<?php echo $processor['code']; ?>">
		            <div class="os-togglable-item-head">
		              <div class="os-toggler-w">
		                <?php echo OsFormHelper::toggler_radio_field('settings[notifications_'.$notification_type['code'].'_processor]', false, $processor['code'], OsNotificationsHelper::is_notification_processor_enabled($notification_type['code'], $processor['code']), 'toggleNotificationSettings_'.$processor['code'], 'large'); ?>
		              </div>
			            <?php if(!empty($processor['image_url'])) echo '<img class="os-togglable-item-logo-img" src="'.$processor['image_url'].'"/>'; ?>
		              <div class="os-togglable-item-name"><?php echo $processor['label']; ?></div>
		            </div>
		            <div class="os-togglable-item-body" style="<?php echo OsNotificationsHelper::is_notification_processor_enabled($notification_type['code'], $processor['code']) ? '' : 'display: none'; ?>" id="toggleNotificationSettings_<?php echo $processor['code']; ?>">
					          <?php do_action('latepoint_'.$notification_type['code'].'_processor_settings', $processor['code']); ?>
				        </div>
				      </div>
							<?php } ?>
						</div>
					</div>
				</div>
						<?php
					}else{
						echo '<div class="mb-4">'.OsAddonsHelper::generate_missing_addon_link(__('Install SMS Addon', 'latepoint')).'</div>';
					}?>
			<?php
		}
		?>
		</div>
		<div class="os-section-header"><h3><?php _e('Other Settings', 'latepoint'); ?></h3></div>
		<div class="white-box">
	    <div class="white-box-header">
	      <div class="os-form-sub-header"><h3><?php _e('Email System Settings', 'latepoint'); ?></h3></div>
	    </div>
	    <div class="white-box-content no-padding">
	      <div class="sub-section-row">
	        <div class="sub-section-label">
	          <h3><?php _e('Email Layout', 'latepoint') ?></h3>
	        </div>
	        <div class="sub-section-content">
		        <div class="latepoint-message latepoint-message-subtle"><?php _e('This layout is used for your emails. You can customize it below and use {{content}} variable to insert content of the email that is generated by the Process that was triggered. Go to Processes to manage actual content of the email that is being sent.', 'latepoint'); ?></div>
		        <div class="mb-2">
			        <a href="#" class="latepoint-btn latepoint-btn-outline latepoint-btn-sm open-layout-template-variables-panel"><i class="latepoint-icon latepoint-icon-zap"></i><span><?php _e('Show layout variables', 'latepoint'); ?></span></a>
		        </div>
						<?php OsFormHelper::wp_editor_field('settings[email_layout_template]', 'settings_email_layout_template', false, OsEmailHelper::get_email_layout()); ?>
	        </div>
	      </div>
				<div class="sub-section-row">
		      <div class="sub-section-label"><h3><?php _e('Password Reset', 'latepoint-google-calendar'); ?></h3></div>
		      <div class="sub-section-content">
			      <div class="latepoint-message latepoint-message-subtle"><?php _e('This email content will be used for password reset requests. Use {{token}} variable to insert a generated token, which is needed to reset the password.', 'latepoint'); ?></div>
		        <div class="mb-2">
			        <a href="#" class="latepoint-btn latepoint-btn-outline latepoint-btn-sm open-template-variables-panel"><i class="latepoint-icon latepoint-icon-zap"></i><span><?php _e('Show smart variables', 'latepoint'); ?></span></a>
		        </div>
		        <?php echo OsFormHelper::text_field('settings[email_customer_password_reset_request_subject]', __('Email Subject', 'latepoint'), OsNotificationsHelper::customer_password_reset_request_subject(), ['theme' => 'bordered']); ?>
		        <?php OsFormHelper::wp_editor_field('settings[email_customer_password_reset_request_content]', 'settings_email_customer_password_reset_request_content', __('Email Message', 'latepoint'), OsNotificationsHelper::customer_password_reset_request_content()); ?>
		      </div>
				</div>
	    </div>
		</div>
    <?php
    /**
	   * Plug your "other settings" blocks in notification settings
	   *
	   * @since 4.7.8
	   * @hook latepoint_settings_notifications_other_after
	   *
	   */
    do_action('latepoint_settings_notifications_other_after'); ?>
	  <div class="os-form-buttons">
	    <?php echo OsFormHelper::button('submit', __('Save Settings', 'latepoint'), 'submit', ['class' => 'latepoint-btn']); ?>
	  </div>
  </form>
</div>