<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Flex
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Options;
use Twilio\Values;

abstract class InsightsAssessmentsCommentOptions
{
    /**
     * @param string $token The Token HTTP request header
     * @return CreateInsightsAssessmentsCommentOptions Options builder
     */
    public static function create(
        
        string $token = Values::NONE

    ): CreateInsightsAssessmentsCommentOptions
    {
        return new CreateInsightsAssessmentsCommentOptions(
            $token
        );
    }

    /**
     * @param string $segmentId The id of the segment.
     * @param string $agentId The id of the agent.
     * @param string $token The Token HTTP request header
     * @return ReadInsightsAssessmentsCommentOptions Options builder
     */
    public static function read(
        
        string $segmentId = Values::NONE,
        string $agentId = Values::NONE,
        string $token = Values::NONE

    ): ReadInsightsAssessmentsCommentOptions
    {
        return new ReadInsightsAssessmentsCommentOptions(
            $segmentId,
            $agentId,
            $token
        );
    }

}

class CreateInsightsAssessmentsCommentOptions extends Options
    {
    /**
     * @param string $token The Token HTTP request header
     */
    public function __construct(
        
        string $token = Values::NONE

    ) {
        $this->options['token'] = $token;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self
    {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.CreateInsightsAssessmentsCommentOptions ' . $options . ']';
    }
}

class ReadInsightsAssessmentsCommentOptions extends Options
    {
    /**
     * @param string $segmentId The id of the segment.
     * @param string $agentId The id of the agent.
     * @param string $token The Token HTTP request header
     */
    public function __construct(
        
        string $segmentId = Values::NONE,
        string $agentId = Values::NONE,
        string $token = Values::NONE

    ) {
        $this->options['segmentId'] = $segmentId;
        $this->options['agentId'] = $agentId;
        $this->options['token'] = $token;
    }

    /**
     * The id of the segment.
     *
     * @param string $segmentId The id of the segment.
     * @return $this Fluent Builder
     */
    public function setSegmentId(string $segmentId): self
    {
        $this->options['segmentId'] = $segmentId;
        return $this;
    }

    /**
     * The id of the agent.
     *
     * @param string $agentId The id of the agent.
     * @return $this Fluent Builder
     */
    public function setAgentId(string $agentId): self
    {
        $this->options['agentId'] = $agentId;
        return $this;
    }

    /**
     * The Token HTTP request header
     *
     * @param string $token The Token HTTP request header
     * @return $this Fluent Builder
     */
    public function setToken(string $token): self
    {
        $this->options['token'] = $token;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.FlexApi.V1.ReadInsightsAssessmentsCommentOptions ' . $options . ']';
    }
}

