<?php
$tab                = $this->tabs->get_active();
$service            = tribe( 'events-aggregator.service' );
$origin_slug        = 'eventbrite';
$field              = (object) [];
$field->label       = __( 'Import Type:', 'tribe-eventbrite' );
$field->placeholder = __( 'Select Import Type', 'tribe-eventbrite' );
$field->help        = __( 'One-time imports include all currently listed events, while scheduled imports automatically grab new events and updates from Eventbrite on a set schedule. Single events can be added via a one-time import.', 'tribe-eventbrite' );
$field->source      = 'eventbrite_import_type';


$frequency              = (object) [];
$frequency->placeholder = __( 'Import from Eventbrite', 'tribe-eventbrite' );
$has_ebt_license        = ! empty( $service->api()->licenses['tribe-eventbrite'] );
if ( $has_ebt_license ) {
	$frequency->placeholder = __( 'Import from your Eventbrite account', 'tribe-eventbrite' );
}
$frequency->help   = __( 'Select how often you would like events to be automatically imported.', 'tribe-eventbrite' );
$frequency->source = 'eventbrite_import_frequency';

$cron        = Tribe__Events__Aggregator__Cron::instance();
$frequencies = $cron->get_frequency();

$missing_eventbrite_credentials = ! tribe( 'events-aggregator.settings' )->is_ea_authorized_for_eb();
$data_depends                   = '#tribe-ea-field-origin';
$data_condition                 = 'eventbrite';

if ( $missing_eventbrite_credentials ) :
	$data_depends = '#tribe-has-eventbrite-credentials';
	$data_condition             = '1';
	?>
	<tr class="tribe-dependent tribe-credential-row" data-depends="#tribe-ea-field-origin" data-condition="eventbrite">
		<td colspan="2"
			class="<?php echo esc_attr( $missing_eventbrite_credentials ? 'enter-credentials' : 'has-credentials' ); ?>">
			<input type="hidden" name="has-credentials" id="tribe-has-eventbrite-credentials" value="0">
			<div class="tribe-message tribe-credentials-prompt">
				<p>
					<span class="dashicons dashicons-warning"></span>
					<?php
					esc_html_e(
							'Please log in to enable event imports from Eventbrite.',
							'tribe-eventbrite'
					);
					?>
				</p>
				<a class="tribe-ea-eventbrite-button tribe-ea-login-button"
				   href="<?php echo esc_url( Tribe__Events__Aggregator__Record__Eventbrite::get_auth_url() ); ?>"><?php esc_html_e( 'Log into Eventbrite', 'tribe-eventbrite' ); ?></a>
			</div>
		</td>
	</tr>
<?php endif; ?>
<tr class="tribe-dependent" data-depends="<?php echo esc_attr( $data_depends ); ?>"
	data-condition="<?php echo esc_attr( $data_condition ); ?>">
	<th scope="row">
		<label for="tribe-ea-field-import_type"><?php echo esc_html( $field->label ); ?></label>
	</th>
	<td>
		<input type="hidden" name="has-credentials" id="tribe-has-eventbrite-credentials"
			   value="<?php echo absint( ! $missing_eventbrite_credentials ); ?>">
		<?php if ( 'edit' === $aggregator_action ) : ?>
			<input type="hidden" name="aggregator[eventbrite][import_type]" id="tribe-ea-field-eventbrite_import_type"
				   value="schedule"/>
			<strong class="tribe-ea-field-readonly"><?php echo esc_html__( 'Scheduled Import', 'tribe-eventbrite' ); ?></strong>
		<?php else : ?>
			<select
					name="aggregator[eventbrite][import_type]"
					id="tribe-ea-field-eventbrite_import_type"
					class="tribe-ea-field tribe-ea-dropdown tribe-ea-size-large tribe-import-type"
					placeholder="<?php echo esc_attr( $field->placeholder ); ?>"
					data-hide-search
					data-prevent-clear
			>
				<option value="manual"><?php echo esc_html__( 'One-Time Import', 'tribe-eventbrite' ); ?></option>
				<option value="schedule"><?php echo esc_html__( 'Scheduled Import', 'tribe-eventbrite' ); ?></option>
			</select>
		<?php endif; ?>

		<span
				data-depends="#tribe-ea-field-eventbrite_import_type"
				data-condition="schedule"
		>
			<select
					name="aggregator[eventbrite][import_frequency]"
					id="tribe-ea-field-eventbrite_import_frequency"
					class="tribe-ea-field tribe-ea-dropdown tribe-ea-size-large tribe-dependent"
					placeholder="<?php echo esc_attr( $frequency->placeholder ); ?>"
					data-hide-search
					data-prevent-clear
			>
				<?php
				foreach ( $frequencies as $frequency_object ) :
					$selected = empty( $record->meta['frequency'] ) ? 'daily' : $record->meta['frequency'];
					?>
					<option value="<?php echo esc_attr( $frequency_object->id ); ?>" <?php selected( $selected, $frequency_object->id ); ?>>
						<?php echo esc_html( $frequency_object->text ); ?>
					</option>
				<?php endforeach; ?>
			</select>
			<span
					class="tribe-bumpdown-trigger tribe-bumpdown-permanent tribe-bumpdown-nohover tribe-ea-help dashicons dashicons-editor-help tribe-dependent"
					data-bumpdown="<?php echo esc_attr( $frequency->help ); ?>"
					data-width-rule="all-triggers"
			></span>
		</span>
		<span
				class="tribe-bumpdown-trigger tribe-bumpdown-permanent tribe-bumpdown-nohover tribe-ea-help dashicons dashicons-editor-help tribe-dependent"
				data-bumpdown="<?php echo esc_attr( $field->help ); ?>"
				data-depends="#tribe-ea-field-eventbrite_import_type"
				data-condition-not="schedule"
				data-condition-empty
				data-width-rule="all-triggers"
		></span>
	</td>
</tr>
<?php
if ( 'edit' === $tab->get_slug() ) {
	$this->template(
			'fields/schedule',
			[
					'record'            => $record,
					'origin'            => $origin_slug,
					'aggregator_action' => $aggregator_action,
			]
	);
}
?>

<?php
$field              = (object) [];
$field->label       = __( 'Import Source', 'tribe-eventbrite' );
$field->placeholder = __( 'Select Source', 'tribe-eventbrite' );

$field->help = esc_html__( 'Import events directly from your connected Eventbrite.com account or from a public Eventbrite.com URL.', 'tribe-eventbrite' );

$default_eb_source = 'source_type_url';
if ( $has_ebt_license ) {
	$field->options[]  = [
			'id'       => 'https://www.eventbrite.com/me',
			'text'     => __( 'Import from your Eventbrite account', 'tribe-eventbrite' ),
			'selected' => false,
	];
	$default_eb_source = 'https://www.eventbrite.com/me';
}
$field->options[] = [
		'id'       => 'source_type_url',
		'text'     => __( 'Import from Eventbrite URL', 'tribe-eventbrite' ),
		'selected' => false,
];

$field->options[0]['selected'] = true;

?>
<tr class="tribe-dependent" data-depends="#tribe-ea-field-eventbrite_import_type" data-condition-not-empty>
	<th scope="row">
		<label for="tribe-ea-field-import_type"><?php echo esc_html( $field->label ); ?></label>
	</th>
	<td>
		<select
				name="aggregator[eventbrite][source_type]"
				id="tribe-ea-field-eventbrite_import_source"
				class="tribe-ea-field tribe-dropdown tribe-ea-size-xlarge"
				data-hide-search
				data-prevent-clear
				data-options="<?php echo esc_attr( wp_json_encode( $field->options ) ); ?>"
				value="<?php echo esc_attr( $default_eb_source ); ?>"
		>
			<?php foreach ( $field->options as $option ) : ?>
				<option value="<?php echo esc_attr( $option['id'] ); ?>" <?php selected( $option['selected'] ); ?> >
					<?php echo esc_html( $option['text'] ); ?>
				</option>
			<?php endforeach; ?>
		</select>
		<span class="tribe-bumpdown-trigger tribe-bumpdown-permanent tribe-bumpdown-nohover tribe-ea-help dashicons dashicons-editor-help"
			  data-bumpdown="<?php echo esc_attr( $field->help ); ?>" data-width-rule="all-triggers"></span>
	</td>

</tr>

<?php
$field              = (object) [];
$field->label       = __( 'URL:', 'tribe-eventbrite' );
$field->placeholder = __( 'eventbrite.com/e/example-12345', 'tribe-eventbrite' );
$field->help        = __( 'Enter an Eventbrite event URL, e.g. https://www.eventbrite.com/e/example-12345', 'tribe-eventbrite' );
?>
<tr
		class="tribe-dependent eb-url-row"
		data-depends="#tribe-ea-field-eventbrite_import_source"
		data-condition="source_type_url"
>
	<th scope="row">
		<label for="tribe-ea-field-eventbrite_source_type_url" class="tribe-ea-hidden">
			<input
					name="aggregator[eventbrite][source_type]"
					type="radio"
					id="tribe-ea-field-eventbrite_source_type_url"
					value=""
					checked="checked"
			>

			<?php echo esc_html( $field->label ); ?>
		</label>
	</th>
	<td>
		<input
				name="aggregator[eventbrite][source]"
				type="text"
				id="tribe-ea-field-eventbrite_source"
				class="tribe-ea-field tribe-ea-size-xlarge"
				placeholder="<?php echo esc_attr( $field->placeholder ); ?>"
				value="<?php echo esc_attr( empty( $record->meta['source'] ) ? '' : $record->meta['source'] ); ?>"
				data-validation-match-regexp="<?php echo esc_attr( Tribe__Events__Aggregator__Record__Eventbrite::get_source_regexp() ); ?>"
				data-validation-error="<?php esc_attr_e( 'Invalid Eventbrite URL', 'tribe-eventbrite' ); ?>"
		>
	</td>
</tr>

<?php include dirname( __FILE__ ) . '/refine.php'; ?>

<tr class="tribe-dependent" data-depends="#tribe-ea-field-eventbrite_import_source" data-condition-not-empty>
	<td colspan="2" class="tribe-button-row">
		<button type="submit" class="button button-primary tribe-preview">
			<?php esc_html_e( 'Preview', 'tribe-eventbrite' ); ?>
		</button>
	</td>
</tr>
