<?php
//WBK stat class

// check if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;
class WBK_Admin_Notices {
	public static function labelUpdate(){
	 	return;
	}
	public static function colorUpdate(){
	 	return;
	}
	public static function appearanceUpdate(){
		if ( get_option( 'wbk_appearance_saved', '' ) != 'true' ) {
			return '<div class="notice notice-warning is-dismissible"><p>WEBBA Booking: Please setup appearance settings.
					</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
	  	}
	 	return;
	}
	public static function emailLandingUpdate(){
		if ( get_option( 'wbk_email_landing', '' ) == '' ) {
			return '<div class="notice notice-warning is-dismissible"><p>WEBBA Booking: Please setup the <strong>Link to the page with Webba Booking form</strong> setting in the Email Notifications tab.
					</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
	  	}
	 	return;
	}

	public static function updateNotice(){
		$screen = get_current_screen();

		$html  = '<div class="notice notice-warning is-dismissible"><p>';
		$html .= 'Webba Booking: purchase code not entered or is not valid. Update not available. Please enter the correct purchase code in the Activation tab of Webba Settings page.';
		$html .= '</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
		if( is_object( $screen ) ){
			if( isset($screen->base ) ){
				if ( $screen->base == 'plugins' ){
					$code = get_option( 'wbk_purchase_code', '' );
					if( trim( $code )  == '' ){
						return $html;
					}
					$url = 'https://kernl.us/api/v1/updates/59c94da7b3ce5064463bbed5/?code=' . $code;
					$response = wp_remote_get( $url );
					if( !is_array( $response )  ){
						$html  = '<div class="notice notice-warning is-dismissible"><p>';
						$html .= 'Webba Booking: unable to connect update server.';
						$html .= '</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
						return $html;

					}
					if ( $response['response']['code'] === 401 ){
					     return $html;
					}
				}
			}
		}
	 	return '';
	}


}
?>
