<?php
// Solo Framework table html editor
if ( ! defined( 'ABSPATH' ) ) exit;

class SLFTableGGAuth extends SLFTableComponent {

	public function __construct( $title, $name, $value, $data_source ) {
		parent::__construct( $title, $name, $value, null );
		$this->data_source = $data_source;
	}
	
    public function renderCell(){

		$credentials = array( get_option( 'wbk_gg_clientid', '' ),  get_option( 'wbk_gg_secret', '' ) );
		$credentials = apply_filters( 'wbk_gg_credentials', $credentials );		
		$client_id =  $credentials[0];
		$client_secret = $credentials[1];
 	

		if( $client_id  == '' || $client_secret == '' ){
			return '<span class="slf_table_error">' . __( 'Authorization failed', 'wbk' ) . '</span>' .
			 	   '<span class="slf_table_desc">' . __( 'Google API credentials not set', 'wbk' ) . '</span>';
		}

	    $google = new WBK_Google();
	    	 	
	  	$google->init( $this->data_source[1] );

	  	$connection_status =  $google->connect();

	  	$html = '';

	  	$control_html = '<a target="_blank" class="slf_table_link" href="' .  get_admin_url()  . 'admin.php?page=wbk-gg-calendars&clid=' . $this->data_source[1] . '">' . __( 'Manage authorization', 'wbk' ) .'</a>';


	  	if( $connection_status[0] == 1 ){
	  		 
	  		$html .=  '<span class="slf_table_success">' .  __( 'Authorized', 'wbk' ) . '</span>';
	  		$html .= '<span class="slf_table_desc">' . __( 'Calendar name on Google:', 'wbk' );
	  		$html .=  ' ' . $connection_status[1] . '</span>';
	  		$html .= $control_html;
	  	} 
	  	if( $connection_status[0] == 0 ){
	  		 
	  		$html .= '<span class="slf_table_warning">' . __( 'Authorization required', 'wbk' ) . '</span>' .
	  		'<span class="slf_table_desc">' . __( 'Click the link below to start authorization process', 'wbk' ) . '</span>' . 
				$control_html;
	  		 
	  	}
	  	if( $connection_status[0] == 2 ){
	  		 
	  		$html .= '<span class="slf_table_error">' . __( 'Authorization failed', 'wbk' ) . '</span>' . 	
			  		 '<span class="slf_table_desc">' . __( 'Check Google API credentials, calendar ID and try to re-authorize this calendar', 'wbk' ) . '</span>' . 
	  				  $control_html;

	  	}
	    return $html;
    }
    public function renderControl(){      

		return '';
    }


}
