<!-- Webba Booking backend Google Calendar template --> 
<?php
    // check if accessed directly
    if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="wrap">
    <h2 class="wbk_panel_title"><?php  echo __( 'Google calendars', 'wbk' ); ?>
    <a style="text-decoration:none;" href="http://webba-booking.com/documentation/" target="_blank"><span class="dashicons dashicons-editor-help"></span></a>
    </h2>
    <div class="slf_row slf_overflow_visible slf_pad_10">
        <div class="slf_col_12_12_12">           
            <?php       
            if ( version_compare(PHP_VERSION, '5.4.0') >= 0) {
                global $current_user; 
                if(  isset( $_GET['clid'] ) && is_numeric( $_GET['clid'] ) ){   
                    if( WBK_Validator::checkAccessToGgCalendar( $_GET['clid'] ) || current_user_can('manage_options') ){
                        $html = wbk_gg_render_auth();
                    } else {
                        $html = __( 'Calendar not found', 'wbk' );
                    }                           
                } else {                  
                    if( current_user_can('manage_options') ){
                        $table = new WBK_GG_Calendar_Table();
                        $html = $table->render();              
                    } else {
                        $user_id = get_current_user_id();
                        if ( $user_id == 0 ) {
                            wp_die();
                            return;                            
                        }
                        $calendars = Wbk_Db_Utils::getGgCalendarsByUser( $user_id );
                        $html = '';
                        foreach( $calendars as $calendar ){
                            $html .= '<h3>' . $calendar->name.'</h3>';
                            $html .= '<a target="_blank" class="slf_table_link" href="' .  get_admin_url()  . 'admin.php?page=wbk-gg-calendars&clid=' . $calendar->id . '">' . __( 'Manage authorization', 'wbk' ) .'</a></br></br>';
                        }
                    } 
                }    
                echo $html;
            } else {
                echo __( 'The Google Calendar API require PHP 5.4 or greater. Your version is ', 'wbk' ) . PHP_VERSION ;
            }
                
            ?>
        </div>
        <div class="slf-clear"></div>
    </div>                                        
</div>

 