<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_Calendar_DeepLinkData extends Google_Collection
{
  protected $collection_key = 'links';
  protected $linksType = 'Google_Service_Calendar_Link';
  protected $linksDataType = 'array';
  public $url;

  /**
   * @param Google_Service_Calendar_Link
   */
  public function setLinks($links)
  {
    $this->links = $links;
  }
  /**
   * @return Google_Service_Calendar_Link
   */
  public function getLinks()
  {
    return $this->links;
  }
  public function setUrl($url)
  {
    $this->url = $url;
  }
  public function getUrl()
  {
    return $this->url;
  }
}
