<?php
/*
Webba Booking integration with WooCommerce
*/

add_filter( 'woocommerce_add_cart_item_data', 'wbk_add_booking_data_to_cart_item', 10, 3 );
add_filter( 'woocommerce_get_item_data', 'wbk_display_booking_data_text_cart', 10, 2 );
add_action( 'woocommerce_checkout_create_order_line_item', 'wbk_add_booking_text_to_order_items', 10, 4 );
add_action( 'woocommerce_before_calculate_totals', 'wbk_calculate_booking_product_price', 99 );
add_action( 'woocommerce_checkout_order_processed', 'wbk_order_placed');
add_action( 'woocommerce_order_status_refunded', 'wbk_order_cancelled_refunded' );
add_action( 'woocommerce_order_status_cancelled', 'wbk_order_cancelled_refunded' );
add_action( 'before_delete_post', 'wbk_order_deleted', 10, 1 );
add_action( 'woocommerce_before_delete_order_item', 'wbk_delete_order_item' );
add_action( 'woocommerce_thankyou_paysera', 'wbk_order_paid' );
add_action( 'woocommerce_thankyou', 'wbk_order_paid_cod' );

if( get_option( 'wbk_woo_check_coupons_inwebba', 'disabled' ) == 'enabled' ){
    add_filter( 'woocommerce_coupon_is_valid', 'wbK_woocommerce_coupon_is_valid', 10, 4 );
}
function wbK_woocommerce_coupon_is_valid( $value, $coupon, $discounts ){
	foreach( $discounts->get_items() as $item ){
		if( isset( $item->object['wbk_appointment_ids'] ) ){
			$appointment_ids = explode( ',', $item->object['wbk_appointment_ids'] );
			foreach ( $appointment_ids as $appointment_id) {
				$service_id = WBK_Db_Utils::getServiceIdByAppointmentId( $appointment_id );
				if( $service_id != false ){
					if( !WBK_Validator::checkCoupon( $coupon->get_code(), $service_id ) ){
						$value = false;
					}
				}
			}
		}
	}
	return $value;
}
function wbk_delete_order_item( $item_id ){
    $order_item = new WC_Order_Item_Product( $item_id );
    if( $order_item->get_product_id() == get_option( 'wbk_woo_product_id', '' ) ){
        if( get_option( 'wbk_woo_product_id', '' ) == '' ){
            return;
        }
        $item_meta = wc_get_order_item_meta( $item_id, 'IDs', true );
        if( $item_meta == '' ){
            return;
        }
        $appointment_ids =  explode( ',', $item_meta );
        foreach( $appointment_ids as $appointment_id ){
            WBK_Db_Utils::setAppointmentStatus( $appointment_id, $status );
            WBK_Db_Utils::setPaymentMethodToAppointment( $appointment_id, '' );
        }
    }
}
function wbk_order_deleted( $order_id ){
    global $post_type;
    if( $post_type !== 'shop_order' ) {
        return;
    }
    $order = new WC_Order( $order_id );
    $appointment_ids = array();
    foreach ( $order->get_items() as $item_id => $item ) {
       if( $item->get_product_id() == get_option( 'wbk_woo_product_id', '' ) ){
            $appointment_ids_this =  explode( ',',  wc_get_order_item_meta( $item_id, 'IDs', true ) );
            $appointment_ids = array_merge( $appointment_ids, $appointment_ids_this );
        }
    }
    if( get_option( 'wbk_appointments_default_status', 'approved' ) == 'approved' ){
        $status = 'approved';
    } else {
        $status = 'pending';
    }
    foreach( $appointment_ids as $appointment_id ){
        WBK_Db_Utils::setAppointmentStatus( $appointment_id, $status );
        WBK_Db_Utils::setPaymentMethodToAppointment( $appointment_id, '' );
    }
}
function wbk_order_cancelled_refunded( $order_id ){
    $order = new WC_Order( $order_id );
    $appointment_ids = array();
    foreach ( $order->get_items() as $item_id => $item ) {
       if( $item->get_product_id() == get_option( 'wbk_woo_product_id', '' ) ){
            $appointment_ids_this =  explode( ',',  wc_get_order_item_meta( $item_id, 'IDs', true ) );
            $appointment_ids = array_merge( $appointment_ids, $appointment_ids_this );
        }
    }
    if( get_option( 'wbk_appointments_default_status', 'approved' ) == 'approved' ){
        $status = 'approved';
    } else {
        $status = 'pending';
    }
    foreach( $appointment_ids as $appointment_id ){
        WBK_Db_Utils::setAppointmentStatus( $appointment_id, $status );
        WBK_Db_Utils::setPaymentMethodToAppointment( $appointment_id, '' );
    }
}
function wbk_add_booking_data_to_cart_item( $cart_item_data, $product_id, $variation_id ) {
    if( $product_id != get_option( 'wbk_woo_product_id', '' ) ){
        return $cart_item_data;
    }
    if( !session_id() ){
        session_start();
    }
    $app_ids =  $_SESSION['wbk_woo_appt_ids'];
    if( $app_ids == '' || is_null( $app_ids ) ){
        return $cart_item_data;
    }
    $cart_item_data['wbk_appointment_ids'] = $app_ids;
    return $cart_item_data;
}
function wbk_display_booking_data_text_cart( $item_data, $cart_item ) {
    if ( empty( $cart_item['wbk_appointment_ids'] ) ) {
        return $item_data;
    }
    $appointment_ids = explode( ',', wc_clean( $cart_item['wbk_appointment_ids'] ) );
    $item_names = WBK_Db_Utils::getPymentItemNamesByAppoiuntmentIds( $appointment_ids );
    $meta_key = wbk_get_translation_string( 'wbk_product_meta_key', 'wbk_product_meta_key' , 'Appointments' );
    $item_data[] = array(
        'key'     => $meta_key,
        'value'   => $item_names,
        'display' => '',
    );

    return $item_data;
}
function wbk_calculate_booking_product_price( $cart_object ) {
    if( !WC()->session->__isset( "reload_checkout" )) {
        foreach ( $cart_object->cart_contents as $key => $value ) {
            if( $value['data']->get_id() == get_option( 'wbk_woo_product_id', '' ) ){
	            if( isset( $value['wbk_appointment_ids'] ) ){
	            	$appointment_ids =  explode( ',', $value['wbk_appointment_ids']  );
	            	$price = WBK_Db_Utils::getAmountNoTaxByAppoiuntmentIds( $appointment_ids );
	            	$value['data']->set_price( $price );
	            }
            }
        }
    }
}
function wbk_add_booking_text_to_order_items( $item, $cart_item_key, $values, $order ) {
    if ( empty( $values['wbk_appointment_ids'] ) ) {
        return;
    }
    $appointment_ids = explode( ',', wc_clean(  $values['wbk_appointment_ids'] ) );
    $item_names = WBK_Db_Utils::getPymentItemNamesByAppoiuntmentIds( $appointment_ids );
    $meta_key = wbk_get_translation_string( 'wbk_product_meta_key', 'wbk_product_meta_key' , 'Appointments' );

    $item->add_meta_data( $meta_key, $item_names );
    $item->add_meta_data( 'IDs',  $values['wbk_appointment_ids'] );

}
function wbk_order_placed( $order_id ){
    $order = wc_get_order( $order_id );
    $appointment_ids = array();
	foreach ( $order->get_items() as $item_id => $item ) {
        if( !is_object( $item ) ){
            continue;
        }
        if( $item->get_product_id() == get_option( 'wbk_woo_product_id', '' ) ){
            $appointment_ids_this =  explode( ',',  wc_get_order_item_meta( $item_id, 'IDs', true ) );
            $appointment_ids = array_merge( $appointment_ids, $appointment_ids_this );
        }
	}
 	$update_status =  get_option('wbk_woo_update_status', 'paid');
    foreach( $appointment_ids as $appointment_id ){
        if( $update_status == 'disabled' ){
	        WBK_Db_Utils::setAppointmentStatus( $appointment_id, 'woocommerce' );
        } else{
	        WBK_Db_Utils::setAppointmentStatus( $appointment_id, $update_status );
        }
        WBK_Db_Utils::setPaymentMethodToAppointment( $appointment_id, $order_id );
    }

    do_action( 'wbk_woocommerce_order_placed', $appointment_ids, $order_id );
}


function wbk_order_paid( $order_id ){

    $order = wc_get_order( $order_id );
    $appointment_ids = array();
    foreach ( $order->get_items() as $item_id => $item ) {
        if( !is_object( $item ) ){
            continue;
        }
        if( $item->get_product_id() == get_option( 'wbk_woo_product_id', '' ) ){
            $appointment_ids_this =  explode( ',',  wc_get_order_item_meta( $item_id, 'IDs', true ) );
            $appointment_ids = array_merge( $appointment_ids, $appointment_ids_this );
        }
    }
    wbk_email_processing_send_on_payment( $appointment_ids );
    do_action( 'wbk_woocommerce_order_paid', $appointment_ids, $order_id );
}
function wbk_order_paid_cod( $order_id ){
    $order = wc_get_order($order_id);
    $paymethod =  get_post_meta( $order_id, '_payment_method', true );

    if( $paymethod == 'cod' ){
        $appointment_ids = array();
        foreach ( $order->get_items() as $item_id => $item ) {
            if( !is_object( $item ) ){
                continue;
            }
            if( $item->get_product_id() == get_option( 'wbk_woo_product_id', '' ) ){
                $appointment_ids_this =  explode( ',',  wc_get_order_item_meta( $item_id, 'IDs', true ) );
                $appointment_ids = array_merge( $appointment_ids, $appointment_ids_this );
            }
        }
        wbk_email_processing_send_on_payment( $appointment_ids );
        do_action( 'wbk_woocommerce_order_paid', $appointment_ids, $order_id );
    }

}
class WBK_WooCommerce{
    static function renderPaymentMethods( $service_id, $appointment_ids ){
        global $wbk_wording;
        if( !is_array( $service_id ) ){
            $services = array( $service_id );
        } else {
            $services = $service_id;
        }
        foreach( $services as $service_id ){

            $service = new WBK_Service();
            if ( !$service->setId( $service_id ) ){
                return 'Unable to access service: wrong service id.';
            }
            if ( !$service->load() ){
                 return 'Unable to access service: load failed.';
            }
            if ( $service->getPayementMethods() == '' ){
                return '';
            }
            $arr_items = explode( ';', $service->getPayementMethods() );
            if( !in_array( 'woocommerce', $arr_items) ){
                return '';
            }
        }
        $html = '';
        $woo_btn_text =  wbk_get_translation_string( 'wbk_woo_button_text', 'wbk_woo_button_text' , 'Add to cart' );

        $html .= '<input class="wbk-button wbk-width-100 wbk-mt-10-mb-10 wbk-payment-init wbk-payment-init-woo" data-method="woocommerce" data-app-id="'. implode(',',  $appointment_ids ) . '"  value="' . $woo_btn_text . '  " type="button">';
        return $html;
    }
    static function addToCart( $appointment_ids ){
        if ( !class_exists( 'WooCommerce' ) ) {
            return json_encode( array( 'status' => 0, 'details' => __( 'WooCommerce not found', 'wbk' ) ) );
        }
        $product_id = get_option( 'wbk_woo_product_id', '' );
        if( !is_numeric( $product_id ) || $product_id == '' ){
            return json_encode( array( 'status' => 0, 'details' => __( 'Product ID not specified correctly', 'wbk' ) ) );
        }
        $product = wc_get_product( $product_id );
        if( $product == false || is_null( $product ) ){
        	return json_encode( array( 'status' => 0, 'details' => __( 'Booking product not exists', 'wbk' ) ) );
        }
        $verified_ids =  WBK_Db_Utils::filterNotPaidAppointments( $appointment_ids );
        if( count( $verified_ids ) == 0 ){
            return json_encode( array( 'status' => 0, 'details' => __( 'There are no bookings available for adding to cart', 'wbk' ) ) );

        } else{
            if( !session_id() ){
                session_start();
            }
            $_SESSION['wbk_woo_appt_ids'] = implode( ',', $verified_ids );


            WC()->cart->add_to_cart( $product_id );
            $details = get_permalink( wc_get_page_id( 'cart' ) );
            $details = apply_filters( 'wbk_woo_redirect_page', $details );
            return json_encode( array( 'status' => 1, 'details' => $details ) );
        }
    }
}



?>
