<?php

/**
Stripe Payment
*/
class EventPlus_Payments_Stripe extends EventPlus_Payments {

    private $jsSrc = 'https://checkout.stripe.com/checkout.js';

    protected function valid() {
        $valid = false;
        if( trim($this->companyOptions['secret_key']) != '' &&
            trim($this->companyOptions['publishable_key']) != '' ) {
            $valid = true;
        }
        return $valid;
    }

    function submit() {
    	
    	global $wpdb;

        ob_start(); ?>

		<!-- 
		Remove action, ad $post data does not retrived there.
		<form action="<?php echo $this->fields['stripe_process_url']; ?>" method="POST">
		-->
		
		<div id="stripe-payment-form-wrap">
			<form id="stripe-payment-form" action="" method="POST">
				<div id="stripe-payment-message" class="hidden"></div>
				<div>
					<?php
					$currency = $this->companyOptions['default_currency'];
					if( $this->fields['currency_code'] != '' ) {
						$currency = $this->fields['currency_code'];
					}

					$amount = number_format( $this->fields['amount'], 2 );
					$formatedAmt = str_replace( array(',', '.'), array('', ''), $amount );
					//$fullname = evp_get_users_name();
					$lang = get_locale(); ?>

					<!-- <script src="<?php echo $this->jsSrc; ?>" class="stripe-button" 
						data-locale="<?php echo $lang; ?>"
						data-key="<?php echo $this->companyOptions['publishable_key']; ?>"  
						data-amount="<?php echo $formatedAmt; ?>" 
						data-currency = "<?php echo "$currency"; ?>" />
					</script> -->

					

					<!-- <input type="submit" id="registration_stripe_button" class="btn btn-sma77 btn-gr3y btn-ic0n paymen8" value="<?php _e('Pay Now', 'evrplus_language'); ?>">  -->
					<input type='hidden' id='publishable_key' value='<?php echo $this->companyOptions['publishable_key'];?>'>
					<input id="evp-ajax-url" type="hidden" value="<?php echo admin_url('admin-ajax.php'); ?>" name="ajax_url">
					<input type="hidden" id="evp-stripe-item_name" value="<?php echo $this->fields['desc']; ?>" name="item_name" />
					<input type="hidden" id="evp-stripe-item_description"  value="<?php echo $this->fields['desc']; ?>" name="item_description" />
					<input type="hidden" id="evp-stripe-item_currency"  value="<?php echo $currency; ?>" name="item_currency" />
					<input type="hidden" id="evp-stripe-fullname"  value="<?php echo $this->fields['fullname']; ?>" name="item_fullname" />

					

					<input type="hidden" id="evp-stripe-amount"  name="amount" value="<?php echo $amount; ?>" />
					<input type="hidden" id="evp-stripe-item_amount"  name="item_amount" value="<?php echo $formatedAmt; ?>" />
					<input type="hidden" id="evp-stripe-token"  name="token" value="<?php echo $this->fields['token']; ?>" />
					<input type="hidden" id="evp-stripe-event_id"  name="event_id" value="<?php echo $this->fields['event_id']; ?>" />

					<div class="form-group">
						<label><strong>E-Mail</strong></label>
						<input type="email" id="evp-stripe-email" value="<?php echo $this->fields['a_email'];?>" class="form-control" maxlength="50" required>
					</div>
					<h3>Enter Credit Card Information</h3>
					<div id="stripe-payment-element">
						<!--Stripe.js will inject the Payment Element here to get card details-->
					</div>
					<button id="submit-button" class="pay">
						<div class="spinner hidden" id="spinner"></div>
						<span id="submit-text">Pay Now</span>
					</button>

					
					<!--
					// No need this for now
					<input type="hidden" name="evrplus_stripe_payments" value="1" />
					-->
				</div>
				<div id="payment_processing" class="hidden">
					<span class="loader"></span> Please wait! Your payment is processing...
				</div>
				<div id="payment-reinitiate" class="hidden">
					<button class="btn btn-primary" onclick="reinitiateStripe()">Reinitiate Payment</button>
				</div>
			</form>
		</div>

		<input type="button" onclick="showStripeCheckout()" id="registration_stripe_button" class="btn btn-sma77 btn-gr3y btn-ic0n paymen8" value="<?php _e('Pay Now', 'evrplus_language'); ?>" />
        <style>
            .stripe-button-el{ display: none !important; }
            .stripe-button-el span{ display: none !important; }
			#submit-button{
				margin-top: 20px;
				background-color: #e9e9e9;
				color: #5e5e5e !important;
				box-shadow: 0 3px 0 0 #ccc;
				border-radius: 5px;
				border-style: none;
				padding: 10px;
				cursor: pointer;
			}
			input#evp-stripe-email {
				padding-top: 10px;
				padding-bottom: 10px;
			}
			#stripe-payment-form-wrap{
				display: none;
			}
        </style>
		<script src="https://js.stripe.com/v3/"></script>
		<script src="<?php echo EVENT_PLUS_PLUGIN_URL."assets/js/stripe-checkout.js";?>" defer></script>
        <?php
        return ob_get_clean();
    }
}
