<?php

require_once 'src/Ctct/autoload.php';

use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\ContactList;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

global $MdlDb;
$res = $wpdb->get_results($wpdb->prepare("SELECT * FROM ".$MdlDb->autoresponder." WHERE responder_id=%d",9));$res = $res[0]; // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $MdlDb->autoresponder is table name defined globally. False Positive alarm 
$api_key = stripslashes($res->responder_api_key);
$access_token = stripslashes($res->responder_list_id);


$data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM ".$MdlDb->ar." WHERE frm_id = %d", $fid), 'ARRAY_A' ); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $MdlDb->ar is table name defined globally. False Positive alarm 
			
$arr_constant_contact 	= maybe_unserialize( $data[0]['constant_contact'] );
$list_id1 = stripslashes($arr_constant_contact['type_val']);

if( $list_id1 != '' )
{
	define("APIKEY", $api_key);
	define("ACCESS_TOKEN", $access_token);
	
	 
	$cc = new ConstantContact(APIKEY);
	
	// attempt to fetch lists in the account, catching any exceptions and printing the errors to screen
	try{
		$lists = $cc->getLists(ACCESS_TOKEN);
		
		foreach ($lists as $list) {
			if( $list->id == $list_id1 ) {
				$list_id = $list->id;
			}
		}
		
	} catch (CtctException $ex) {
		foreach ($ex->getErrors() as $error) {

		}     
	}
	
	
	// check if the form was submitted
	if (isset($email) && strlen($email) > 1) {
		$action = "Getting Contact By Email Address";
		try {
			// check to see if a contact with the email addess already exists in the account
			$response = $cc->getContactByEmail(ACCESS_TOKEN,$email);
			
			global $arf_debug_log_id;

			// create a new contact if one does not exist
			if (empty($response->results)) {
				$action = "Creating Contact";
	
				$contact = new Contact();
				$contact->addEmail($email);
				$contact->addList($list_id);
				$contact->first_name = $fname;
				$contact->last_name = $lname;
				$returnContact = $cc->addContact(ACCESS_TOKEN, $contact);
			
				$arf_success_msg=array(	
					'success' => 'true',
					'message'     => esc_html("Constant contact Authorization Successfully.","ARForms"),
				);
				do_action('arforms_debug_log_entry','constant_contact_debug_log', 'Constant contact Authorization sent response from frontend', 'arforms_constant_contact_data', $arf_success_msg, $arf_debug_log_id);			

			// update the existing contact if address already existed
			} else {            
				$action = "Updating Contact";
	
				$contact = $response->results[0];
				$contact->addList($list_id);
				$contact->first_name = $fname;
				$contact->last_name = $lname;
				$returnContact = $cc->updateContact(ACCESS_TOKEN, $contact);  
				
				$arf_success_msg=array(	
					'success' => 'true',
					'message'     => esc_html("Constant contact Authorization Successfully.","ARForms"),
				);
				do_action('arforms_debug_log_entry','constant_contact_debug_log', 'Constant contact Authorization sent response from frontend', 'arforms_constant_contact_data', $arf_success_msg, $arf_debug_log_id);			
			}
			
		// catch any exceptions thrown during the process and print the errors to screen
		} catch (CtctException $ex) {
			
			
			$arf_error_msg=array(	
				'success' => 'true',
				'message'     => $ex,
			);
			do_action('arforms_debug_log_entry','constant_contact_debug_log', 'Constant contact Authorization sent response from frontend', 'arforms_constant_contact_data', $arf_error_msg, $arf_debug_log_id);	
		}
	}
} 
?>