<?php
class arf_pro_beaver_builder{
    function __construct(){

        add_action( 'init', array( $this, 'arf_pro_load_modules') );

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_enqueue_beaver_builder_assets'));

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_get_trigger_type_assets'));

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_get_click_type_assets'));

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_get_overlay_assets'));

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_get_animation_assets'));

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_get_link_position_assets'));

        add_action( 'enqueue_block_editor_assets' ,array($this,'arf_get_button_angle_assets'));
    }

    static public function arf_pro_load_modules() {

        if ( class_exists( 'FLBuilder' ) ) {
            require_once FORMPATH.'/integrations/Beaver_Builder/modules/arf_pro_beaver_builder_module/arf_pro_beaver_builder_module.php';
        }
       
    }

    function arf_enqueue_beaver_builder_assets()
    {
        global $arfversion, $wpdb, $MdlDb,$armainhelper, $arformsmain;

		$arforms_forms = $MdlDb->forms;
        
        $arforms_forms_data = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".$arforms_forms."` WHERE is_template = %d AND (status is NULL OR status = '' OR status = %s ) AND arf_is_lite_form = 0 ORDER BY id DESC", 0, 'published' ) ); //phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- Reason: $arforms_forms is table name defined globally. False Positive alarm

		$arforms_forms_list = array();
		
		$arforms_forms_list['0']            = esc_html__("Please select a form",'ARForms');
		foreach( $arforms_forms_data as $k => $value ) {
			$arforms_forms_list[$value->id]    = $value->name . ' (id: ' . $value->id . ')';
		}
        return $arforms_forms_list;
    }

    function arf_get_trigger_type_assets()
    {
        $arf_trigger=array(
            'onclick'      =>       __('On Click' , 'ARForms'),
            'onload'       =>       __('On Page Load' , 'ARForms'),
            'scroll'       =>       __('On Page Scroll' , 'ARForms'),
            'timer'        =>       __('On Timer(Scheduled)' , 'ARForms'),
            'on_exit'      =>       __('On Exit(Exit Intent)' , 'ARForms'),
            'on_idle'      =>       __('On Idle' , 'ARForms'),
        );

        return $arf_trigger;
    }

    function arf_get_click_type_assets()
    {
        $arf_click_type=array(
            'link'      =>       __('link' , 'ARForms'),
            'button'    =>       __('Button' , 'ARForms'),
            'image'     =>       __('Image' , 'ARForms'),
            'sticky'    =>       __('Sticky' , 'ARForms'),
            'fly'       =>       __('Fly (Sidebar)' , 'ARForms'),
        );

        return $arf_click_type;
    }

    function arf_get_overlay_assets()
    {
        $arf_overlay=array(
            '0'        =>       __('0 (None)' , 'ARForms'),
            '0.1'      =>       __('10% (None)' , 'ARForms'),
            '0.2'      =>       __('20% (None)' , 'ARForms'),
            '0.3'      =>       __('30% (None)' , 'ARForms'),
            '0.4'      =>       __('40% (None)' , 'ARForms'),
            '0.5'      =>       __('50% (None)' , 'ARForms'),
            '0.6'      =>       __('60% (None)' , 'ARForms'),
            '0.7'      =>       __('70% (None)' , 'ARForms'),
            '0.8'      =>       __('80% (None)' , 'ARForms'),
            '0.9'      =>       __('90% (None)' , 'ARForms'),
            '1'        =>       __('100% (None)' , 'ARForms'),
            
        );

        return $arf_overlay;
    }

    function arf_get_animation_assets()
    {
        $arf_animation=array(
            'no_animation'        =>       __('No Animation' , 'ARForms'),
            'fade_in'             =>       __('Fade-In' , 'ARForms'),
            'slide_in_top'        =>       __('Slide In Top' , 'ARForms'),
            'slide_in_bottom'     =>       __('Slide In Bottom' , 'ARForms'),
            'slide_in_right'      =>       __('Slide In right' , 'ARForms'),
            'slide_in_left'       =>       __('Slide In Left' , 'ARForms'),
            'zoom_in'             =>       __('Zoom In' , 'ARForms'),
        );

        return $arf_animation;
    }

    function arf_get_link_position_assets()
    {
        $arf_link_position=array(
            'top'               =>       __('Top' , 'ARForms'),
            'bottom'            =>       __('Bottom' , 'ARForms'),
            'left'              =>       __('Left' , 'ARForms'),
            'right'             =>       __('Right' , 'ARForms'),
        );

        return $arf_link_position;
    }

    function arf_get_button_angle_assets()
    {
        $arf_button_angle=array(
            '0'                 =>       __('0' , 'ARForms'),
            '90'                =>       __('90' , 'ARForms'),
            '-90'               =>       __('-90' , 'ARForms'),
        );

        return $arf_button_angle;
    }

}
global $arf_pro_beaver_builder;
$arf_pro_beaver_builder =new arf_pro_beaver_builder();

?>