<?php
class arforms_pro_debug_log{  

    var $setvaltolic;
    var $arforms_view_log_token;

    function __construct() {

        global $arfdebuglog;
        
        //add_action('wp_ajax_arforms_save_debug_log_setting_data', array( $this, 'arforms_save_debug_log_settings_details' ));

        add_action( 'arforms_render_pro_debug_log_blocks', array( $this, 'email_marketer_logs_block' ) );

        add_action( 'arforms_render_pro_debug_log_blocks', array( $this, 'payment_gateways_log_blocks') );

        add_action( 'arforms_render_pro_debug_log_blocks', array( $this, 'arforms_extra_log_blocks'), 100 );

        add_action( 'arforms_render_email_marketers_log_settings', array( $this, 'arf_aweber_block') );
        add_action( 'arforms_render_email_marketers_log_settings', array( $this, 'arf_mailchimp_block') );
        add_action( 'arforms_render_email_marketers_log_settings', array( $this, 'arf_getresponse_block') );
        add_action( 'arforms_render_email_marketers_log_settings', array( $this, 'arf_icontact_block') );
        add_action( 'arforms_render_email_marketers_log_settings', array( $this, 'arf_constant_contact_block') );

        add_action( 'plugins_loaded', array( $this, 'arforms_set_debug_token'), 11 );

    }

    function arforms_set_debug_token(){
        $this->arforms_view_log_token = wp_create_nonce('arflite_view_debug_log_nonce');
    }

    public static function arforms_save_pro_debug_log_data( $posted_data ){

        global $arformsmain;

        $aweber_debug_log = isset( $posted_data['aweber_debug_log'] ) ? $posted_data['aweber_debug_log'] : 0;
        $arformsmain->arforms_update_settings( 'aweber_debug_log', $aweber_debug_log, 'debug_log_settings' );

        $mailchimp_debug_log = isset( $posted_data['mailchimp_debug_log'] ) ? $posted_data['mailchimp_debug_log'] : 0;
        $arformsmain->arforms_update_settings( 'mailchimp_debug_log', $mailchimp_debug_log, 'debug_log_settings' );

        $getresponse_debug_log = isset( $posted_data['getresponse_debug_log'] ) ? $posted_data['getresponse_debug_log'] : 0;
        $arformsmain->arforms_update_settings( 'getresponse_debug_log', $getresponse_debug_log, 'debug_log_settings' );

        $icontact_debug_log = isset( $posted_data['icontact_debug_log'] ) ? $posted_data['icontact_debug_log'] : 0;
        $arformsmain->arforms_update_settings( 'icontact_debug_log', $icontact_debug_log, 'debug_log_settings' );

        $constant_contact_debug_log = isset( $posted_data['constant_contact_debug_log'] ) ? $posted_data['constant_contact_debug_log'] : 0;
        $arformsmain->arforms_update_settings( 'constant_contact_debug_log', $constant_contact_debug_log, 'debug_log_settings' );

        do_action( 'arforms_save_additional_debug_log_data', $posted_data );

    }

    function initialize(){
        global $current_user, $arformcontroller, $maincontroller, $arforms_pro_debug_log;

        if( !empty( $arforms_pro_debug_log->setvaltolic) ) {
            return $arforms_pro_debug_log->setvaltolic;
        }

        global $arformcontroller,$arformsplugin;
        $setvaltolic = 0;
        $setvaltolic = $arformcontroller->$arformsplugin();

        $arforms_pro_debug_log->setvaltolic = $setvaltolic;
    }

    function arforms_get_licval(){
        return $this->setvaltolic;
    }
    public static function arforms_render_pro_debug_log_ui(){
        global $arforms_pro_debug_log;
        $arforms_pro_debug_log->initialize();

        do_action( 'arforms_render_pro_debug_log_blocks' );
    }

    function email_marketer_logs_block(){
        ?>
            <div class="arf_debug_log_parent_wrapper">
                <div class="arf-debug-log-sub-heading">
                    <span class="lbltitle"><?php echo esc_html__( 'Email Marketers Debug Log', 'ARForms' ); ?></span>
                </div>
                <?php do_action( 'arforms_render_email_marketers_log_settings' ); ?>
            </div>
        <?php
    }

    function payment_gateways_log_blocks(){
        $arf_display_pg_log_block = apply_filters( 'arforms_enable_payment_gateway_block', false );

        if( true == $arf_display_pg_log_block ){
            ?>
                <div class="arf_debug_log_parent_wrapper">
                    <div class="arf-debug-log-sub-heading">
                        <span class="lbltitle"><?php echo esc_html__( 'Payment Gateways Debug Log', 'ARForms' ); ?></span>
                    </div>
                    <?php do_action( 'arforms_render_payment_gateways_log_settings' ); ?>
                </div>
            <?php
        }
    }

    function arforms_extra_log_blocks(){
        ?>
            <div class="arf_debug_log_parent_wrapper">
                <div class="arf-debug-log-sub-heading">
                    <span class="lbltitle"><?php echo esc_html__( 'Additional Debug Log', 'ARForms' ); ?></span>
                </div>
                <?php do_action( 'arforms_additional_debug_log_settings' ); ?>
            </div>
        <?php
    }

    function arf_aweber_block(){
        global $arformsmain;
        $aweber_debug_log = $arformsmain->arforms_get_settings( 'aweber_debug_log', 'debug_log_settings' );

        $onchange_func = 'arforms_hide_show_debug_settings(this.checked, "aweber_logs");';
        $onclick_func = '';
        $log_cls = '';

        if( $this->setvaltolic != 1 ){
            $onclick_func = 'alert(\'Please activate license to enable aweber debug log\'); return false;';
            $onchange_func = 'return false;';
            $log_cls = 'arf_restricted_control';
        }

        ?>

        <div class="arf-inner-heading">
            <span class="lblsubtitle lblnotetitle "><?php echo esc_html__( 'Aweber Debug Log', 'ARForms' ); ?></span>
            <div class="arf_js_switch_wrapper <?php echo esc_attr( $log_cls ); ?> arf-checkbox">
                
                <input type="checkbox" class="js-switch" id="aweber_debug_log" name="aweber_debug_log" value="1" <?php echo !empty( $onclick_func ) ? 'onclick="' . $onclick_func . '"' : ''; ?>  <?php checked($aweber_debug_log, 1);?> onchange="<?php echo esc_attr( $onchange_func ); ?>" />
                <span class="arf_js_switch"></span>
            </div>
            <div class="arforms_debug_log_setting_wrapper" data-type="aweber_logs" style="<?php echo ( 1 == $aweber_debug_log ) ? 'display:table-row;' : 'display:none;'; ?>">
                <div class="arf-log-button-div">
                    <button type="button" class="arf-debug-log-button arf-view-img arforms_view_debug_logs" data-log-type="aweber_debug_log" data-token="<?php echo $this->arforms_view_log_token;//phpcs:ignore ?>" id="arf_email_popup_view_log"><?php esc_html_e('View Logs', 'ARForms' ); ?></button>
                    <button type="button" class="arf-debug-log-button arf-download-img" id="arf_email_popup_download_log" onclick="return Show_downloadpopup('aweber_debug_log')";><?php esc_html_e('Download Logs', 'ARForms'); ?></button>
                    <button type="button" class="arf-debug-log-button arf-clear-img" id="arf_email_popup_clear_log" onclick="return Show_clearpopup('aweber_debug_log')";><?php esc_html_e('Clear Logs', 'ARForms'); ?></button>
                </div>
            </div>
        </div>
                
        <?php
        
    }
    function arf_mailchimp_block(){
        global $arformsmain;
        $mailchimp_debug_log = $arformsmain->arforms_get_settings( 'mailchimp_debug_log', 'debug_log_settings' );

        $onchange_func = 'arforms_hide_show_debug_settings(this.checked, "mailchimp_logs");';
        $onclick_func = '';
        $log_cls = '';

        if( $this->setvaltolic != 1 ){
            $onclick_func = 'alert(\'Please activate license to enable mailchimp debug log\'); return false;';
            $onchange_func = 'return false;';
            $log_cls = 'arf_restricted_control';
        }
        ?>
        
        <div class="arf-inner-heading">
            <span class="lblsubtitle lblnotetitle "><?php echo esc_html__( 'Mailchimp Debug Log', 'ARForms' ); ?></span>
            <div class="arf_js_switch_wrapper <?php echo esc_attr( $log_cls ); ?> arf-checkbox">
                <input type="checkbox" class="js-switch" id="mailchimp_debug_log" name="mailchimp_debug_log" value="1"  <?php checked($mailchimp_debug_log, 1);?> <?php echo !empty( $onclick_func ) ? 'onclick="' . $onclick_func . '"' : ''; ?> onchange="<?php echo esc_attr( $onchange_func ); ?>" />                
                <span class="arf_js_switch"></span>
            </div>
            <div class="arforms_debug_log_setting_wrapper" data-type="mailchimp_logs" style="<?php echo ( 1 == $mailchimp_debug_log ) ? 'display:table-row;' : 'display:none;'; ?>">
                <div class="arf-log-button-div">
                    <button type="button" class="arf-debug-log-button arf-view-img arforms_view_debug_logs" id="arf_email_popup_view_log" data-log-type="mailchimp_debug_log" data-token="<?php echo $this->arforms_view_log_token;//phpcs:ignore ?>" ><?php esc_html_e('View Logs', 'ARForms' ); ?></button>
                    <button type="button" class="arf-debug-log-button arf-download-img" id="arf_email_popup_download_log" onclick="return Show_downloadpopup('mailchimp_debug_log')";><?php esc_html_e('Download Logs', 'ARForms'); ?></button>
                    <button type="button" class="arf-debug-log-button arf-clear-img" id="arf_email_popup_clear_log" onclick="return Show_clearpopup('mailchimp_debug_log')";><?php esc_html_e('Clear Logs', 'ARForms'); ?></button>
                </div>
            </div>
        </div>
       <?php
     
    }
    function arf_getresponse_block(){
        global $arformsmain;
        $getresponse_debug_log = $arformsmain->arforms_get_settings( 'getresponse_debug_log', 'debug_log_settings' );
        
        $onchange_func = 'arforms_hide_show_debug_settings(this.checked, "getresponse_logs");';
        $onclick_func = '';
        $log_cls = '';

        if( $this->setvaltolic != 1 ){
            $onclick_func = 'alert(\'Please activate license to enable getresponse debug log\'); return false;';
            $onchange_func = 'return false;';
            $log_cls = 'arf_restricted_control';
        }
        ?>
        
        <div class="arf-inner-heading">
            <span class="lblsubtitle lblnotetitle "><?php echo esc_html__( 'Getresponse Debug Log', 'ARForms' ); ?></span>
            <div class="arf_js_switch_wrapper <?php echo esc_attr( $log_cls ); ?> arf-checkbox">
                
                <input type="checkbox" class="js-switch" id="getresponse_debug_log" name="getresponse_debug_log" value="1"  <?php checked($getresponse_debug_log, 1);?><?php echo !empty( $onclick_func ) ? 'onclick="' . $onclick_func . '"' : ''; ?> onchange="<?php echo esc_attr( $onchange_func ); ?>"/>
                
                <span class="arf_js_switch"></span>
            </div>
            <div class="arforms_debug_log_setting_wrapper" data-type="getresponse_logs" style="<?php echo ( 1 == $getresponse_debug_log ) ? 'display:table-row;' : 'display:none;'; ?>" >
                <div class="arf-log-button-div">
                    <button type="button" class="arf-debug-log-button arf-view-img arforms_view_debug_logs" id="arf_email_popup_view_log" data-log-type="getresponse_debug_log" data-token="<?php echo $this->arforms_view_log_token;//phpcs:ignore ?>"><?php esc_html_e('View Logs', 'ARForms' ); ?></button>
                    <button type="button" class="arf-debug-log-button arf-download-img" id="arf_email_popup_download_log" onclick="return Show_downloadpopup('getresponse_debug_log')";><?php esc_html_e('Download Logs', 'ARForms'); ?></button>
                    <button type="button" class="arf-debug-log-button arf-clear-img" id="arf_email_popup_clear_log" onclick="return Show_clearpopup('getresponse_debug_log')";><?php esc_html_e('Clear Logs', 'ARForms'); ?></button>
                </div>
            </div>
        </div>
        <?php
    }
    function arf_icontact_block(){
        global $arformsmain;
        $icontact_debug_log = $arformsmain->arforms_get_settings( 'icontact_debug_log', 'debug_log_settings' );

        $onchange_func = 'arforms_hide_show_debug_settings(this.checked, "icontact_logs");';
        $onclick_func = '';
        $log_cls = '';

        if( $this->setvaltolic != 1 ){
            $onclick_func = 'alert(\'Please activate license to enable icontact debug log\'); return false;';
            $onchange_func = 'return false;';
            $log_cls = 'arf_restricted_control';
        }
        ?>
        
        <div class="arf-inner-heading">
            <span class="lblsubtitle lblnotetitle "><?php echo esc_html__( 'Icontact Debug Log', 'ARForms' ); ?></span>
            <div class="arf_js_switch_wrapper <?php echo esc_attr( $log_cls ); ?> arf-checkbox">
                
                <input type="checkbox" class="js-switch" id="icontact_debug_log" name="icontact_debug_log" value="1"  <?php checked($icontact_debug_log, 1);?><?php echo !empty( $onclick_func ) ? 'onclick="' . $onclick_func . '"' : ''; ?> onchange="<?php echo esc_attr( $onchange_func ); ?>" />
                
                <span class="arf_js_switch"></span>
            </div>
            <div class="arforms_debug_log_setting_wrapper" data-type="icontact_logs" style="<?php echo ( 1 == $icontact_debug_log ) ? 'display:table-row;' : 'display:none;'; ?>">
                <div class="arf-log-button-div">
                    <button type="button" class="arf-debug-log-button arf-view-img arforms_view_debug_logs" id="arf_email_popup_view_log" data-log-type="icontact_debug_log" data-token="<?php echo $this->arforms_view_log_token;//phpcs:ignore ?>"><?php esc_html_e('View Logs', 'ARForms' ); ?></button>
                    <button type="button" class="arf-debug-log-button arf-download-img" id="arf_email_popup_download_log" onclick="return Show_downloadpopup('icontact_debug_log')";><?php esc_html_e('Download Logs', 'ARForms'); ?></button>
                    <button type="button" class="arf-debug-log-button arf-clear-img" id="arf_email_popup_clear_log" onclick="return Show_clearpopup('icontact_debug_log')";><?php esc_html_e('Clear Logs', 'ARForms'); ?></button>
                </div>
            </div>
        </div>
        <?php
    }
    function arf_constant_contact_block(){

        global $arformsmain;
        $constant_contact_debug_log = $arformsmain->arforms_get_settings( 'constant_contact_debug_log', 'debug_log_settings' );

        $onchange_func = 'arforms_hide_show_debug_settings(this.checked, "contant_contact_logs");';
        $onclick_func = '';
        $log_cls = '';

        if( $this->setvaltolic != 1 ){
            $onclick_func = 'alert(\'Please activate license to enable constant contact debug log\'); return false;';
            $onchange_func = 'return false;';
            $log_cls = 'arf_restricted_control';
        }
        ?>
        
        <div class="arf-inner-heading">
            <span class="lblsubtitle lblnotetitle "><?php echo esc_html__( 'Constant contact Debug Log', 'ARForms' ); ?></span>
            <div class="arf_js_switch_wrapper <?php echo esc_attr( $log_cls ); ?> arf-checkbox">
                
                <input type="checkbox" class="js-switch" id="constant_contact_debug_log" name="constant_contact_debug_log" value="1"  <?php checked($constant_contact_debug_log, 1);?> <?php echo !empty( $onclick_func ) ? 'onclick="' . $onclick_func . '"' : ''; ?> onchange="<?php echo esc_attr( $onchange_func ); ?>" />
                
                <span class="arf_js_switch"></span>
            </div>
            <div class="arforms_debug_log_setting_wrapper" data-type="contant_contact_logs" style="<?php echo ( 1 == $constant_contact_debug_log ) ? 'display:table-row;' : 'display:none;'; ?>">
                <div class="arf-log-button-div">
                    <button type="button" class="arf-debug-log-button arf-view-img arforms_view_debug_logs" id="arf_email_popup_view_log"  data-log-type="constant_contact_debug_log" data-token="<?php echo $this->arforms_view_log_token;//phpcs:ignore ?>"><?php esc_html_e('View Logs', 'ARForms' ); ?></button>
                    <button type="button" class="arf-debug-log-button arf-download-img" id="arf_email_popup_download_log" onclick="return Show_downloadpopup('constant_contact_debug_log')";><?php esc_html_e('Download Logs', 'ARForms'); ?></button>
                    <button type="button" class="arf-debug-log-button arf-clear-img" id="arf_email_popup_clear_log" onclick="return Show_clearpopup('constant_contact_debug_log')"; ><?php esc_html_e('Clear Logs', 'ARForms'); ?></button>
                </div>
            </div>
        </div>
        <?php
    }
    

}
global $arforms_pro_debug_log;
$arforms_pro_debug_log = new arforms_pro_debug_log();