<?php

global $arf_accordion_field;

$arf_accordion_field = new arf_accordion_field();

class arf_accordion_field{

	function __construct(){

		add_filter( 'arfaavailablefields', array( $this, 'arf_add_accordion_field_element_list'), 11);

        add_filter( 'arf_new_field_array_filter_outside', array( $this, 'arf_add_accordion_field_outside' ), 11, 4 );
	
		add_filter( 'arf_new_field_array_materialize_filter_outside', array( $this, 'arf_add_accordion_field_outside' ), 11, 4 );

		add_filter( 'arf_new_field_array_materialize_outlined_filter_outside', array( $this, 'arf_add_accordion_field_outside', ), 11, 4 );

        add_filter( 'arf_positioned_field_options_icon', array( $this, 'arf_change_accordion_field_option_icon_data'),10,2);

		add_filter( 'arfavailablefieldsbasicoptions', array( $this, 'arf_set_accordion_field_options') );

		add_filter( 'arf_display_field_in_editor_outside', array( $this, 'arf_display_field_accordion_in_form_editor'), 10, 2 );

		add_action( 'arf_render_field_in_editor_outside', array( $this, 'arf_render_accordion_field_in_editor'), 10, 13 ); 

		add_filter( 'arf_field_option_icon_render_outside', array( $this, 'arf_field_delete_inner_box'), 10, 8);

		add_filter( 'arf_add_parent_data_to_field', array( $this, 'arf_add_parent_accordion_field_data_to_field'), 10, 3 );

		add_filter( 'form_fields', array( $this, 'arf_render_accordion_field_in_form' ), 10, 11 );
    }

	function arf_render_accordion_field_in_form(  $return_string, $form, $field_name, $arf_data_uniq_id, $field, $field_tooltip, $field_description,$OFData,$inputStyle,$arf_main_label,$arf_on_change_function ){

		if( 'arf_accordion' == $field['type'] ){
			global $MdlDb, $wpdb,$arrecordhelper,$arformcontroller,$all_preview_fields,$arfieldhelper, $arf_glb_preset_data;

			$arfsubmitbuttonstyle = isset($form->form_css['arfsubmitbuttonstyle']) ? $form->form_css['arfsubmitbuttonstyle'] : 'border';
			$sbmt_class = "btn btn-flat";
			$total_accordions = isset($field['field_options']['total_accordions']) ? $field['field_options']['total_accordions'] : 0;
			$is_preview = false;
			if( isset( $_REQUEST['arf_opt_id'] ) && '' != $_REQUEST['arf_opt_id']  ){
				$is_preview = true;
			}

			if( !empty( $total_accordions ) ){
				$return_string .= '<div class="arf_accordion_wrapper_container">';
				for( $tc = 1; $tc <= $total_accordions; $tc++ ){
					if( $is_preview && !empty( $all_preview_fields ) ){
						$get_all_inner_fields = array();
						
						foreach( $all_preview_fields as $pfkey => $pfval ){
							if( isset( $pfval->has_parent ) && $pfval->has_parent && $pfval->parent_field == $field['id'] ){
								$get_all_inner_fields[] = $arformcontroller->arfObjtoArray($pfval);
							}
						}
					} else {
							$get_all_inner_fields = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".$MdlDb->fields."` WHERE (field_options LIKE '%\"parent_field\":\"%d\"%' OR field_options LIKE '%\"parent_field\":%d%') AND ( field_options LIKE '%\"accordion_counter\":\"%d\"%' OR field_options LIKE '%\"accordion_counter\":%d%' )", $field['id'], $field['id'], $tc, $tc ), ARRAY_A );
					}

					if( !empty( $get_all_inner_fields ) ){
						
						$return_string .= "<div class='arf_accordion_inner_container'>";
							$return_string .= "<input type='radio' name='arf_accordion_check_".$field['id']."' id='arf_accordion_check_".$field['id']."_".$tc."' class='arf_accordion_check' ". checked( 1, $tc, false ). " />";
							$return_string .= "<label class='arf_accordion_heading_label' for='arf_accordion_check_".$field['id']."_".$tc."'>";
								$return_string .= !empty( $field['field_options']['accordion_labels'][ $tc ] ) ? $field['field_options']['accordion_labels'][ $tc ] : '';
								$return_string .= "<span class='arf_accordion_heading_label_icon'>";
									$return_string .= "<i class='arf_accordion_label_icon arf_accordion_active_icon ".$field['field_options']['arf_prefix_icon']."'></i>";
									$return_string .= "<i class='arf_accordion_label_icon arf_accordion_inactive_icon ".$field['field_options']['arf_suffix_icon']."'></i>";
								$return_string .= "</span>";
							$return_string .= "</label>";
							$return_string .= "<div class='arf_accordion_field_container'>";
								if( $is_preview && !empty( $all_preview_fields ) ){
									$all_inner_fields = array();

									foreach( $get_all_inner_fields as $ik => $in_field ){
										if( is_array( $in_field ) ){
											if( !isset( $all_inner_fields[$ik]) ){
												$all_inner_fields[$ik] = new stdClass;
											}
											
											foreach( $in_field as $infk => $infv ){
												if( 'field_options' == $infk ){
													$inf_opt = arf_json_decode( $infv, true );
													$temp_obj = array();
													foreach( $inf_opt as $ink => $inv ){
														$temp_obj[$ink] = $inv;
													}
													$all_inner_fields[$ik]->$infk = $temp_obj;
												} else if( 'options' == $infk ){
													if( '' != $infv ){
														$inf_opt = arf_json_decode( $infv, true );
														$temp_obj = array();
														foreach( $inf_opt as $ink => $inv ){
															$temp_obj[$ink] = $inv;
														}
														$all_inner_fields[$ik]->$infk = $temp_obj;
													} else {
														$all_inner_fields[$ik]->$infk = $infv;
													}
												} else {
													$all_inner_fields[$ik]->$infk = $infv;
												}
											}
										}
									}
									$values = $arrecordhelper->setup_new_vars($all_inner_fields, $form);
								} else {
									$all_inner_fields = array();

									foreach( $get_all_inner_fields as $ik => $in_field ){
										if( is_array( $in_field ) ){
											if( !isset( $all_inner_fields[$ik]) ){
												$all_inner_fields[$ik] = new stdClass;
											}
											
											foreach( $in_field as $infk => $infv ){
												if( 'field_options' == $infk ){
													$inf_opt = arf_json_decode( $infv, true );
													$temp_obj = array();
													foreach( $inf_opt as $ink => $inv ){
														$temp_obj[$ink] = $inv;
													}
													$all_inner_fields[$ik]->$infk = $temp_obj;
												} else if( 'options' == $infk ){
													if( '' != $infv ){
														$inf_opt = arf_json_decode( $infv, true );
														$temp_obj = array();
														foreach( $inf_opt as $ink => $inv ){
															$temp_obj[$ink] = $inv;
														}
														$all_inner_fields[$ik]->$infk = $temp_obj;
													} else {
														$all_inner_fields[$ik]->$infk = $infv;
													}
												} else {
													$all_inner_fields[$ik]->$infk = $infv;
												}
											}
										}
									}
									$values = $arrecordhelper->setup_new_vars($all_inner_fields, $form);
									
								}

								$totalpass = 0;
								foreach( $values['fields'] as $arrkey => $iconf_field ){

									if( 'email' == $iconf_field['type'] && $iconf_field['confirm_email'] ){
										if( isset( $iconf_field['confirm_email'] ) && 1 == $iconf_field['confirm_email'] && isset( $arf_load_confirm_email['confirm_email_field'] ) && $arf_load_confirm_email['confirm_email_field'] == $iconf_field['id'] ){
											$values['confirm_email_arr'][$iconf_field['id']] = isset($iconf_field['confirm_email_field']) ? $iconf_field['confirm_email_field'] : "";
										} else {
											$arf_load_confirm_email['confirm_email_field'] = isset($iconf_field['confirm_email_field']) ? $iconf_field['confirm_email_field'] : "";
										}
										$confirm_email_field = $arfieldhelper->get_confirm_email_field($iconf_field);

										$values['fields'] = $arfieldhelper->array_push_after($values['fields'], array($confirm_email_field), (int)$arrkey + (int)$totalpass);
										$totalpass++;
									}
									if( 'password' == $iconf_field['type'] && $iconf_field['confirm_password'] ){
										if( isset( $iconf_field['confirm_password'] ) && 1 == $iconf_field['confirm_password'] && isset( $arf_load_confirm_password['confirm_password_field'] ) && $arf_load_confirm_password['confirm_password_field'] == $iconf_field['id'] ){
											$values['confirm_password_arr'][$iconf_field['id']] = isset($iconf_field['confirm_password_field']) ? $iconf_field['confirm_password_field'] : "";
										} else {
											$arf_load_confirm_password['confirm_password_field'] = isset($iconf_field['confirm_password_field']) ? $iconf_field['confirm_password_field'] : "";
										}
										$confirm_password_field = $arfieldhelper->get_confirm_password_field($iconf_field);

										$values['fields'] = $arfieldhelper->array_push_after($values['fields'], array($confirm_password_field), (int)$arrkey + (int)$totalpass);
										$totalpass++;
									}
								}

								$return_string .= $arformcontroller->get_all_field_html( $form, $values, $arf_data_uniq_id, $all_inner_fields, $is_preview, false, $inputStyle, $arf_glb_preset_data, true, 0, $field['id'], false, $tc );
								
							$return_string .= "</div>";
						$return_string .= "</div>";
					}					
				}
				$return_string .= '</div>';
			}

		}

		return $return_string;
	}

	function arf_add_parent_accordion_field_data_to_field( $field_data_object_array, $ftype, $parent_field_id ){

		$no_parent_data_fields = apply_filters( 'arf_prevent_parent_data_in_fields', array('divider', 'section', 'break', 'hidden', 'imagecontrol', 'arf_repeater') );
		if( !in_array( $ftype, $no_parent_data_fields ) ){

			$field_data_object_array['field_data'][$ftype]['has_parent'] = true;
			$field_data_object_array['field_data'][$ftype]['parent_field'] = $parent_field_id;
			$field_data_object_array['field_data'][$ftype]['parent_field_type'] = 'section';
			$field_data_object_array['field_data'][$ftype]['accordion_counter'] = '1';

		}

		return $field_data_object_array;
	}

	function arf_render_accordion_field_in_editor( $check_field, $field_data_obj, $field_order, $inner_field_order,$index_arf_fields, $frm_css, $data, $id,$inner_field_resize_width, $unsaved_inner_fields, $return_html, $newarr, $remove_placeholders ){
		

		global $arformcontroller,$MdlDb,$wpdb,$bootstraped_fields_array,$fields_with_external_js, $arfieldcontroller,$arfieldhelper,$index_repeater_fields;

		if( 'arf_accordion' == $check_field['type'] ){
			$arf_accordion_field = '';

			$field_type = $check_field['type'];

			$accordion_fid = $check_field['id'];

			if( is_array( $inner_field_order ) ){
				$inner_field_order = json_encode( $inner_field_order );
			}
			$arf_main_label_cls = '';
			if ($frm_css['arfinputstyle'] == 'material') {
				$arf_main_label_cls = $arformcontroller->arf_label_top_position($frm_css['font_size'], $frm_css['field_font_size']);
			}

			$parent_field_id = $check_field['id'];

			$field_opt_arr = $arfieldhelper->arf_getfields_basic_options_section();

			$field_order_arf_accordion = isset($field_opt_arr[$check_field['type']]) ? $field_opt_arr[$check_field['type']] : '';
			
			foreach ($field_data_obj->field_data->$field_type as $key => $val) {
				$new_field_obj[$key] = (isset($check_field[$key]) && $check_field[$key] != '' ) ? $check_field[$key] : (isset($unserialize_field_optins[$key]) ? $unserialize_field_optins[$key] : '');
				if ($key == 'options') {
					$new_field_obj[$key] = $check_field[$key];
				}
				if ( isset( $_REQUEST['arfaction'] ) && $_REQUEST['arfaction'] != 'edit' ) {
					if ( $key == 'placeholdertext' ) {
						$new_field_obj[$key] = $placeholder_text;
					}
				}
			}

			$new_field_obj['default_value'] = isset($check_field['default_value']) ? $check_field['default_value'] : (isset($check_field['field_options']['default_value']) ? $check_field['field_options']['default_value'] : '');

			if (isset($new_field_obj['page_no']) && ($new_field_obj['page_no'] == '' || $new_field_obj['page_no'] < 1)) {
				$new_field_obj['page_no'] = 1;
			}

			if (isset($new_field_obj['locale'])) {
				$new_field_obj['locale'] = $new_field_obj['locale'] != "" ? $new_field_obj['locale'] : 'en';
			}
			$new_field_obj['image_position_from'] = ( isset($new_field_obj['image_position_from']) && $new_field_obj['image_position_from'] != '' ) ? $new_field_obj['image_position_from'] : 'top_left';

			$new_field_obj = $arformcontroller->arf_html_entity_decode($new_field_obj);

			$accordion_field_obj = $new_field_obj;

			$current_field_order = array();

			$arf_accordion_field  = '<div class="arfmainformfield edit_field_type_arf_accordion_wrapper top_container edit_form_item arffieldbox ui-state-default arf1columns" id="arf_accordion" data-field-id="'.$accordion_fid.'">';

				$arf_accordion_field .= '<div class="arf_fieldiconbox arf_accordion_fieldiconbox" data-field_id="'.$accordion_fid.'">';

					//$arf_accordion_field .= $positioned_field_icons['arf_accordion'];
					$arf_accordion_field .= $arfieldcontroller->arf_get_field_control_icons('duplicate', '', $check_field['id'], 0, $check_field['type'], $id);
					$arf_accordion_field .= $arfieldcontroller->arf_get_field_control_icons('delete', '', $check_field['id'], 0, $check_field['type'], $id);
					$arf_accordion_field .= $arfieldcontroller->arf_get_field_control_icons('options', '', $check_field['id'], 0, $check_field['type'], $id);
					$arf_accordion_field .= $arfieldcontroller->arf_get_field_control_icons('move', '', $check_field['id'], 0, $check_field['type'], $id);

				$arf_accordion_field .= '</div>';

				$arf_accordion_field .= "<input type='hidden' name='arf_field_data_{$accordion_fid}' id='arf_field_data_{$accordion_fid}' value='" . htmlspecialchars(json_encode($accordion_field_obj)) . "' data-field_options='" . json_encode($field_order_arf_accordion) . "' />";

				$total_accordions = $accordion_field_obj['total_accordions'];

				for( $ac = 1; $ac <= $total_accordions; $ac++ ){

					$accordion_title = !empty( $accordion_field_obj['accordion_labels'][ $ac ] ) ? $accordion_field_obj['accordion_labels'][ $ac ] : '';

					$arf_accordion_field .= '<div class="sortable_inner_wrapper edit_field_type_arf_accordion" id="arfmainfieldid_'.$accordion_fid.'" data-counter="'.$ac.'" inner_class="arf_1col" >';
	
						$arf_accordion_field .= '<div class="unsortable_inner_wrapper edit_field_type_accordion" id="arf_field_'.$accordion_fid.'">';
	
							$arf_accordion_field .= '<div class="fieldname-row" style="display:block;">';
	
								$arf_accordion_field .= '<div class="fieldname">';
	
										$arf_accordion_field .= '<label class="arf_main_label" id="field_'.$accordion_fid.'">';
	
											$arf_accordion_field .= '<span class="arfeditorfieldopt_accordion_label arf_edit_in_place arfeditorfieldopt_label">';
	
												$arf_accordion_field .= '<input type="text" class="arf_edit_in_place_input inplace_field" data-ajax="false" data-field-opt-change="true" data-field-opt-key="name" value="'.$accordion_title.'" data-field-id="'.$accordion_fid.'" />';
	
											$arf_accordion_field .= '</span>';
	
										$arf_accordion_field .= '</label>';
	
								$arf_accordion_field .= '</div>';

								$arf_accordion_field .= "<div class='arf_fieldiconbox arf_accordion_fieldiconbox field_icon_box_inner' data-field_id='{$accordion_fid}' data-counter='{$ac}'>";
									$arf_accordion_field .= $arfieldcontroller->arf_get_field_control_icons('inner_delete', '', $check_field['id'].'|'.$ac, 0, $check_field['type'], $id);
								$arf_accordion_field .= "</div>";
	
								$arf_accordion_field .= '<div class="arf_field_description" id="field_description_'.$accordion_fid.'"></div>';
	
							$arf_accordion_field .= '</div>';
	
						$arf_accordion_field .= '</div>';

						$cache_obj = wp_cache_get( 'arf_parent_field_data_'. $check_field['id'].'_'.$ac );
					
						if( isset( $_REQUEST['arfaction'] ) && $_REQUEST['arfaction'] == 'duplicate' ){
							if( false === $cache_obj )
							{
								$get_all_inner_fields = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".$MdlDb->fields."` WHERE form_id = %d AND ( (field_options LIKE '%\"parent_field\":\"%d\"%' OR field_options LIKE '%\"parent_field\":%d%') AND (field_options LIKE '%\"accordion_counter\":\"%d\"%' OR field_options LIKE '%\"accordion_counter\":%d%') ) ", $_REQUEST['id'], $check_field['id'], $check_field['id'], $ac, $ac ), ARRAY_A );
								wp_cache_set( 'arf_parent_field_data_'. $check_field['id'].'_'.$ac, $get_all_inner_fields );
							} else {
								$get_all_inner_fields = $cache_obj;
							}
						} else {
							if( false === $cache_obj )
							{
								$get_all_inner_fields = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `".$MdlDb->fields."` WHERE form_id = %d AND ( (field_options LIKE '%\"parent_field\":\"%d\"%' OR field_options LIKE '%\"parent_field\":%d%') AND (field_options LIKE '%\"accordion_counter\":\"%d\"%' OR field_options LIKE '%\"accordion_counter\":%d%') ) ", $id, $check_field['id'], $check_field['id'], $ac, $ac ), ARRAY_A );
								wp_cache_set( 'arf_parent_field_data_'. $check_field['id'].'_'.$ac, $get_all_inner_fields );
							} else {
								$get_all_inner_fields = $cache_obj;
							}
						}

						$class_array = array();
					
						$arf_field_counter = 1;

						$arf_inner_sorted_fields = array();					

						if( $inner_field_order != '' ){

							$inner_field_order = !is_array( $inner_field_order ) ? json_decode($inner_field_order, true) : $inner_field_order;

							/* echo "<pre>";
							print_r( $inner_field_order );
							echo "</pre>"; */
							
							if( isset( $inner_field_order[$check_field['id']][ $ac ]  ) ){
								
								foreach( $inner_field_order[$check_field['id']][$ac] as $k => $inner_order ){

									$exploded_data = explode('|', $inner_order);
									$temp_fid = $exploded_data[0];
									
									if( preg_match('/^(\d+)$/',$temp_fid) ){
										foreach( $get_all_inner_fields as $field ){
											if( $field['id'] == $temp_fid && !array_key_exists( (int)$temp_fid, $unsaved_inner_fields ) ){
												$arf_inner_sorted_fields[] = $field;
											}
										}
									} else {
										$arf_inner_sorted_fields[] = $temp_fid;
									}
								}
							}
						}

						

						if( is_array( $unsaved_inner_fields ) && !empty( $unsaved_inner_fields ) ){
							$arf_sorted_inner_unsave_fields = array();
							foreach ($inner_field_order[$check_field['id']][$ac] as $k => $inner_order) {
								if( is_array( $inner_order ) ){
									foreach( $inner_order as $in_order ){
										$exploded_data = explode('|', $in_order);
										$in_field_id = $exploded_data[0];
										foreach ($unsaved_inner_fields as $infid => $inner_field_data) {
											if ($in_field_id == $infid) {
												$arf_sorted_inner_unsave_fields[$infid] = $inner_field_data;
											}
										}
									}
								}
							}

							$unsaved_inner_fields = $arf_sorted_inner_unsave_fields;
							 

							$temp_inner_fields = array();
							foreach ($unsaved_inner_fields as $inner_key => $inner_value) {
								$inner_opts = json_decode($inner_value, true);
								if( isset( $inner_opts ) && $inner_opts['parent_field'] != $check_field['id'] ){
									continue;
								}
								foreach ($inner_opts as $ink => $inner_val) {
									if($ink == 'key'){
										$temp_inner_fields[$inner_key]['field_key'] = $inner_val;         
									} else if ($ink == 'options' || $ink == 'default_value') {
										$temp_inner_fields[$inner_key][$ink] = ($inner_val != '' ) ? json_encode($inner_val) : '';
									} else {
										$temp_inner_fields[$inner_key][$ink] = $inner_val;
									}
								}
								$temp_inner_fields[$inner_key]['field_options'] = $inner_value;
								$temp_inner_fields[$inner_key]['id'] = $inner_key;
							}

							$is_saved_field_key = $arformcontroller->arfSearchArray( $inner_key, 'id', $get_all_inner_fields );
							if( $is_saved_field_key > -1 ){
								$get_all_inner_fields[ $is_saved_field_key ] = $temp_inner_fields[ $inner_key ];
							} else {
								$get_all_inner_fields = array_merge($get_all_inner_fields, $temp_inner_fields);
							}
						}

						$get_all_inner_fields_new = array();

						$arf_inner_sorted_fields_new = array();
						
						$inner_class_arr = array();
						$arf_temp_sorted_fields = array();

						
						
						if( isset( $inner_field_order[ $accordion_fid ][ $ac ]  ) ){
							$inner_sorted_counter = 0;
							foreach( $inner_field_order[ $accordion_fid ][ $ac ] as $k => $inner_order ){

								$exploded_data = explode('|', $inner_order);
								$temp_fid = $exploded_data[0];
								
								if( preg_match('/^(\d+)$/',$temp_fid) ){
									foreach( $get_all_inner_fields as $field ){
										if( $field['id'] == $temp_fid && !array_key_exists( (int)$temp_fid, $unsaved_inner_fields ) ){
											$foptions = json_decode( $field['field_options'], true );
											$inner_class_arr[ $field['id'] ] = $foptions['inner_class'];
											$arf_temp_sorted_fields[ $inner_sorted_counter ] = !empty( $foptions['inner_class'] ) ? $foptions['inner_class'] : 'arf_1col';
											$arf_inner_sorted_fields_new[] = $field;
										}
									}
								} else {
									$prev_sorted_counter = $inner_sorted_counter - 1;
									$inner_class_arr[ $inner_order ] = $temp_fid;

									if( !empty( $arf_temp_sorted_fields[ $prev_sorted_counter ] ) ){
										$prev_inner_class = $arf_temp_sorted_fields[ $prev_sorted_counter ];
										
										if( $temp_fid == 'arf_2col' && !preg_match( '/(arf21colclass)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf_3col' && !preg_match( '/(arf_23col)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf_4col' && !preg_match( '/(arf43colclass)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf_5col' && !preg_match( '/(arf54colclass)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf_6col' && !preg_match( '/(arf65colclass)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf_23col' && !preg_match( '/(arf31colclass)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf42colclass' && !preg_match( '/(arf41colclass)/', $prev_inner_class ) ){
											continue;
										} else if( $temp_fid == 'arf43colclass' && !preg_match( '/(arf42colclass)/', $prev_inner_class ) ){
											continue;
										}
									}

									$arf_inner_sorted_fields_new[] = $temp_fid;
									$arf_temp_sorted_fields[ $inner_sorted_counter ] = $temp_fid;
								}
								$inner_sorted_counter++;
							}
						}
						
						
						if( !empty( $arf_inner_sorted_fields_new ) ){
							$get_all_inner_fields = $arf_inner_sorted_fields_new;
						}

						
						$field_classes = array();
						$inner_field_counter = 1;

						foreach( $get_all_inner_fields as $field_key => $field ){

							$inside_section_field = true;
							if( is_array( $field ) ){
								$field_name = "item_meta[" . $field['id'] . "]";
								$has_field_opt = false;
								if (isset($field['options']) && $field['options'] != '' && !empty($field['options'])) {
									$has_field_opt = true;
									$field_options_db = json_decode($field['options'], true);
								}
								
								$field_opt = json_decode($field['field_options'], true);
								
								$class = (isset($field_opt['inner_class']) && $field_opt['inner_class']) ? $field_opt['inner_class'] : 'arf_1col';
								$field_classes[] = $class;
								array_push($class_array,$class);

								if (isset($field_opt) && !empty($field_opt) && is_array($field_opt) ) {
									foreach ($field_opt as $k => $field_opt_val) {
										if ($k != 'options') {
											$field[$k] = $arformcontroller->arf_html_entity_decode($field_opt_val);
										} else {
											if ($has_field_opt == true && $k == 'options') {
												$field[$k] = $field_options_db;
											}
										}
									}
								}
								if (in_array($field['type'], $bootstraped_fields_array)) {
									array_push($fields_with_external_js, $field['type']);
								}
							} else {
								$field_classes[] = $field;
							}
							if( !empty( $field ) && is_array( $field ) && ( !isset( $field['form_id'] ) || empty( $field['form_id'] ) ) ){
								$field['form_id'] = $id;
							}

							if( isset( $remove_placeholders ) && true == $remove_placeholders && !empty( $field['placeholdertext'] ) ){
								$field['placeholdertext'] = '';
								if( !empty( $field_opt['placeholdertext'] ) ){
									$field_opt['placeholdertext'] = '';
									$field['field_options'] = json_encode( $field_opt );
								}
							}
							
							$filename = VIEWS_PATH . '/arf_field_editor.php';
							ob_start();
							include $filename;
							$arf_accordion_field .= ob_get_contents();
							ob_end_clean();
							$inner_field_counter++;
						}
						$index_repeater_fields += $index_arf_fields;
	
					$arf_accordion_field .= '</div>';
				}


				$arf_accordion_field .= '<div class="arf_accordion_add_cls">';
					$arf_accordion_field .='<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="16" cy="16" r="16" fill="#5385F1"/> <path d="M16 9V23" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M23 16.4117H9" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>';
				$arf_accordion_field .= '</div>';

				$arf_accordion_field .= '<div class="arf_field_option_model arf_field_option_model_cloned" data-field_id="'.$accordion_fid.'">';

					$arf_accordion_field .= '<div class="arf_field_option_model_header">'.addslashes(esc_html__('Field Options', 'ARForms')).'&nbsp;<span class="arf_pre_populated_field_type" id="{arf_field_type}">[Field Type : [arf_field_type]]</span>&nbsp;<span class="arf_pre_populated_field_id" id="{arf_field_id}">[Field ID:[arf_field_id]]</span></div>';
					$arf_accordion_field .= '<div class="arf_field_option_model_container">';
						$arf_accordion_field .= '<div class="arf_field_option_content_row">';
						$arf_accordion_field .= '</div>';
					$arf_accordion_field .= '</div>';
					$arf_accordion_field .= '<div class="arf_field_option_model_footer">';
						$arf_accordion_field .= '<button type="button" class="arf_field_option_close_button" onClick="arf_close_field_option_popup('.$check_field['id'].');">'.addslashes(esc_html__('Cancel', 'ARForms')).'</button>';
						$arf_accordion_field .= '<button type="button" class="arf_field_option_submit_button" data-field_id="'.$check_field['id'].'">'.esc_html__('OK', 'ARForms').'</button>';
					$arf_accordion_field .= '</div>';
				
				$arf_accordion_field .= '</div>';

			$arf_accordion_field .= '</div>';

			if( $return_html ){
				return $arf_accordion_field;
			} else {
				echo $arf_accordion_field;
			}
		}

	}

	function arf_field_delete_inner_box( $svg_icon, $type, $field_required_cls, $field_id, $field_required, $field_type, $form_id, $title_attr ){

		if( 'inner_delete' ){
			$counter = 1;
			if( preg_match( '/[\d+]\|[\d+]/', $field_id ) ){
				$field_ids_part = explode( '|', $field_id );
				$field_id = $field_ids_part[0];
				$counter = $field_ids_part[1];
			}
			$svg_icon = "<div class='arf_field_option_icon arf_field_action_iconbox' data-counter='{$counter}'><a title='".$title_attr."' data-title='".$title_attr."' class='arf_field_option_input arf_field_icon_tooltip' data-toggle='arfmodal' href='#delete_field_message_{$field_id}' id='arf_field_delete_{$field_id}' onClick=\"arfchangedeletemodalwidth('arfdeleteinnermodalbox', {$field_id}, {$counter});\"><svg id='delete' height='19' width='19'><g>".ARF_CUSTOM_DELETE_ICON."</g></svg></a></div>";
		}

		return $svg_icon;
	}

	function arf_modify_list_item_cls_for_accordion( $full_width_cls, $field_type ){

		if( 'arf_accordion' == $field_type ){
			$full_width_cls .= ' arf_accordion_field ';
		}

		return $full_width_cls;
	}

	function arf_add_new_attr_for_accordion_extras( $attrs, $field_type ){

		if( 'arf_accordion' == $field_type ){
			$attrs .= ' data-sub-type="accordion" ';
		}

		return $attrs;
	}

	function arf_replace_accordion_key_with_section( $field_key ){

		$field_key = ( 'arf_accordion' == $field_key ) ? 'section' : $field_key;

		return $field_key;
	}

	function arf_add_accordion_field_element_list( $fields ){

		$fields['arf_accordion'] = array(
			'icon' => '<svg width="26" height="25" viewBox="0 0 26 25" fill="none" xmlns="http://www.w3.org/2000/svg"><rect width="26" height="2" fill="#4E5462"/><rect y="22.1" width="26" height="2" fill="#4E5462"/><rect x="1" y="7" width="24" height="10" stroke="#4E5462" stroke-width="2"/></svg>',
			'label' => addslashes(esc_html__('Accordion', 'ARForms'))
		);

		return $fields;
	}

	function arf_display_field_accordion_in_form_editor( $display, $field ){

		if( isset( $field['type'] ) && 'arf_accordion' == $field['type'] ){
			$display = true;
		}

		return $display;
	}
 
    function arf_change_accordion_field_option_icon_data( $positioned_field_icons,$field_icons ){

		$positioned_field_icons['arf_accordion'] = str_replace('{arf_field_type}','arf_accordion',$field_icons['arf_field_duplicate_icon'])."{$field_icons['field_delete_icon']}".str_replace('{arf_field_type}','arf_accordion',$field_icons['field_option_icon'])."{$field_icons['arf_field_move_icon']}";

		$positioned_field_icons['arf_accordion_inner_field'] = "{$field_icons['field_delete_icon']}".str_replace('{arf_field_type}','arf_accordion',$field_icons['field_option_icon']);

		return $positioned_field_icons;

	}

	function arf_set_accordion_field_options( $fieldsbasicoptionsarr ){

		$fieldsbasicoptionsarr['arf_accordion'] = array(
			'icon' => 1,
			'active_icon' => 2,
			'icon_alignment' => 3,
		);

		return $fieldsbasicoptionsarr;
	}

	function arf_add_accordion_field_outside( $fields, $field_icons, $json_data, $positioned_field_icons ){
		
		global $arfieldhelper,$arfieldcontroller;

		$field_opt_arr = $arfieldhelper->arf_getfields_basic_options_section();

		$field_order_arf_accordion = isset( $field_opt_arr['arf_accordion'] ) ? $field_opt_arr['arf_accordion'] : '';

		$field_data_array = $json_data;

		$field_data_obj_arf_accordion = $field_data_array->field_data->arf_accordion;

		$arf_accordion_field  = '<div class="arfmainformfield edit_field_type_arf_accordion_wrapper top_container edit_form_item arffieldbox ui-state-default arf1columns" id="arf_accordion" data-field-id="{arf_field_id}">';

			$arf_accordion_field .= '<div class="arf_fieldiconbox arf_accordion_fieldiconbox" data-field_id="{arf_field_id}">';

				$arf_accordion_field .= $positioned_field_icons['arf_accordion'];

			$arf_accordion_field .= '</div>';

			$arf_accordion_field .= "<input type='hidden' name='arf_field_data_{arf_field_id}' id='arf_field_data_{arf_field_id}' value='" . htmlspecialchars(json_encode($field_data_obj_arf_accordion)) . "' data-field_options='" . json_encode($field_order_arf_accordion) . "' />";

			$arf_accordion_field .= '<div class="sortable_inner_wrapper edit_field_type_arf_accordion" id="arfmainfieldid_{arf_field_id}" data-counter="1" inner_class="arf_1col" >';

				$arf_accordion_field .= '<div class="unsortable_inner_wrapper edit_field_type_accordion" id="arf_field_{arf_field_id}">';

					$arf_accordion_field .= '<div class="fieldname-row" style="display:block;">';

						$arf_accordion_field .= '<div class="fieldname">';

								$arf_accordion_field .= '<label class="arf_main_label" id="field_{arf_field_id}">';

									$arf_accordion_field .= '<span class="arfeditorfieldopt_accordion_label arf_edit_in_place arfeditorfieldopt_label">';

										$arf_accordion_field .= '<input type="text" class="arf_edit_in_place_input inplace_field" data-ajax="false" data-field-opt-change="true" data-field-opt-key="name" value="Accordion Title 1" data-field-id="{arf_field_id}" />';

									$arf_accordion_field .= '</span>';

								$arf_accordion_field .= '</label>';

						$arf_accordion_field .= '</div>';

						$arf_accordion_field .= '<div class="arf_field_description" id="field_description_{arf_field_id}"></div>';

					$arf_accordion_field .= '</div>';

				$arf_accordion_field .= '</div>';
			$arf_accordion_field .= '</div>';

			$arf_accordion_field .= '<div class="arf_accordion_add_cls">';
				$arf_accordion_field .='<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="16" cy="16" r="16" fill="#5385F1"/> <path d="M16 9V23" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M23 16.4117H9" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>';
			$arf_accordion_field .= '</div>';

			$arf_accordion_field .= '<div class="arf_field_option_model arf_field_option_model_cloned" data-field_id="{arf_field_id}">';
                    
				$arf_accordion_field .= '<div class="arf_field_option_model_header">'.addslashes(esc_html__('Field Options', 'ARForms')).'&nbsp;<span class="arf_pre_populated_field_type" id="{arf_field_type}">[Field Type : [arf_field_type]]</span>&nbsp;<span class="arf_pre_populated_field_id" id="{arf_field_id}">[Field ID:[arf_field_id]]</span></div>';
					$arf_accordion_field .= '<div class="arf_field_option_model_container">';
						$arf_accordion_field .= '<div class="arf_field_option_content_row">';
						$arf_accordion_field .= '</div>';
					$arf_accordion_field .= '</div>';
					$arf_accordion_field .= '<div class="arf_field_option_model_footer">';
						$arf_accordion_field .= '<button type="button" class="arf_field_option_close_button" onClick="arf_close_field_option_popup({arf_field_id});">'.addslashes(esc_html__('Cancel', 'ARForms')).'</button>';
						$arf_accordion_field .= '<button type="button" class="arf_field_option_submit_button" data-field_id="{arf_field_id}">'.esc_html__('OK', 'ARForms').'</button>';
					$arf_accordion_field .= '</div>';
				$arf_accordion_field .= '</div>';
			
			$arf_accordion_field .= '</div>';

		$arf_accordion_field .= '</div>';


		$fields['arf_accordion'] = $arf_accordion_field;


		return $fields;


	}

	function arf_add_accordion_field_outside_legacy( $fields, $field_icons, $json_data, $positioned_field_icons ){
		
		global $arfieldhelper,$arfieldcontroller;

		$field_opt_arr = $arfieldhelper->arf_getfields_basic_options_section();

		$field_order_arf_accordion = isset( $field_opt_arr['arf_accordion'] ) ? $field_opt_arr['arf_accordion'] : '';

		$field_inner_order_arf_accordion = isset( $field_opt_arr['arf_inner_accordion'] ) ? $field_opt_arr['arf_inner_accordion'] : '';

		$field_data_array = $json_data;

		$field_data_obj_arf_accordion = $field_data_array->field_data->arf_accordion;
		
		$arf_accordion_field  = '<div class="arfmainformfield edit_field_type_arf_accordion_wrapper top_container edit_form_item arffieldbox ui-state-default arf1columns" id="arf_accordion">';

			$arf_accordion_field .= '<div class="arf_fieldiconbox arf_accordion_fieldiconbox" data-field_id="{arf_field_id}">';

				$arf_accordion_field .= $positioned_field_icons['arf_accordion'];

			$arf_accordion_field .= '</div>';

			$arf_accordion_field .= '<div class="sortable_inner_wrapper edit_field_type_arf_accordion" id="arfmainfieldid_{arf_field_id}" inner_class="arf_1col" >';

				$arf_accordion_field .= "<input type='hidden' name='arf_field_data_{arf_field_id}' id='arf_field_data_{arf_field_id}' value='" . htmlspecialchars(json_encode($field_data_obj_arf_accordion)) . "' data-field_options='" . json_encode($field_order_arf_accordion) . "' />";

				$arf_accordion_field .= '<div class="arf_field_option_model arf_field_option_model_cloned" data-field_id="{arf_field_id}">';
                    $arf_accordion_field .= '<div class="arf_field_option_model_header">'.addslashes(esc_html__('Field Options', 'ARForms')).'&nbsp;<span class="arf_pre_populated_field_type" id="{arf_field_type}">[Field Type : [arf_field_type]]</span>&nbsp;<span class="arf_pre_populated_field_id" id="{arf_field_id}">[Field ID:[arf_field_id]]</span></div>';
                    	$arf_accordion_field .= '<div class="arf_field_option_model_container">';
                        	$arf_accordion_field .= '<div class="arf_field_option_content_row">';
                        	$arf_accordion_field .= '</div>';
                    	$arf_accordion_field .= '</div>';
                    	$arf_accordion_field .= '<div class="arf_field_option_model_footer">';
                        	$arf_accordion_field .= '<button type="button" class="arf_field_option_close_button" onClick="arf_close_field_option_popup({arf_field_id});">'.addslashes(esc_html__('Cancel', 'ARForms')).'</button>';
                        	$arf_accordion_field .= '<button type="button" class="arf_field_option_submit_button" data-field_id="{arf_field_id}">'.esc_html__('OK', 'ARForms').'</button>';
                    	$arf_accordion_field .= '</div>';
                	$arf_accordion_field .= '</div>';


					/* inner field code start */
					$arf_accordion_field .= '<div class="arfmainformfield edit_field_type_arf_accordion_wrapper_inner top_container edit_form_item arffieldbox ui-state-default arf1columns" id="arf_accordion_inner_1">';
	
						$arf_accordion_field .= '<div class="unsortable_inner_wrapper edit_field_type_accordion" id="arf_field_{arf_field_id_1}">';
	
							$arf_accordion_field .= '<div class="fieldname-row" style="display:block;">';
	
								$arf_accordion_field .= '<div class="fieldname">';
	
										$arf_accordion_field .= '<label class="arf_main_label" id="field_{arf_field_id_1}">';
	
											$arf_accordion_field .= '<span class="arfeditorfieldopt_accordion_label arf_edit_in_place arfeditorfieldopt_label">';
	
												$arf_accordion_field .= '<input type="text" class="arf_edit_in_place_input inplace_field" data-ajax="false" data-field-opt-change="true" data-field-opt-key="name" value="Accordion 1" data-field-id="{arf_field_id_1}" />';
	
											$arf_accordion_field .= '</span>';
	
										$arf_accordion_field .= '</label>';
	
								$arf_accordion_field .= '</div>';
	
								$arf_accordion_field .= '<div class="arf_field_description" id="field_description_{arf_field_id_1}"></div>';
	
							$arf_accordion_field .= '</div>';
	
						$arf_accordion_field .= '</div>';
	
						$arf_accordion_field .= '<div class="arf_fieldiconbox arf_accordion_fieldiconbox_inner" data-field_id="{arf_field_id_1}">';
	
							$arf_accordion_field .= $positioned_field_icons['arf_accordion_inner_field'];
	
						$arf_accordion_field .= '</div>';
	
						$arf_accordion_field .= '<div class="sortable_inner_wrapper edit_field_type_arf_accordion" id="arfmainfieldid_inner_{arf_field_id_1}" inner_class="arf_1col" >';
	
							$arf_accordion_field .= "<input type='hidden' name='arf_field_data_{arf_field_id_1}' id='arf_field_data_{arf_field_id_1}' value='" . htmlspecialchars(json_encode($field_data_obj_arf_accordion)) . "' data-field_options='" . json_encode($field_inner_order_arf_accordion) . "' />";
	
							$arf_accordion_field .= '<div class="arf_field_option_model arf_inner_option_model_cloned arf_field_option_model_cloned_inner" data-field_id="{arf_field_id_1}">';
								
								$arf_accordion_field .= '<div class="arf_field_option_model_header">'.addslashes(esc_html__('Field Options', 'ARForms')).'&nbsp;<span class="arf_pre_populated_field_type" id="{arf_field_type_1}">[Field Type : [arf_field_type]]</span>&nbsp;<span class="arf_pre_populated_field_id" id="{arf_field_id_1}">[Field ID:[arf_field_id_1]]</span></div>';
									$arf_accordion_field .= '<div class="arf_field_option_model_container">';
										$arf_accordion_field .= '<div class="arf_field_option_content_row">';
										$arf_accordion_field .= '</div>';
									$arf_accordion_field .= '</div>';
									$arf_accordion_field .= '<div class="arf_field_option_model_footer">';
										$arf_accordion_field .= '<button type="button" class="arf_field_option_close_button" onClick="arf_close_field_option_popup({arf_field_id_1});">'.addslashes(esc_html__('Cancel', 'ARForms')).'</button>';
										$arf_accordion_field .= '<button type="button" class="arf_field_option_submit_button" data-field_id="{arf_field_id_1}">'.esc_html__('OK', 'ARForms').'</button>';
									$arf_accordion_field .= '</div>';
								$arf_accordion_field .= '</div>';
							
							$arf_accordion_field .= '</div>';
	
						$arf_accordion_field .= '</div>';
					
						$arf_accordion_field .= '<div class="arf_accordion_add_cls">';
							$arf_accordion_field .='<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="16" cy="16" r="16" fill="#5385F1"/> <path d="M16 9V23" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M23 16.4117H9" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>';
						$arf_accordion_field .= '</div>';
						
					$arf_accordion_field .='</div>';
					/* inner field code end */


				$arf_accordion_field .= '</div>';


				/* $arf_accordion_field .= "<input type='hidden' name='arf_field_data_{arf_field_id}' id='arf_field_data_{arf_field_id}' value='" . htmlspecialchars(json_encode($field_data_obj_arf_accordion)) . "' data-field_options='" . json_encode($field_order_arf_accordion) . "' />";

				$arf_accordion_field .= '<div class="arf_field_option_model arf_field_option_model_cloned" data-field_id="{arf_field_id}">';
                    $arf_accordion_field .= '<div class="arf_field_option_model_header">'.addslashes(esc_html__('Field Options', 'ARForms')).'&nbsp;<span class="arf_pre_populated_field_type" id="{arf_field_type}">[Field Type : [arf_field_type]]</span>&nbsp;<span class="arf_pre_populated_field_id" id="{arf_field_id}">[Field ID:[arf_field_id]]</span></div>';
                    	$arf_accordion_field .= '<div class="arf_field_option_model_container">';
                        	$arf_accordion_field .= '<div class="arf_field_option_content_row">';
                        	$arf_accordion_field .= '</div>';
                    	$arf_accordion_field .= '</div>';
                    	$arf_accordion_field .= '<div class="arf_field_option_model_footer">';
                        	$arf_accordion_field .= '<button type="button" class="arf_field_option_close_button" onClick="arf_close_field_option_popup({arf_field_id});">'.addslashes(esc_html__('Cancel', 'ARForms')).'</button>';
                        	$arf_accordion_field .= '<button type="button" class="arf_field_option_submit_button" data-field_id="{arf_field_id}">'.esc_html__('OK', 'ARForms').'</button>';
                    	$arf_accordion_field .= '</div>';
                	$arf_accordion_field .= '</div>';
				$arf_accordion_field .= '</div>'; */

			$arf_accordion_field .= '</div>';
			
		$arf_accordion_field .= '</div>';


		$fields['arf_accordion'] = $arf_accordion_field;


		return $fields;


	}

}