<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class ServiceOptions {
    /**
     * @param string $inboundRequestUrl A webhook request is made to the Inbound
     *                                  Request URL when a message is received by
     *                                  any phone number or shortcode associated to
     *                                  your Messaging Service.
     * @param string $inboundMethod The HTTP method used when making requests to
     *                              the Inbound Request URL.
     * @param string $fallbackUrl A request is made to the Fallback URL if an error
     *                            occurs with retrieving or executing the TwiML
     *                            from you Inbound Request URL.
     * @param string $fallbackMethod The HTTP method used when requesting the
     *                               Fallback URL.
     * @param string $statusCallback A webhook request is made to the Status
     *                               Callback to pass status updates about your
     *                               messages.
     * @param bool $stickySender Configuration to enable or disable Sticky Sender
     *                           on your Service Instance.
     * @param bool $mmsConverter Configuration to enable or disable MMS Converter
     *                           on your Service Instance.
     * @param bool $smartEncoding Configuration to enable or disable Smart Encoding.
     * @param string $scanMessageContent The scan_message_content
     * @param bool $fallbackToLongCode Configuration to enable or disable Fallback
     *                                 to Long Code.
     * @param bool $areaCodeGeomatch Configuration to enable or disable Area Code
     *                               Geomatch.
     * @param int $validityPeriod Configuration to set the validity period of all
     *                            messages sent from your Service, in seconds.
     * @param bool $synchronousValidation The synchronous_validation
     * @return CreateServiceOptions Options builder
     */
    public static function create($inboundRequestUrl = Values::NONE, $inboundMethod = Values::NONE, $fallbackUrl = Values::NONE, $fallbackMethod = Values::NONE, $statusCallback = Values::NONE, $stickySender = Values::NONE, $mmsConverter = Values::NONE, $smartEncoding = Values::NONE, $scanMessageContent = Values::NONE, $fallbackToLongCode = Values::NONE, $areaCodeGeomatch = Values::NONE, $validityPeriod = Values::NONE, $synchronousValidation = Values::NONE) {
        return new CreateServiceOptions($inboundRequestUrl, $inboundMethod, $fallbackUrl, $fallbackMethod, $statusCallback, $stickySender, $mmsConverter, $smartEncoding, $scanMessageContent, $fallbackToLongCode, $areaCodeGeomatch, $validityPeriod, $synchronousValidation);
    }

    /**
     * @param string $friendlyName The friendly_name
     * @param string $inboundRequestUrl The inbound_request_url
     * @param string $inboundMethod The inbound_method
     * @param string $fallbackUrl The fallback_url
     * @param string $fallbackMethod The fallback_method
     * @param string $statusCallback The status_callback
     * @param bool $stickySender The sticky_sender
     * @param bool $mmsConverter The mms_converter
     * @param bool $smartEncoding The smart_encoding
     * @param string $scanMessageContent The scan_message_content
     * @param bool $fallbackToLongCode The fallback_to_long_code
     * @param bool $areaCodeGeomatch The area_code_geomatch
     * @param int $validityPeriod The validity_period
     * @param bool $synchronousValidation The synchronous_validation
     * @return UpdateServiceOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $inboundRequestUrl = Values::NONE, $inboundMethod = Values::NONE, $fallbackUrl = Values::NONE, $fallbackMethod = Values::NONE, $statusCallback = Values::NONE, $stickySender = Values::NONE, $mmsConverter = Values::NONE, $smartEncoding = Values::NONE, $scanMessageContent = Values::NONE, $fallbackToLongCode = Values::NONE, $areaCodeGeomatch = Values::NONE, $validityPeriod = Values::NONE, $synchronousValidation = Values::NONE) {
        return new UpdateServiceOptions($friendlyName, $inboundRequestUrl, $inboundMethod, $fallbackUrl, $fallbackMethod, $statusCallback, $stickySender, $mmsConverter, $smartEncoding, $scanMessageContent, $fallbackToLongCode, $areaCodeGeomatch, $validityPeriod, $synchronousValidation);
    }
}

class CreateServiceOptions extends Options {
    /**
     * @param string $inboundRequestUrl A webhook request is made to the Inbound
     *                                  Request URL when a message is received by
     *                                  any phone number or shortcode associated to
     *                                  your Messaging Service.
     * @param string $inboundMethod The HTTP method used when making requests to
     *                              the Inbound Request URL.
     * @param string $fallbackUrl A request is made to the Fallback URL if an error
     *                            occurs with retrieving or executing the TwiML
     *                            from you Inbound Request URL.
     * @param string $fallbackMethod The HTTP method used when requesting the
     *                               Fallback URL.
     * @param string $statusCallback A webhook request is made to the Status
     *                               Callback to pass status updates about your
     *                               messages.
     * @param bool $stickySender Configuration to enable or disable Sticky Sender
     *                           on your Service Instance.
     * @param bool $mmsConverter Configuration to enable or disable MMS Converter
     *                           on your Service Instance.
     * @param bool $smartEncoding Configuration to enable or disable Smart Encoding.
     * @param string $scanMessageContent The scan_message_content
     * @param bool $fallbackToLongCode Configuration to enable or disable Fallback
     *                                 to Long Code.
     * @param bool $areaCodeGeomatch Configuration to enable or disable Area Code
     *                               Geomatch.
     * @param int $validityPeriod Configuration to set the validity period of all
     *                            messages sent from your Service, in seconds.
     * @param bool $synchronousValidation The synchronous_validation
     */
    public function __construct($inboundRequestUrl = Values::NONE, $inboundMethod = Values::NONE, $fallbackUrl = Values::NONE, $fallbackMethod = Values::NONE, $statusCallback = Values::NONE, $stickySender = Values::NONE, $mmsConverter = Values::NONE, $smartEncoding = Values::NONE, $scanMessageContent = Values::NONE, $fallbackToLongCode = Values::NONE, $areaCodeGeomatch = Values::NONE, $validityPeriod = Values::NONE, $synchronousValidation = Values::NONE) {
        $this->options['inboundRequestUrl'] = $inboundRequestUrl;
        $this->options['inboundMethod'] = $inboundMethod;
        $this->options['fallbackUrl'] = $fallbackUrl;
        $this->options['fallbackMethod'] = $fallbackMethod;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['stickySender'] = $stickySender;
        $this->options['mmsConverter'] = $mmsConverter;
        $this->options['smartEncoding'] = $smartEncoding;
        $this->options['scanMessageContent'] = $scanMessageContent;
        $this->options['fallbackToLongCode'] = $fallbackToLongCode;
        $this->options['areaCodeGeomatch'] = $areaCodeGeomatch;
        $this->options['validityPeriod'] = $validityPeriod;
        $this->options['synchronousValidation'] = $synchronousValidation;
    }

    /**
     * A [webhook request](https://www.twilio.com/docs/api/twiml/sms/twilio_request) is made to the Inbound Request URL when a message is received by any phone number or shortcode associated to your Messaging Service. Set to `null` to disable inbound messaging.
     *
     * @param string $inboundRequestUrl A webhook request is made to the Inbound
     *                                  Request URL when a message is received by
     *                                  any phone number or shortcode associated to
     *                                  your Messaging Service.
     * @return $this Fluent Builder
     */
    public function setInboundRequestUrl($inboundRequestUrl) {
        $this->options['inboundRequestUrl'] = $inboundRequestUrl;
        return $this;
    }

    /**
     * The HTTP method used when making requests to the Inbound Request URL. Either `GET` or `POST`. Default value is `POST`.
     *
     * @param string $inboundMethod The HTTP method used when making requests to
     *                              the Inbound Request URL.
     * @return $this Fluent Builder
     */
    public function setInboundMethod($inboundMethod) {
        $this->options['inboundMethod'] = $inboundMethod;
        return $this;
    }

    /**
     * A request is made to the Fallback URL if an error occurs with retrieving or executing the TwiML from you Inbound Request URL.
     *
     * @param string $fallbackUrl A request is made to the Fallback URL if an error
     *                            occurs with retrieving or executing the TwiML
     *                            from you Inbound Request URL.
     * @return $this Fluent Builder
     */
    public function setFallbackUrl($fallbackUrl) {
        $this->options['fallbackUrl'] = $fallbackUrl;
        return $this;
    }

    /**
     * The HTTP method used when requesting the Fallback URL. Either `GET` or `POST`. Default value is `POST`.
     *
     * @param string $fallbackMethod The HTTP method used when requesting the
     *                               Fallback URL.
     * @return $this Fluent Builder
     */
    public function setFallbackMethod($fallbackMethod) {
        $this->options['fallbackMethod'] = $fallbackMethod;
        return $this;
    }

    /**
     * A webhook request is made to the Status Callback to pass [status updates](https://www.twilio.com/docs/api/rest/message#sms-status-values) about your messages. These status updates let you know if your accepted message were successfully sent and delivered or if a [delivery related error](https://www.twilio.com/docs/api/rest/message#error-values) may have occurred.
     *
     * @param string $statusCallback A webhook request is made to the Status
     *                               Callback to pass status updates about your
     *                               messages.
     * @return $this Fluent Builder
     */
    public function setStatusCallback($statusCallback) {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * Configuration to enable or disable Sticky Sender on your Service Instance. Possible values are `true` and `false`. Default value is `true`.
     *
     * @param bool $stickySender Configuration to enable or disable Sticky Sender
     *                           on your Service Instance.
     * @return $this Fluent Builder
     */
    public function setStickySender($stickySender) {
        $this->options['stickySender'] = $stickySender;
        return $this;
    }

    /**
     * Configuration to enable or disable MMS Converter on your Service Instance. Possible values are `true` and `false`. Default value is `true`.
     *
     * @param bool $mmsConverter Configuration to enable or disable MMS Converter
     *                           on your Service Instance.
     * @return $this Fluent Builder
     */
    public function setMmsConverter($mmsConverter) {
        $this->options['mmsConverter'] = $mmsConverter;
        return $this;
    }

    /**
     * Configuration to enable or disable [Smart Encoding](https://www.twilio.com/docs/api/messaging/services-and-copilot#smart-encoding). Possible values are `true` and `false`. Default value is `true`.
     *
     * @param bool $smartEncoding Configuration to enable or disable Smart Encoding.
     * @return $this Fluent Builder
     */
    public function setSmartEncoding($smartEncoding) {
        $this->options['smartEncoding'] = $smartEncoding;
        return $this;
    }

    /**
     * The scan_message_content
     *
     * @param string $scanMessageContent The scan_message_content
     * @return $this Fluent Builder
     */
    public function setScanMessageContent($scanMessageContent) {
        $this->options['scanMessageContent'] = $scanMessageContent;
        return $this;
    }

    /**
     * Configuration to enable or disable [Fallback to Long Code](https://www.twilio.com/docs/api/messaging/services-and-copilot#fallback-to-long-code). Possible values are `true` and `false`. Default value is `false`.
     *
     * @param bool $fallbackToLongCode Configuration to enable or disable Fallback
     *                                 to Long Code.
     * @return $this Fluent Builder
     */
    public function setFallbackToLongCode($fallbackToLongCode) {
        $this->options['fallbackToLongCode'] = $fallbackToLongCode;
        return $this;
    }

    /**
     * Configuration to enable or disable [Area Code Geomatch](https://www.twilio.com/docs/api/messaging/services-and-copilot#area-code-geomatch). Possible values are `true` and `false`. Default value is `false`.
     *
     * @param bool $areaCodeGeomatch Configuration to enable or disable Area Code
     *                               Geomatch.
     * @return $this Fluent Builder
     */
    public function setAreaCodeGeomatch($areaCodeGeomatch) {
        $this->options['areaCodeGeomatch'] = $areaCodeGeomatch;
        return $this;
    }

    /**
     * Configuration to set the [validity period](https://www.twilio.com/docs/api/messaging/services-and-copilot#validity-period) of all messages sent from your Service, in seconds. Acceptable integers range from `1` to `14,400`.  Default value is `14,400`.
     *
     * @param int $validityPeriod Configuration to set the validity period of all
     *                            messages sent from your Service, in seconds.
     * @return $this Fluent Builder
     */
    public function setValidityPeriod($validityPeriod) {
        $this->options['validityPeriod'] = $validityPeriod;
        return $this;
    }

    /**
     * The synchronous_validation
     *
     * @param bool $synchronousValidation The synchronous_validation
     * @return $this Fluent Builder
     */
    public function setSynchronousValidation($synchronousValidation) {
        $this->options['synchronousValidation'] = $synchronousValidation;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Messaging.V1.CreateServiceOptions ' . implode(' ', $options) . ']';
    }
}

class UpdateServiceOptions extends Options {
    /**
     * @param string $friendlyName The friendly_name
     * @param string $inboundRequestUrl The inbound_request_url
     * @param string $inboundMethod The inbound_method
     * @param string $fallbackUrl The fallback_url
     * @param string $fallbackMethod The fallback_method
     * @param string $statusCallback The status_callback
     * @param bool $stickySender The sticky_sender
     * @param bool $mmsConverter The mms_converter
     * @param bool $smartEncoding The smart_encoding
     * @param string $scanMessageContent The scan_message_content
     * @param bool $fallbackToLongCode The fallback_to_long_code
     * @param bool $areaCodeGeomatch The area_code_geomatch
     * @param int $validityPeriod The validity_period
     * @param bool $synchronousValidation The synchronous_validation
     */
    public function __construct($friendlyName = Values::NONE, $inboundRequestUrl = Values::NONE, $inboundMethod = Values::NONE, $fallbackUrl = Values::NONE, $fallbackMethod = Values::NONE, $statusCallback = Values::NONE, $stickySender = Values::NONE, $mmsConverter = Values::NONE, $smartEncoding = Values::NONE, $scanMessageContent = Values::NONE, $fallbackToLongCode = Values::NONE, $areaCodeGeomatch = Values::NONE, $validityPeriod = Values::NONE, $synchronousValidation = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['inboundRequestUrl'] = $inboundRequestUrl;
        $this->options['inboundMethod'] = $inboundMethod;
        $this->options['fallbackUrl'] = $fallbackUrl;
        $this->options['fallbackMethod'] = $fallbackMethod;
        $this->options['statusCallback'] = $statusCallback;
        $this->options['stickySender'] = $stickySender;
        $this->options['mmsConverter'] = $mmsConverter;
        $this->options['smartEncoding'] = $smartEncoding;
        $this->options['scanMessageContent'] = $scanMessageContent;
        $this->options['fallbackToLongCode'] = $fallbackToLongCode;
        $this->options['areaCodeGeomatch'] = $areaCodeGeomatch;
        $this->options['validityPeriod'] = $validityPeriod;
        $this->options['synchronousValidation'] = $synchronousValidation;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The inbound_request_url
     *
     * @param string $inboundRequestUrl The inbound_request_url
     * @return $this Fluent Builder
     */
    public function setInboundRequestUrl($inboundRequestUrl) {
        $this->options['inboundRequestUrl'] = $inboundRequestUrl;
        return $this;
    }

    /**
     * The inbound_method
     *
     * @param string $inboundMethod The inbound_method
     * @return $this Fluent Builder
     */
    public function setInboundMethod($inboundMethod) {
        $this->options['inboundMethod'] = $inboundMethod;
        return $this;
    }

    /**
     * The fallback_url
     *
     * @param string $fallbackUrl The fallback_url
     * @return $this Fluent Builder
     */
    public function setFallbackUrl($fallbackUrl) {
        $this->options['fallbackUrl'] = $fallbackUrl;
        return $this;
    }

    /**
     * The fallback_method
     *
     * @param string $fallbackMethod The fallback_method
     * @return $this Fluent Builder
     */
    public function setFallbackMethod($fallbackMethod) {
        $this->options['fallbackMethod'] = $fallbackMethod;
        return $this;
    }

    /**
     * The status_callback
     *
     * @param string $statusCallback The status_callback
     * @return $this Fluent Builder
     */
    public function setStatusCallback($statusCallback) {
        $this->options['statusCallback'] = $statusCallback;
        return $this;
    }

    /**
     * The sticky_sender
     *
     * @param bool $stickySender The sticky_sender
     * @return $this Fluent Builder
     */
    public function setStickySender($stickySender) {
        $this->options['stickySender'] = $stickySender;
        return $this;
    }

    /**
     * The mms_converter
     *
     * @param bool $mmsConverter The mms_converter
     * @return $this Fluent Builder
     */
    public function setMmsConverter($mmsConverter) {
        $this->options['mmsConverter'] = $mmsConverter;
        return $this;
    }

    /**
     * The smart_encoding
     *
     * @param bool $smartEncoding The smart_encoding
     * @return $this Fluent Builder
     */
    public function setSmartEncoding($smartEncoding) {
        $this->options['smartEncoding'] = $smartEncoding;
        return $this;
    }

    /**
     * The scan_message_content
     *
     * @param string $scanMessageContent The scan_message_content
     * @return $this Fluent Builder
     */
    public function setScanMessageContent($scanMessageContent) {
        $this->options['scanMessageContent'] = $scanMessageContent;
        return $this;
    }

    /**
     * The fallback_to_long_code
     *
     * @param bool $fallbackToLongCode The fallback_to_long_code
     * @return $this Fluent Builder
     */
    public function setFallbackToLongCode($fallbackToLongCode) {
        $this->options['fallbackToLongCode'] = $fallbackToLongCode;
        return $this;
    }

    /**
     * The area_code_geomatch
     *
     * @param bool $areaCodeGeomatch The area_code_geomatch
     * @return $this Fluent Builder
     */
    public function setAreaCodeGeomatch($areaCodeGeomatch) {
        $this->options['areaCodeGeomatch'] = $areaCodeGeomatch;
        return $this;
    }

    /**
     * The validity_period
     *
     * @param int $validityPeriod The validity_period
     * @return $this Fluent Builder
     */
    public function setValidityPeriod($validityPeriod) {
        $this->options['validityPeriod'] = $validityPeriod;
        return $this;
    }

    /**
     * The synchronous_validation
     *
     * @param bool $synchronousValidation The synchronous_validation
     * @return $this Fluent Builder
     */
    public function setSynchronousValidation($synchronousValidation) {
        $this->options['synchronousValidation'] = $synchronousValidation;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Messaging.V1.UpdateServiceOptions ' . implode(' ', $options) . ']';
    }
}