<?php

/**
 * Registers a lightbox provider.
 *
 * @internal Currently internal; not ready for public usage.
 */
abstract class GravityView_Lightbox_Provider {

	public static $slug;

	public static $script_slug;

	public static $style_slug;

	/**
	 * Adds actions and that modify GravityView to use this lightbox provider
	 */
	public function add_hooks() {
		add_filter( 'gravityview_lightbox_script', array( $this, 'filter_lightbox_script' ), 1000 );
		add_filter( 'gravityview_lightbox_style', array( $this, 'filter_lightbox_style' ), 1000 );

		add_filter( 'gravityview/fields/fileupload/link_atts', array( $this, 'fileupload_link_atts' ), 10, 4 );
		add_filter( 'gravityview/get_link/allowed_atts', array( $this, 'allowed_atts' ) );

		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles' ) );

		add_action( 'gravityview/template/after', array( $this, 'print_scripts' ) );

		add_action( 'wp_footer', array( $this, 'output_footer' ) );
	}


	/**
	 * Prints scripts for lightbox after a View is rendered
	 *
	 * @since 2.10.1
	 *
	 * @param GV\Template_Context $gravityview
	 *
	 * @return void
	 */
	public function print_scripts( $gravityview ) {

		if ( ! self::is_active( $gravityview ) ) {
			return;
		}

		wp_print_scripts( static::$script_slug );
		wp_print_styles( static::$script_slug );
	}

	/**
	 * Returns whether the provider is active for this View
	 *
	 * @since 2.10.1
	 *
	 * @param GV\Template_Context $gravityview
	 *
	 * @return bool true: yes! false: no!
	 */
	protected static function is_active( $gravityview ) {

		$lightbox = $gravityview->view->settings->get( 'lightbox' );

		if ( ! $lightbox ) {
			return false;
		}

		$provider = gravityview()->plugin->settings->get( 'lightbox', GravityView_Lightbox::DEFAULT_PROVIDER );

		if ( static::$slug !== $provider ) {
			return false;
		}

		return true;
	}

	/**
	 * Removes actions that were added by {@see GravityView_Lightbox_Provider::add_hooks}
	 *
	 * @internal Do not call directly. Instead, use:
	 *
	 * <code>
	 * do_action( 'gravityview/lightbox/provider', 'slug' );
	 * </code>
	 */
	public function remove_hooks() {
		remove_filter( 'gravityview_lightbox_script', array( $this, 'filter_lightbox_script' ), 1000 );
		remove_filter( 'gravityview_lightbox_style', array( $this, 'filter_lightbox_style' ), 1000 );

		remove_filter( 'gravityview/fields/fileupload/link_atts', array( $this, 'fileupload_link_atts' ), 10 );
		remove_filter( 'gravityview/get_link/allowed_atts', array( $this, 'allowed_atts' ) );

		remove_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		remove_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles' ) );

		remove_action( 'wp_footer', array( $this, 'output_footer' ) );
	}

	/**
	 * Modifies the name of the stylesheet to be enqueued when loading thickbox
	 *
	 * @param string $script
	 *
	 * @return string
	 */
	public function filter_lightbox_script( $script = 'thickbox' ) {
		return static::$script_slug;
	}

	/**
	 * Modifies the name of the stylesheet to be enqueued when loading thickbox
	 *
	 * @param string $style
	 *
	 * @return string
	 */
	public function filter_lightbox_style( $style = 'thickbox' ) {
		return static::$style_slug;
	}

	/**
	 * Get default settings for the script
	 *
	 * @return array
	 */
	protected function default_settings() {
		return array();
	}

	/**
	 * Get the settings for the JavaScript, with filter applied
	 *
	 * @internal
	 *
	 * @return mixed|void
	 */
	protected function get_settings() {
		$settings = static::default_settings();

		return apply_filters( 'gravityview/lightbox/provider/' . static::$slug . '/settings', $settings );
	}

	/**
	 * Output raw HTML in the wp_footer()
	 *
	 * @internal
	 */
	public function output_footer() {}

	/**
	 * Enqueue scripts for the lightbox
	 *
	 * @internal
	 */
	public function enqueue_scripts() {}

	/**
	 * Enqueue styles for the lightbox
	 *
	 * @internal
	 */
	public function enqueue_styles() {}

	/**
	 * Modify the attributes allowed in an anchor tag generated by GravityView
	 *
	 * @internal
	 *
	 * @param array $atts Attributes allowed in an anchor <a> tag.
	 *
	 * @return array
	 */
	public function allowed_atts( $atts = array() ) {
		return $atts;
	}

	/**
	 * Modified File Upload field links to use lightbox
	 *
	 * @since 2.10.1 Added $insecure_file_path
	 * @internal
	 *
	 * @param array|string              $link_atts Array or attributes string.
	 * @param array                     $field_compat Current GravityView field.
	 * @param \GV\Template_Context|null $context The context.
	 * @param array                     $additional_details Array of additional details about the file. {
	 * @type string $file_path URL to file.
	 * @type string $insecure_file_path URL to insecure file.
	 * }
	 *
	 * @return mixed
	 */
	public function fileupload_link_atts( $link_atts, $field_compat = array(), $context = null, $additional_details = null ) {
		return $link_atts;
	}
}
