<?php
class HbCountries {

	public $countries;
	public $usa_states;
	public $canada_provinces;

	public function code_iso_alpha_2_to_3( $alpha_2 ) {
		$alpha_key_2_value_3 = array(
			'AD' => 'AND',
			'AE' => 'ARE',
			'AF' => 'AFG',
			'AG' => 'ATG',
			'AI' => 'AIA',
			'AL' => 'ALB',
			'AM' => 'ARM',
			'AO' => 'AGO',
			'AQ' => 'ATA',
			'AR' => 'ARG',
			'AS' => 'ASM',
			'AT' => 'AUT',
			'AU' => 'AUS',
			'AW' => 'ABW',
			'AX' => 'ALA',
			'AZ' => 'AZE',
			'BA' => 'BIH',
			'BB' => 'BRB',
			'BD' => 'BGD',
			'BE' => 'BEL',
			'BF' => 'BFA',
			'BG' => 'BGR',
			'BH' => 'BHR',
			'BI' => 'BDI',
			'BJ' => 'BEN',
			'BL' => 'BLM',
			'BM' => 'BMU',
			'BN' => 'BRN',
			'BO' => 'BOL',
			'BQ' => 'BES',
			'BR' => 'BRA',
			'BS' => 'BHS',
			'BT' => 'BTN',
			'BV' => 'BVT',
			'BW' => 'BWA',
			'BY' => 'BLR',
			'BZ' => 'BLZ',
			'CA' => 'CAN',
			'CC' => 'CCK',
			'CD' => 'COD',
			'CF' => 'CAF',
			'CG' => 'COG',
			'CH' => 'CHE',
			'CI' => 'CIV',
			'CK' => 'COK',
			'CL' => 'CHL',
			'CM' => 'CMR',
			'CN' => 'CHN',
			'CO' => 'COL',
			'CR' => 'CRI',
			'CU' => 'CUB',
			'CV' => 'CPV',
			'CW' => 'CUW',
			'CX' => 'CXR',
			'CY' => 'CYP',
			'CZ' => 'CZE',
			'DE' => 'DEU',
			'DJ' => 'DJI',
			'DK' => 'DNK',
			'DM' => 'DMA',
			'DO' => 'DOM',
			'DZ' => 'DZA',
			'EC' => 'ECU',
			'EE' => 'EST',
			'EG' => 'EGY',
			'EH' => 'ESH',
			'ER' => 'ERI',
			'ES' => 'ESP',
			'ET' => 'ETH',
			'FI' => 'FIN',
			'FJ' => 'FJI',
			'FK' => 'FLK',
			'FM' => 'FSM',
			'FO' => 'FRO',
			'FR' => 'FRA',
			'GA' => 'GAB',
			'GB' => 'GBR',
			'GD' => 'GRD',
			'GE' => 'GEO',
			'GF' => 'GUF',
			'GG' => 'GGY',
			'GH' => 'GHA',
			'GI' => 'GIB',
			'GL' => 'GRL',
			'GM' => 'GMB',
			'GN' => 'GIN',
			'GP' => 'GLP',
			'GQ' => 'GNQ',
			'GR' => 'GRC',
			'GS' => 'SGS',
			'GT' => 'GTM',
			'GU' => 'GUM',
			'GW' => 'GNB',
			'GY' => 'GUY',
			'HK' => 'HKG',
			'HM' => 'HMD',
			'HN' => 'HND',
			'HR' => 'HRV',
			'HT' => 'HTI',
			'HU' => 'HUN',
			'ID' => 'IDN',
			'IE' => 'IRL',
			'IL' => 'ISR',
			'IM' => 'IMN',
			'IN' => 'IND',
			'IO' => 'IOT',
			'IQ' => 'IRQ',
			'IR' => 'IRN',
			'IS' => 'ISL',
			'IT' => 'ITA',
			'JE' => 'JEY',
			'JM' => 'JAM',
			'JO' => 'JOR',
			'JP' => 'JPN',
			'KE' => 'KEN',
			'KG' => 'KGZ',
			'KH' => 'KHM',
			'KI' => 'KIR',
			'KM' => 'COM',
			'KN' => 'KNA',
			'KP' => 'PRK',
			'KR' => 'KOR',
			'KW' => 'KWT',
			'KY' => 'CYM',
			'KZ' => 'KAZ',
			'LA' => 'LAO',
			'LB' => 'LBN',
			'LC' => 'LCA',
			'LI' => 'LIE',
			'LK' => 'LKA',
			'LR' => 'LBR',
			'LS' => 'LSO',
			'LT' => 'LTU',
			'LU' => 'LUX',
			'LV' => 'LVA',
			'LY' => 'LBY',
			'MA' => 'MAR',
			'MC' => 'MCO',
			'MD' => 'MDA',
			'ME' => 'MNE',
			'MF' => 'MAF',
			'MG' => 'MDG',
			'MH' => 'MHL',
			'MK' => 'MKD',
			'ML' => 'MLI',
			'MM' => 'MMR',
			'MN' => 'MNG',
			'MO' => 'MAC',
			'MP' => 'MNP',
			'MQ' => 'MTQ',
			'MR' => 'MRT',
			'MS' => 'MSR',
			'MT' => 'MLT',
			'MU' => 'MUS',
			'MV' => 'MDV',
			'MW' => 'MWI',
			'MX' => 'MEX',
			'MY' => 'MYS',
			'MZ' => 'MOZ',
			'NA' => 'NAM',
			'NC' => 'NCL',
			'NE' => 'NER',
			'NF' => 'NFK',
			'NG' => 'NGA',
			'NI' => 'NIC',
			'NL' => 'NLD',
			'NO' => 'NOR',
			'NP' => 'NPL',
			'NR' => 'NRU',
			'NU' => 'NIU',
			'NZ' => 'NZL',
			'OM' => 'OMN',
			'PA' => 'PAN',
			'PE' => 'PER',
			'PF' => 'PYF',
			'PG' => 'PNG',
			'PH' => 'PHL',
			'PK' => 'PAK',
			'PL' => 'POL',
			'PM' => 'SPM',
			'PN' => 'PCN',
			'PR' => 'PRI',
			'PS' => 'PSE',
			'PT' => 'PRT',
			'PW' => 'PLW',
			'PY' => 'PRY',
			'QA' => 'QAT',
			'RE' => 'REU',
			'RO' => 'ROU',
			'RS' => 'SRB',
			'RU' => 'RUS',
			'RW' => 'RWA',
			'SA' => 'SAU',
			'SB' => 'SLB',
			'SC' => 'SYC',
			'SD' => 'SDN',
			'SE' => 'SWE',
			'SG' => 'SGP',
			'SH' => 'SHN',
			'SI' => 'SVN',
			'SJ' => 'SJM',
			'SK' => 'SVK',
			'SL' => 'SLE',
			'SM' => 'SMR',
			'SN' => 'SEN',
			'SO' => 'SOM',
			'SR' => 'SUR',
			'SS' => 'SSD',
			'ST' => 'STP',
			'SV' => 'SLV',
			'SX' => 'SXM',
			'SY' => 'SYR',
			'SZ' => 'SWZ',
			'TC' => 'TCA',
			'TD' => 'TCD',
			'TF' => 'ATF',
			'TG' => 'TGO',
			'TH' => 'THA',
			'TJ' => 'TJK',
			'TK' => 'TKL',
			'TL' => 'TLS',
			'TM' => 'TKM',
			'TN' => 'TUN',
			'TO' => 'TON',
			'TR' => 'TUR',
			'TT' => 'TTO',
			'TV' => 'TUV',
			'TW' => 'TWN',
			'TZ' => 'TZA',
			'UA' => 'UKR',
			'UG' => 'UGA',
			'UM' => 'UMI',
			'US' => 'USA',
			'UY' => 'URY',
			'UZ' => 'UZB',
			'VA' => 'VAT',
			'VC' => 'VCT',
			'VE' => 'VEN',
			'VG' => 'VGB',
			'VI' => 'VIR',
			'VN' => 'VNM',
			'VU' => 'VUT',
			'WF' => 'WLF',
			'WS' => 'WSM',
			'YE' => 'YEM',
			'YT' => 'MYT',
			'ZA' => 'ZAF',
			'ZM' => 'ZMB',
			'ZW' => 'ZWE',
		);
		return $alpha_key_2_value_3[ $alpha_2 ];
	}

	public function code_iso_alpha_2_to_3_numeric( $alpha_2 ) {
		$alpha_key_2_value_3_numeric = array(
			'AF' => '004',
			'AX' => '248',
			'AL' => '008',
			'DZ' => '012',
			'AS' => '016',
			'AD' => '020',
			'AO' => '024',
			'AI' => '660',
			'AQ' => '010',
			'AG' => '028',
			'AR' => '032',
			'AM' => '051',
			'AW' => '533',
			'AU' => '036',
			'AT' => '040',
			'AZ' => '031',
			'BS' => '044',
			'BH' => '048',
			'BD' => '050',
			'BB' => '052',
			'BY' => '112',
			'BE' => '056',
			'BZ' => '084',
			'BJ' => '204',
			'BM' => '060',
			'BT' => '064',
			'BO' => '068',
			'BQ' => '535',
			'BA' => '070',
			'BW' => '072',
			'BV' => '074',
			'BR' => '076',
			'IO' => '086',
			'BN' => '096',
			'BG' => '100',
			'BF' => '854',
			'BI' => '108',
			'CV' => '132',
			'KH' => '116',
			'CM' => '120',
			'CA' => '124',
			'KY' => '136',
			'CF' => '140',
			'TD' => '148',
			'CL' => '152',
			'CN' => '156',
			'CX' => '162',
			'CC' => '166',
			'CO' => '170',
			'KM' => '174',
			'CG' => '178',
			'CD' => '180',
			'CK' => '184',
			'CR' => '188',
			'CI' => '384',
			'HR' => '191',
			'CU' => '192',
			'CW' => '531',
			'CY' => '196',
			'CZ' => '203',
			'DK' => '208',
			'DJ' => '262',
			'DM' => '212',
			'DO' => '214',
			'EC' => '218',
			'EG' => '818',
			'SV' => '222',
			'GQ' => '226',
			'ER' => '232',
			'EE' => '233',
			'SZ' => '748',
			'ET' => '231',
			'FK' => '238',
			'FO' => '234',
			'FJ' => '242',
			'FI' => '246',
			'FR' => '250',
			'GF' => '254',
			'PF' => '258',
			'TF' => '260',
			'GA' => '266',
			'GM' => '270',
			'GE' => '268',
			'DE' => '276',
			'GH' => '288',
			'GI' => '292',
			'GR' => '300',
			'GL' => '304',
			'GD' => '308',
			'GP' => '312',
			'GU' => '316',
			'GT' => '320',
			'GG' => '831',
			'GN' => '324',
			'GW' => '624',
			'GY' => '328',
			'HT' => '332',
			'HM' => '334',
			'VA' => '336',
			'HN' => '340',
			'HK' => '344',
			'HU' => '348',
			'IS' => '352',
			'IN' => '356',
			'ID' => '360',
			'IR' => '364',
			'IQ' => '368',
			'IE' => '372',
			'IM' => '833',
			'IL' => '376',
			'IT' => '380',
			'JM' => '388',
			'JP' => '392',
			'JE' => '832',
			'JO' => '400',
			'KZ' => '398',
			'KE' => '404',
			'KI' => '296',
			'KP' => '408',
			'KR' => '410',
			'KW' => '414',
			'KG' => '417',
			'LA' => '418',
			'LV' => '428',
			'LB' => '422',
			'LS' => '426',
			'LR' => '430',
			'LY' => '434',
			'LI' => '438',
			'LT' => '440',
			'LU' => '442',
			'MO' => '446',
			'MG' => '450',
			'MW' => '454',
			'MY' => '458',
			'MV' => '462',
			'ML' => '466',
			'MT' => '470',
			'MH' => '584',
			'MQ' => '474',
			'MR' => '478',
			'MU' => '480',
			'YT' => '175',
			'MX' => '484',
			'FM' => '583',
			'MD' => '498',
			'MC' => '492',
			'MN' => '496',
			'ME' => '499',
			'MS' => '500',
			'MA' => '504',
			'MZ' => '508',
			'MM' => '104',
			'NA' => '516',
			'NR' => '520',
			'NP' => '524',
			'NL' => '528',
			'NC' => '540',
			'NZ' => '554',
			'NI' => '558',
			'NE' => '562',
			'NG' => '566',
			'NU' => '570',
			'NF' => '574',
			'MK' => '807',
			'MP' => '580',
			'NO' => '578',
			'OM' => '512',
			'PK' => '586',
			'PW' => '585',
			'PS' => '275',
			'PA' => '591',
			'PG' => '598',
			'PY' => '600',
			'PE' => '604',
			'PH' => '608',
			'PN' => '612',
			'PL' => '616',
			'PT' => '620',
			'PR' => '630',
			'QA' => '634',
			'RE' => '638',
			'RO' => '642',
			'RU' => '643',
			'RW' => '646',
			'BL' => '652',
			'SH' => '654',
			'KN' => '659',
			'LC' => '662',
			'MF' => '663',
			'PM' => '666',
			'VC' => '670',
			'WS' => '882',
			'SM' => '674',
			'ST' => '678',
			'SA' => '682',
			'SN' => '686',
			'RS' => '688',
			'SC' => '690',
			'SL' => '694',
			'SG' => '702',
			'SX' => '534',
			'SK' => '703',
			'SI' => '705',
			'SB' => '090',
			'SO' => '706',
			'ZA' => '710',
			'GS' => '239',
			'SS' => '728',
			'ES' => '724',
			'LK' => '144',
			'SD' => '729',
			'SR' => '740',
			'SJ' => '744',
			'SE' => '752',
			'CH' => '756',
			'SY' => '760',
			'TW' => '158',
			'TJ' => '762',
			'TZ' => '834',
			'TH' => '764',
			'TL' => '626',
			'TG' => '768',
			'TK' => '772',
			'TO' => '776',
			'TT' => '780',
			'TN' => '788',
			'TR' => '792',
			'TM' => '795',
			'TC' => '796',
			'TV' => '798',
			'UG' => '800',
			'UA' => '804',
			'AE' => '784',
			'GB' => '826',
			'US' => '840',
			'UM' => '581',
			'UY' => '858',
			'UZ' => '860',
			'VU' => '548',
			'VE' => '862',
			'VN' => '704',
			'VG' => '092',
			'VI' => '850',
			'WF' => '876',
			'EH' => '732',
			'YE' => '887',
			'ZM' => '894',
			'ZW' => '716',
		);
		return $alpha_key_2_value_3_numeric[ $alpha_2 ];
	}

	public function __construct() {
		$this->countries = array(
			'en' => array(
				'AF' => 'Afghanistan',
				'AX' => 'Aland Islands',
				'AL' => 'Albania',
				'DZ' => 'Algeria',
				'AS' => 'American Samoa',
				'AD' => 'Andorra',
				'AO' => 'Angola',
				'AI' => 'Anguilla',
				'AQ' => 'Antarctica',
				'AG' => 'Antigua And Barbuda',
				'AR' => 'Argentina',
				'AM' => 'Armenia',
				'AW' => 'Aruba',
				'AU' => 'Australia',
				'AT' => 'Austria',
				'AZ' => 'Azerbaijan',
				'BS' => 'Bahamas',
				'BH' => 'Bahrain',
				'BD' => 'Bangladesh',
				'BB' => 'Barbados',
				'BY' => 'Belarus',
				'BE' => 'Belgium',
				'BZ' => 'Belize',
				'BJ' => 'Benin',
				'BM' => 'Bermuda',
				'BT' => 'Bhutan',
				'BO' => 'Bolivia',
				'BQ' => 'Bonaire, Sint Eustatius and Saba',
				'BA' => 'Bosnia And Herzegovina',
				'BW' => 'Botswana',
				'BV' => 'Bouvet Island',
				'BR' => 'Brazil',
				'IO' => 'British Indian Ocean Territory',
				'BN' => 'Brunei Darussalam',
				'BG' => 'Bulgaria',
				'BF' => 'Burkina Faso',
				'BI' => 'Burundi',
				'CV' => 'Cabo Verde',
				'KH' => 'Cambodia',
				'CM' => 'Cameroon',
				'CA' => 'Canada',
				'KY' => 'Cayman Islands',
				'CF' => 'Central African Republic',
				'TD' => 'Chad',
				'CL' => 'Chile',
				'CN' => 'China',
				'CX' => 'Christmas Island',
				'CC' => 'Cocos (Keeling) Islands',
				'CO' => 'Colombia',
				'KM' => 'Comoros',
				'CG' => 'Congo',
				'CD' => 'Congo, Democratic Republic',
				'CK' => 'Cook Islands',
				'CR' => 'Costa Rica',
				'CI' => 'Côte D\'Ivoire',
				'HR' => 'Croatia',
				'CU' => 'Cuba',
				'CW' => 'Curaçao',
				'CY' => 'Cyprus',
				'CZ' => 'Czechia',
				'DK' => 'Denmark',
				'DJ' => 'Djibouti',
				'DM' => 'Dominica',
				'DO' => 'Dominican Republic',
				'EC' => 'Ecuador',
				'EG' => 'Egypt',
				'SV' => 'El Salvador',
				'GQ' => 'Equatorial Guinea',
				'ER' => 'Eritrea',
				'EE' => 'Estonia',
				'SZ' => 'Eswatini',
				'ET' => 'Ethiopia',
				'FK' => 'Falkland Islands (Malvinas)',
				'FO' => 'Faroe Islands',
				'FJ' => 'Fiji',
				'FI' => 'Finland',
				'FR' => 'France',
				'GF' => 'French Guiana',
				'PF' => 'French Polynesia',
				'TF' => 'French Southern Territories',
				'GA' => 'Gabon',
				'GM' => 'Gambia',
				'GE' => 'Georgia',
				'DE' => 'Germany',
				'GH' => 'Ghana',
				'GI' => 'Gibraltar',
				'GR' => 'Greece',
				'GL' => 'Greenland',
				'GD' => 'Grenada',
				'GP' => 'Guadeloupe',
				'GU' => 'Guam',
				'GT' => 'Guatemala',
				'GG' => 'Guernsey',
				'GN' => 'Guinea',
				'GW' => 'Guinea-Bissau',
				'GY' => 'Guyana',
				'HT' => 'Haiti',
				'HM' => 'Heard Island and Mcdonald Islands',
				'VA' => 'Holy See (Vatican City State)',
				'HN' => 'Honduras',
				'HK' => 'Hong Kong',
				'HU' => 'Hungary',
				'IS' => 'Iceland',
				'IN' => 'India',
				'ID' => 'Indonesia',
				'IR' => 'Iran, Islamic Republic Of',
				'IQ' => 'Iraq',
				'IE' => 'Ireland',
				'IM' => 'Isle Of Man',
				'IL' => 'Israel',
				'IT' => 'Italy',
				'JM' => 'Jamaica',
				'JP' => 'Japan',
				'JE' => 'Jersey',
				'JO' => 'Jordan',
				'KZ' => 'Kazakhstan',
				'KE' => 'Kenya',
				'KI' => 'Kiribati',
				'KP' => 'Korea (Democratic People\'s Republic of)',
				'KR' => 'Korea, Republic of',
				'KW' => 'Kuwait',
				'KG' => 'Kyrgyzstan',
				'LA' => 'Lao People\'s Democratic Republic',
				'LV' => 'Latvia',
				'LB' => 'Lebanon',
				'LS' => 'Lesotho',
				'LR' => 'Liberia',
				'LY' => 'Libya',
				'LI' => 'Liechtenstein',
				'LT' => 'Lithuania',
				'LU' => 'Luxembourg',
				'MO' => 'Macao',
				'MG' => 'Madagascar',
				'MW' => 'Malawi',
				'MY' => 'Malaysia',
				'MV' => 'Maldives',
				'ML' => 'Mali',
				'MT' => 'Malta',
				'MH' => 'Marshall Islands',
				'MQ' => 'Martinique',
				'MR' => 'Mauritania',
				'MU' => 'Mauritius',
				'YT' => 'Mayotte',
				'MX' => 'Mexico',
				'FM' => 'Micronesia, Federated States Of',
				'MD' => 'Moldova, Republic of',
				'MC' => 'Monaco',
				'MN' => 'Mongolia',
				'ME' => 'Montenegro',
				'MS' => 'Montserrat',
				'MA' => 'Morocco',
				'MZ' => 'Mozambique',
				'MM' => 'Myanmar',
				'NA' => 'Namibia',
				'NR' => 'Nauru',
				'NP' => 'Nepal',
				'NL' => 'Netherlands',
				'NC' => 'New Caledonia',
				'NZ' => 'New Zealand',
				'NI' => 'Nicaragua',
				'NE' => 'Niger',
				'NG' => 'Nigeria',
				'NU' => 'Niue',
				'NF' => 'Norfolk Island',
				'MK' => 'North Macedonia',
				'MP' => 'Northern Mariana Islands',
				'NO' => 'Norway',
				'OM' => 'Oman',
				'PK' => 'Pakistan',
				'PW' => 'Palau',
				'PS' => 'Palestine, State of',
				'PA' => 'Panama',
				'PG' => 'Papua New Guinea',
				'PY' => 'Paraguay',
				'PE' => 'Peru',
				'PH' => 'Philippines',
				'PN' => 'Pitcairn',
				'PL' => 'Poland',
				'PT' => 'Portugal',
				'PR' => 'Puerto Rico',
				'QA' => 'Qatar',
				'RE' => 'Réunion',
				'RO' => 'Romania',
				'RU' => 'Russian Federation',
				'RW' => 'Rwanda',
				'BL' => 'Saint Barthelemy',
				'SH' => 'Saint Helena',
				'KN' => 'Saint Kitts And Nevis',
				'LC' => 'Saint Lucia',
				'MF' => 'Saint Martin (French part)',
				'PM' => 'Saint Pierre And Miquelon',
				'VC' => 'Saint Vincent And the Grenadines',
				'WS' => 'Samoa',
				'SM' => 'San Marino',
				'ST' => 'Sao Tome And Principe',
				'SA' => 'Saudi Arabia',
				'SN' => 'Senegal',
				'RS' => 'Serbia',
				'SC' => 'Seychelles',
				'SL' => 'Sierra Leone',
				'SG' => 'Singapore',
				'SX' => 'Sint Maarten (Dutch part)',
				'SK' => 'Slovakia',
				'SI' => 'Slovenia',
				'SB' => 'Solomon Islands',
				'SO' => 'Somalia',
				'ZA' => 'South Africa',
				'GS' => 'South Georgia And Sandwich Islands',
				'SS' => 'South Sudan',
				'ES' => 'Spain',
				'LK' => 'Sri Lanka',
				'SD' => 'Sudan',
				'SR' => 'Suriname',
				'SJ' => 'Svalbard And Jan Mayen',
				'SE' => 'Sweden',
				'CH' => 'Switzerland',
				'SY' => 'Syrian Arab Republic',
				'TW' => 'Taiwan',
				'TJ' => 'Tajikistan',
				'TZ' => 'Tanzania',
				'TH' => 'Thailand',
				'TL' => 'Timor-Leste',
				'TG' => 'Togo',
				'TK' => 'Tokelau',
				'TO' => 'Tonga',
				'TT' => 'Trinidad And Tobago',
				'TN' => 'Tunisia',
				'TR' => 'Turkey',
				'TM' => 'Turkmenistan',
				'TC' => 'Turks And Caicos Islands',
				'TV' => 'Tuvalu',
				'UG' => 'Uganda',
				'UA' => 'Ukraine',
				'AE' => 'United Arab Emirates',
				'GB' => 'United Kingdom of Great Britain',
				'US' => 'United States of America',
				'UM' => 'United States Outlying Islands',
				'UY' => 'Uruguay',
				'UZ' => 'Uzbekistan',
				'VU' => 'Vanuatu',
				'VE' => 'Venezuela',
				'VN' => 'Viet Nam',
				'VG' => 'Virgin Islands, British',
				'VI' => 'Virgin Islands, U.S.',
				'WF' => 'Wallis And Futuna',
				'EH' => 'Western Sahara',
				'YE' => 'Yemen',
				'ZM' => 'Zambia',
				'ZW' => 'Zimbabwe',
			),

			'fr' => array(
				'AF' => 'Afghanistan',
				'ZA' => 'Afrique du Sud',
				'AX' => 'Åland, Îles',
				'AL' => 'Albanie',
				'DZ' => 'Algérie',
				'DE' => 'Allemagne',
				'AD' => 'Andorre',
				'AO' => 'Angola',
				'AI' => 'Anguilla',
				'AQ' => 'Antarctique',
				'AG' => 'Antigua-Et-Barbuda',
				'SA' => 'Arabie Saoudite',
				'AR' => 'Argentine',
				'AM' => 'Arménie',
				'AW' => 'Aruba',
				'AU' => 'Australie',
				'AT' => 'Autriche',
				'AZ' => 'Azerbaïdjan',
				'BS' => 'Bahamas',
				'BH' => 'Bahreïn',
				'BD' => 'Bangladesh',
				'BB' => 'Barbade',
				'BY' => 'Bélarus',
				'BE' => 'Belgique',
				'BZ' => 'Belize',
				'BJ' => 'Bénin',
				'BM' => 'Bermudes',
				'BT' => 'Bhoutan',
				'BO' => 'Bolivie',
				'BQ' => 'Bonaire, Saint-Eustache et Saba',
				'BA' => 'Bosnie-Herzégovine',
				'BW' => 'Botswana',
				'BV' => 'Bouvet, Île',
				'BR' => 'Brésil',
				'BN' => 'Brunei Darussalam',
				'BG' => 'Bulgarie',
				'BF' => 'Burkina Faso',
				'BI' => 'Burundi',
				'KY' => 'Caïmans, Îles',
				'KH' => 'Cambodge',
				'CM' => 'Cameroun',
				'CA' => 'Canada',
				'CV' => 'Cap-Vert',
				'CF' => 'République centrafricaine',
				'CL' => 'Chili',
				'CN' => 'Chine',
				'CX' => 'Christmas, Île',
				'CY' => 'Chypre',
				'CC' => 'Cocos (Keeling), Îles',
				'CO' => 'Colombie',
				'KM' => 'Comores',
				'CG' => 'Congo',
				'CD' => 'Congo, République démocratique du',
				'CK' => 'Cook, Îles',
				'KR' => 'Corée du Sud',
				'KP' => 'Corée du Nord',
				'CR' => 'Costa Rica',
				'CI' => 'Côte d\'Ivoire',
				'HR' => 'Croatie',
				'CU' => 'Cuba',
				'CW' => 'Curaçao',
				'DK' => 'Danemark',
				'DJ' => 'Djibouti',
				'DO' => 'République dominicaine',
				'DM' => 'Dominique',
				'EG' => 'Égypte',
				'SV' => 'El Salvador',
				'AE' => 'Émirats Arabes Unis',
				'EC' => 'Équateur',
				'ER' => 'Érythrée',
				'ES' => 'Espagne',
				'EE' => 'Estonie',
				'US' => 'États-Unis',
				'ET' => 'Éthiopie',
				'FK' => 'Malouines, Îles',
				'FO' => 'Féroé, Îles',
				'FJ' => 'Fidji',
				'FI' => 'Finlande',
				'FR' => 'France',
				'GA' => 'Gabon',
				'GM' => 'Gambie',
				'GE' => 'Géorgie',
				'GS' => 'Géorgie du Sud-et-les Îles Sandwich du Sud',
				'GH' => 'Ghana',
				'GI' => 'Gibraltar',
				'GR' => 'Grèce',
				'GD' => 'Grenade',
				'GL' => 'Groenland',
				'GP' => 'Guadeloupe',
				'GU' => 'Guam',
				'GT' => 'Guatemala',
				'GG' => 'Guernesey',
				'GN' => 'Guinée',
				'GW' => 'Guinée-Bissau',
				'GQ' => 'Guinée équatoriale',
				'GY' => 'Guyana',
				'GF' => 'Guyane française',
				'HT' => 'Haïti',
				'HM' => 'Heard-et-MacDonald, Îles',
				'HN' => 'Honduras',
				'HK' => 'Hong Kong',
				'HU' => 'Hongrie',
				'IM' => 'Île De Man',
				'UM' => 'Îles mineures éloignées des États-Unis',
				'VG' => 'Îles Vierges britanniques',
				'VI' => 'Îles Vierges des États-Unis',
				'IN' => 'Inde',
				'ID' => 'Indonésie',
				'IR' => 'Iran',
				'IQ' => 'Iraq',
				'IE' => 'Irlande',
				'IS' => 'Islande',
				'IL' => 'Israël',
				'IT' => 'Italie',
				'JM' => 'Jamaïque',
				'JP' => 'Japon',
				'JE' => 'Jersey',
				'JO' => 'Jordanie',
				'KZ' => 'Kazakhstan',
				'KE' => 'Kenya',
				'KG' => 'Kirghizistan',
				'KI' => 'Kiribati',
				'KW' => 'Koweït',
				'LA' => 'Laos',
				'LS' => 'Lesotho',
				'LV' => 'Lettonie',
				'LB' => 'Liban',
				'LR' => 'Libéria',
				'LY' => 'Libye',
				'LI' => 'Liechtenstein',
				'LT' => 'Lituanie',
				'LU' => 'Luxembourg',
				'MO' => 'Macao',
				'MK' => 'Macédoine',
				'MG' => 'Madagascar',
				'MY' => 'Malaisie',
				'MW' => 'Malawi',
				'MV' => 'Maldives',
				'ML' => 'Mali',
				'MT' => 'Malte',
				'MP' => 'Mariannes du Nord, Îles',
				'MA' => 'Maroc',
				'MH' => 'Marshall, Îles',
				'MQ' => 'Martinique',
				'MU' => 'Maurice',
				'MR' => 'Mauritanie',
				'YT' => 'Mayotte',
				'MX' => 'Mexique',
				'FM' => 'Micronésie, États fédérés de',
				'MD' => 'Moldavie',
				'MC' => 'Monaco',
				'MN' => 'Mongolie',
				'ME' => 'Monténégro',
				'MS' => 'Montserrat',
				'MZ' => 'Mozambique',
				'MM' => 'Myanmar',
				'NA' => 'Namibie',
				'NR' => 'Nauru',
				'NP' => 'Népal',
				'NI' => 'Nicaragua',
				'NE' => 'Niger',
				'NG' => 'Nigéria',
				'NU' => 'Niué',
				'NF' => 'Norfolk, Île',
				'NO' => 'Norvège',
				'NC' => 'Nouvelle-Calédonie',
				'NZ' => 'Nouvelle-Zélande',
				'IO' => 'Territoire britannique de l\'Océan Indien',
				'OM' => 'Oman',
				'UG' => 'Ouganda',
				'UZ' => 'Ouzbékistan',
				'PK' => 'Pakistan',
				'PW' => 'Palaos',
				'PS' => 'Palestine, État de',
				'PA' => 'Panama',
				'PG' => 'Papouasie-Nouvelle-Guinée',
				'PY' => 'Paraguay',
				'NL' => 'Pays-Bas',
				'PE' => 'Pérou',
				'PH' => 'Philippines',
				'PN' => 'Pitcairn',
				'PL' => 'Pologne',
				'PF' => 'Polynésie française',
				'PR' => 'Porto Rico',
				'PT' => 'Portugal',
				'QA' => 'Qatar',
				'RE' => 'Réunion',
				'RO' => 'Roumanie',
				'GB' => 'Royaume-Uni',
				'RU' => 'Russie',
				'RW' => 'Rwanda',
				'EH' => 'Sahara Occidental',
				'BL' => 'Saint-Barthélemy',
				'SH' => 'Sainte-Hélène',
				'LC' => 'Sainte-Lucie',
				'KN' => 'Saint-Kitts-Et-Nevis',
				'SM' => 'Saint-Marin',
				'MF' => 'Saint-Martin (partie française)',
				'SX' => 'Saint-Martin (partie néerlandaise)',
				'PM' => 'Saint-Pierre-Et-Miquelon',
				'VA' => 'Vatican',
				'VC' => 'Saint-Vincent-et-les Grenadines',
				'SB' => 'Salomon, Îles',
				'WS' => 'Samoa',
				'AS' => 'Samoa américaines',
				'ST' => 'Sao Tomé-et-Principe',
				'SN' => 'Sénégal',
				'RS' => 'Serbie',
				'SC' => 'Seychelles',
				'SL' => 'Sierra Leone',
				'SG' => 'Singapour',
				'SK' => 'Slovaquie',
				'SI' => 'Slovénie',
				'SO' => 'Somalie',
				'SD' => 'Soudan',
				'SS' => 'Soudan du Sud',
				'LK' => 'Sri Lanka',
				'SE' => 'Suède',
				'CH' => 'Suisse',
				'SR' => 'Suriname',
				'SJ' => 'Svalbard et Jan Mayen',
				'SZ' => 'Swaziland',
				'SY' => 'Syrie',
				'TJ' => 'Tadjikistan',
				'TW' => 'Taïwan',
				'TZ' => 'Tanzanie',
				'TD' => 'Tchad',
				'CZ' => 'République tchèque',
				'TF' => 'Terres australes et antarctiques françaises',
				'TH' => 'Thaïlande',
				'TL' => 'Timor-Leste',
				'TG' => 'Togo',
				'TK' => 'Tokelau',
				'TO' => 'Tonga',
				'TT' => 'Trinité-et-Tobago',
				'TN' => 'Tunisie',
				'TM' => 'Turkménistan',
				'TC' => 'Turks-et-Caïcos, Îles',
				'TR' => 'Turquie',
				'TV' => 'Tuvalu',
				'UA' => 'Ukraine',
				'UY' => 'Uruguay',
				'VU' => 'Vanuatu',
				'VE' => 'Venezuela',
				'VN' => 'Viêt Nam',
				'WF' => 'Wallis et Futuna',
				'YE' => 'Yémen',
				'ZM' => 'Zambie',
				'ZW' => 'Zimbabwe',
			),

			'es' => array(
				'AF' => 'Afganistán',
				'AL' => 'Albania',
				'DE' => 'Alemania',
				'AD' => 'Andorra',
				'AO' => 'Angola',
				'AI' => 'Anguila',
				'AQ' => 'Antártida',
				'AG' => 'Antigua y Barbuda',
				'SA' => 'Arabia Saudita',
				'DZ' => 'Argelia',
				'AR' => 'Argentina',
				'AM' => 'Armenia',
				'AW' => 'Aruba',
				'AU' => 'Australia',
				'AT' => 'Austria',
				'AZ' => 'Azerbaiyán',
				'BE' => 'Bélgica',
				'BS' => 'Bahamas',
				'BH' => 'Bahrein',
				'BD' => 'Bangladesh',
				'BB' => 'Barbados',
				'BZ' => 'Belice',
				'BJ' => 'Benín',
				'BT' => 'Bhután',
				'BY' => 'Bielorrusia',
				'MM' => 'Birmania',
				'BO' => 'Bolivia',
				'BQ' => 'Bonaire, San Eustaquio y Saba',
				'BA' => 'Bosnia y Herzegovina',
				'BW' => 'Botsuana',
				'BR' => 'Brasil',
				'BN' => 'Brunéi',
				'BG' => 'Bulgaria',
				'BF' => 'Burkina Faso',
				'BI' => 'Burundi',
				'CV' => 'Cabo Verde',
				'KH' => 'Camboya',
				'CM' => 'Camerún',
				'CA' => 'Canadá',
				'TD' => 'Chad',
				'CL' => 'Chile',
				'CN' => 'China',
				'CY' => 'Chipre',
				'VA' => 'Ciudad del Vaticano',
				'CO' => 'Colombia',
				'KM' => 'Comoras',
				'CG' => 'República del Congo',
				'CD' => 'República Democrática del Congo',
				'KP' => 'Corea del Norte',
				'KR' => 'Corea del Sur',
				'CI' => 'Costa de Marfil',
				'CR' => 'Costa Rica',
				'HR' => 'Croacia',
				'CU' => 'Cuba',
				'CW' => 'Curazao',
				'DK' => 'Dinamarca',
				'DM' => 'Dominica',
				'EC' => 'Ecuador',
				'EG' => 'Egipto',
				'SV' => 'El Salvador',
				'AE' => 'Emiratos Árabes Unidos',
				'ER' => 'Eritrea',
				'SK' => 'Eslovaquia',
				'SI' => 'Eslovenia',
				'ES' => 'España',
				'US' => 'Estados Unidos de América',
				'EE' => 'Estonia',
				'ET' => 'Etiopía',
				'PH' => 'Filipinas',
				'FI' => 'Finlandia',
				'FJ' => 'Fiyi',
				'FR' => 'Francia',
				'GA' => 'Gabón',
				'GM' => 'Gambia',
				'GE' => 'Georgia',
				'GH' => 'Ghana',
				'GI' => 'Gibraltar',
				'GD' => 'Granada',
				'GR' => 'Grecia',
				'GL' => 'Groenlandia',
				'GP' => 'Guadalupe',
				'GU' => 'Guam',
				'GT' => 'Guatemala',
				'GF' => 'Guayana Francesa',
				'GG' => 'Guernsey',
				'GN' => 'Guinea',
				'GQ' => 'Guinea Ecuatorial',
				'GW' => 'Guinea-Bissau',
				'GY' => 'Guyana',
				'HT' => 'Haití',
				'HN' => 'Honduras',
				'HK' => 'Hong kong',
				'HU' => 'Hungría',
				'IN' => 'India',
				'ID' => 'Indonesia',
				'IR' => 'Irán',
				'IQ' => 'Irak',
				'IE' => 'Irlanda',
				'BV' => 'Isla Bouvet',
				'IM' => 'Isla de Man',
				'CX' => 'Isla de Navidad',
				'NF' => 'Isla Norfolk',
				'IS' => 'Islandia',
				'BM' => 'Islas Bermudas',
				'KY' => 'Islas Caimán',
				'CC' => 'Islas Cocos (Keeling)',
				'CK' => 'Islas Cook',
				'AX' => 'Islas de Åland',
				'FO' => 'Islas Feroe',
				'GS' => 'Islas Georgias del Sur y Sandwich del Sur',
				'HM' => 'Islas Heard y McDonald',
				'MV' => 'Islas Maldivas',
				'FK' => 'Islas Malvinas',
				'MP' => 'Islas Marianas del Norte',
				'MH' => 'Islas Marshall',
				'PN' => 'Islas Pitcairn',
				'SB' => 'Islas Salomón',
				'TC' => 'Islas Turcas y Caicos',
				'UM' => 'Islas Ultramarinas Menores de Estados Unidos',
				'VG' => 'Islas Vírgenes Británicas',
				'VI' => 'Islas Vírgenes de los Estados Unidos',
				'IL' => 'Israel',
				'IT' => 'Italia',
				'JM' => 'Jamaica',
				'JP' => 'Japón',
				'JE' => 'Jersey',
				'JO' => 'Jordania',
				'KZ' => 'Kazajistán',
				'KE' => 'Kenia',
				'KG' => 'Kirguistán',
				'KI' => 'Kiribati',
				'KW' => 'Kuwait',
				'LB' => 'Líbano',
				'LA' => 'Laos',
				'LS' => 'Lesoto',
				'LV' => 'Letonia',
				'LR' => 'Liberia',
				'LY' => 'Libia',
				'LI' => 'Liechtenstein',
				'LT' => 'Lituania',
				'LU' => 'Luxemburgo',
				'MX' => 'México',
				'MC' => 'Mónaco',
				'MO' => 'Macao',
				'MK' => 'Macedônia',
				'MG' => 'Madagascar',
				'MY' => 'Malasia',
				'MW' => 'Malawi',
				'ML' => 'Mali',
				'MT' => 'Malta',
				'MA' => 'Marruecos',
				'MQ' => 'Martinica',
				'MU' => 'Mauricio',
				'MR' => 'Mauritania',
				'YT' => 'Mayotte',
				'FM' => 'Micronesia',
				'MD' => 'Moldavia',
				'MN' => 'Mongolia',
				'ME' => 'Montenegro',
				'MS' => 'Montserrat',
				'MZ' => 'Mozambique',
				'NA' => 'Namibia',
				'NR' => 'Nauru',
				'NP' => 'Nepal',
				'NI' => 'Nicaragua',
				'NE' => 'Niger',
				'NG' => 'Nigeria',
				'NU' => 'Niue',
				'NO' => 'Noruega',
				'NC' => 'Nueva Caledonia',
				'NZ' => 'Nueva Zelanda',
				'OM' => 'Omán',
				'NL' => 'Países Bajos',
				'PK' => 'Pakistán',
				'PW' => 'Palau',
				'PS' => 'Palestina',
				'PA' => 'Panamá',
				'PG' => 'Papúa Nueva Guinea',
				'PY' => 'Paraguay',
				'PE' => 'Perú',
				'PF' => 'Polinesia Francesa',
				'PL' => 'Polonia',
				'PT' => 'Portugal',
				'PR' => 'Puerto Rico',
				'QA' => 'Qatar',
				'GB' => 'Reino Unido',
				'CF' => 'República Centroafricana',
				'CZ' => 'República Checa',
				'DO' => 'República Dominicana',
				'SS' => 'República de Sudán del Sur',
				'RE' => 'Reunión',
				'RW' => 'Ruanda',
				'RO' => 'Rumanía',
				'RU' => 'Rusia',
				'EH' => 'Sahara Occidental',
				'WS' => 'Samoa',
				'AS' => 'Samoa Americana',
				'BL' => 'San Bartolomé',
				'KN' => 'San Cristóbal y Nieves',
				'SM' => 'San Marino',
				'MF' => 'San Martín (Francia)',
				'PM' => 'San Pedro y Miquelón',
				'VC' => 'San Vicente y las Granadinas',
				'SH' => 'Santa Elena',
				'LC' => 'Santa Lucía',
				'ST' => 'Santo Tomé y Príncipe',
				'SN' => 'Senegal',
				'RS' => 'Serbia',
				'SC' => 'Seychelles',
				'SL' => 'Sierra Leona',
				'SG' => 'Singapur',
				'SX' => 'Sint Maarten',
				'SY' => 'Siria',
				'SO' => 'Somalia',
				'LK' => 'Sri lanka',
				'ZA' => 'Sudáfrica',
				'SD' => 'Sudán',
				'SE' => 'Suecia',
				'CH' => 'Suiza',
				'SR' => 'Surinám',
				'SJ' => 'Svalbard y Jan Mayen',
				'SZ' => 'Swazilandia',
				'TJ' => 'Tayikistán',
				'TH' => 'Tailandia',
				'TW' => 'Taiwán',
				'TZ' => 'Tanzania',
				'IO' => 'Territorio Británico del Océano Índico',
				'TF' => 'Territorios Australes y Antárticas Franceses',
				'TL' => 'Timor Oriental',
				'TG' => 'Togo',
				'TK' => 'Tokelau',
				'TO' => 'Tonga',
				'TT' => 'Trinidad y Tobago',
				'TN' => 'Tunez',
				'TM' => 'Turkmenistán',
				'TR' => 'Turquía',
				'TV' => 'Tuvalu',
				'UA' => 'Ucrania',
				'UG' => 'Uganda',
				'UY' => 'Uruguay',
				'UZ' => 'Uzbekistán',
				'VU' => 'Vanuatu',
				'VE' => 'Venezuela',
				'VN' => 'Vietnam',
				'WF' => 'Wallis y Futuna',
				'YE' => 'Yemen',
				'DJ' => 'Yibuti',
				'ZM' => 'Zambia',
				'ZW' => 'Zimbabue',
			),

			'de' => array(
				'AF' => 'Afghanistan',
				'AX' => 'Aland',
				'AL' => 'Albanien',
				'DZ' => 'Algerien',
				'AS' => 'Samoa-Amerikanisch (US-Verwaltung)',
				'AD' => 'Andorra',
				'AO' => 'Angola',
				'AI' => 'Anguilla',
				'AQ' => 'Antarktis',
				'AG' => 'Antigua und Barbuda',
				'AR' => 'Argentinien',
				'AM' => 'Armenien',
				'AW' => 'Aruba',
				'AU' => 'Australien',
				'AT' => 'Österreich',
				'AZ' => 'Aserbeidschan',
				'BS' => 'Bahamas',
				'BH' => 'Bahrain',
				'BD' => 'Bangladesch',
				'BB' => 'Barbados',
				'BY' => 'Belarus (Weissrussland)',
				'BE' => 'Belgien',
				'BZ' => 'Belize',
				'BJ' => 'Benin',
				'BM' => 'Bermuda',
				'BT' => 'Bhutan',
				'BO' => 'Bolivien',
				'BQ' => 'Bonaire, St. Eustatius und Saba',
				'BA' => 'Bosnien und Herzegowina',
				'BW' => 'Botsuana',
				'BV' => 'Bouvetinsel',
				'BR' => 'Brasilien',
				'IO' => 'Brit.Terr.Im Indischen Ozean',
				'BN' => 'Brunei Darussalam',
				'BG' => 'Bulgarien',
				'BF' => 'Burkina Faso',
				'BI' => 'Burundi',
				'CV' => 'Kap Verde',
				'KH' => 'Kambodscha',
				'CM' => 'Kamerun',
				'CA' => 'Kanada',
				'KY' => 'Kaimaninseln',
				'CF' => 'Zentralafrikanische Republik',
				'TD' => 'Tschad',
				'CL' => 'Chile',
				'CN' => 'China',
				'CX' => 'Weihnachtsinsel (Austr.Verwaltung)',
				'CC' => 'Kokosinseln (Keeling)',
				'CO' => 'Kolumbien',
				'KM' => 'Komoren',
				'CG' => 'Kongo',
				'CD' => 'Kongo, Demokratische Republik',
				'CK' => 'Cook-Inseln Neuseel.Verwaltung',
				'CR' => 'Costa Rica',
				'CI' => 'Cote D\'Ivoire (Elfenbeinkueste)',
				'HR' => 'Kroatien',
				'CU' => 'Kuba',
				'CW' => 'Curaçao',
				'CY' => 'Zypern',
				'CZ' => 'Tschechien',
				'DK' => 'Dänemark',
				'DJ' => 'Dschibuti',
				'DM' => 'Dominica',
				'DO' => 'Dominikanische Republik',
				'EC' => 'Ecuador',
				'EG' => 'Ägypten',
				'SV' => 'El Salvador',
				'GQ' => 'Äquatorial Guinea',
				'ER' => 'Eritrea',
				'EE' => 'Estland',
				'SZ' => 'Eswatini',
				'ET' => 'Äthiopien',
				'FK' => 'Falklandinseln (Malvinen)',
				'FO' => 'Faeroeer Inseln Dän.Verwaltung',
				'FJ' => 'Fidschi',
				'FI' => 'Finnland',
				'FR' => 'Frankreich',
				'GF' => 'Französisch Guayana',
				'PF' => 'Französisch Polynesien',
				'TF' => 'Franz. Südgebiete',
				'GA' => 'Gabun',
				'GM' => 'Gambia',
				'GE' => 'Georgien',
				'DE' => 'Deutschland',
				'GH' => 'Ghana',
				'GI' => 'Gibraltar',
				'GR' => 'Griechenland',
				'GL' => 'Grönland (Dän.Verwaltung)',
				'GD' => 'Grenada',
				'GP' => 'Guadeloupe (Franz.Verwaltung)',
				'GU' => 'Guam (US-Verwaltung)',
				'GT' => 'Guatemala',
				'GG' => 'Guernsey Insel',
				'GN' => 'Guinea',
				'GW' => 'Guinea-Bissau',
				'GY' => 'Guyana',
				'HT' => 'Haiti',
				'HM' => 'Heard und Mc Donald Inseln (unter Austr.Verw.)',
				'VA' => 'Vatikan',
				'HN' => 'Honduras',
				'HK' => 'Hongkong',
				'HU' => 'Ungarn',
				'IS' => 'Island',
				'IN' => 'Indien',
				'ID' => 'Indonesien',
				'IR' => 'Iran',
				'IQ' => 'Irak',
				'IE' => 'Irland',
				'IM' => 'Man, Insel',
				'IL' => 'Israel',
				'IT' => 'Italien',
				'JM' => 'Jamaika',
				'JP' => 'Japan',
				'JE' => 'Jersey Insel',
				'JO' => 'Jordanien',
				'KZ' => 'Kasachstan',
				'KE' => 'Kenia',
				'KI' => 'Kiribati',
				'KP' => 'Korea, Demokratische Volksrepublik',
				'KR' => 'Korea, Republik',
				'KW' => 'Kuwait',
				'KG' => 'Kirgisistan',
				'LA' => 'Laos',
				'LV' => 'Lettland',
				'LB' => 'Libanon',
				'LS' => 'Lesotho',
				'LR' => 'Liberien',
				'LY' => 'Libysch-Arabische Dschamahirija',
				'LI' => 'Liechtenstein',
				'LT' => 'Litauen',
				'LU' => 'Luxemburg',
				'MO' => 'Macao',
				'MG' => 'Madagaskar',
				'MW' => 'Malawi',
				'MY' => 'Malaysia',
				'MV' => 'Malediven',
				'ML' => 'Mali',
				'MT' => 'Malta',
				'MH' => 'Marshall Inseln',
				'MQ' => 'Martinique Franz.Verwaltung',
				'MR' => 'Mauretanien',
				'MU' => 'Mauritius',
				'YT' => 'Mayotte',
				'MX' => 'Mexiko',
				'FM' => 'Mikronesien',
				'MD' => 'Moldau, Republik',
				'MC' => 'Monaco',
				'MN' => 'Mongolei',
				'ME' => 'Montenegro',
				'MS' => 'Montserrat (GB-Verwaltung)',
				'MA' => 'Marokko',
				'MZ' => 'Mosambik',
				'MM' => 'Myanmar',
				'NA' => 'Namibia',
				'NR' => 'Nauru',
				'NP' => 'Nepal',
				'NL' => 'Niederlande',
				'NC' => 'Neukaledonien',
				'NZ' => 'Neuseeland',
				'NI' => 'Nicaragua',
				'NE' => 'Niger',
				'NG' => 'Nigeria',
				'NU' => 'Niue (Neuseel.Verwaltung)',
				'NF' => 'Norfolkinsel',
				'MK' => 'Republik Nordmazedonien',
				'MP' => 'Marianen, Nördliche',
				'NO' => 'Norwegen',
				'OM' => 'Oman',
				'PK' => 'Pakistan',
				'PW' => 'Palau',
				'PS' => 'Palästina',
				'PA' => 'Panama',
				'PG' => 'Papua Neuguinea',
				'PY' => 'Paraguay',
				'PE' => 'Peru',
				'PH' => 'Philippinen',
				'PN' => 'Pitcairninsel',
				'PL' => 'Polen',
				'PT' => 'Portugal',
				'PR' => 'Puerto Rico (US-Verwaltung)',
				'QA' => 'Katar',
				'RE' => 'Reunion',
				'RO' => 'Rumänien',
				'RU' => 'Russische Föderation',
				'RW' => 'Ruanda',
				'BL' => 'Saint Barthélemy (Franz.Verwaltung)',
				'SH' => 'St.Helena',
				'KN' => 'St.Kitts und Nevis',
				'LC' => 'St.Lucia',
				'MF' => 'Saint Martin (Franz. Verwaltung)',
				'PM' => 'St.Pierre und Miquelon',
				'VC' => 'St. Vincent und die Grenadinen',
				'WS' => 'Samoa-West',
				'SM' => 'San Marino',
				'ST' => 'Sao Tome und Principe',
				'SA' => 'Saudi-Arabien',
				'SN' => 'Senegal',
				'RS' => 'Serbien (exkl. Kosovo)',
				'SC' => 'Seychellen',
				'SL' => 'Sierra Leone',
				'SG' => 'Singapur',
				'SX' => 'St. Martin',
				'SK' => 'Slowakei',
				'SI' => 'Slowenien',
				'SB' => 'Salomonen',
				'SO' => 'Somalia',
				'ZA' => 'Südafrika',
				'GS' => 'Südgeorgien und Süd-Sandwich-Insel',
				'SS' => 'Südsudan',
				'ES' => 'Spanien',
				'LK' => 'Sri Lanka',
				'SD' => 'Sudan',
				'SR' => 'Suriname',
				'SJ' => 'Spitzb. und Jan Mayen Insel (Norw.Verw.)',
				'SE' => 'Schweden',
				'CH' => 'Schweiz',
				'SY' => 'Syrien',
				'TW' => 'Taiwan',
				'TJ' => 'Tadschikistan',
				'TZ' => 'Tansania, Vereinigte Republik',
				'TH' => 'Thailand',
				'TL' => 'Timor-Leste',
				'TG' => 'Togo',
				'TK' => 'Tokelau (Neuseel.Verwaltung)',
				'TO' => 'Tonga',
				'TT' => 'Trinidad und Tobago',
				'TN' => 'Tunesien',
				'TR' => 'Türkei',
				'TM' => 'Turkmenistan',
				'TC' => 'Turks- und Caicosinseln',
				'TV' => 'Tuvalu',
				'UG' => 'Uganda',
				'UA' => 'Ukraine',
				'AE' => 'Vereinigte Arabische Emirate',
				'GB' => 'Großbritannien',
				'US' => 'USA - Vereinigte Staaten',
				'UM' => 'USA - Sonstige Kleine Inseln',
				'UY' => 'Uruguay',
				'UZ' => 'Usbekistan',
				'VU' => 'Vanuatu',
				'VE' => 'Venezuela',
				'VN' => 'Vietnam',
				'VG' => 'Jungfern-Inseln (Britisch)',
				'VI' => 'Jungfern-Inseln (USA)',
				'WF' => 'Wallis und Futuna',
				'EH' => 'Westsahara Eigenst.Staat',
				'YE' => 'Jemen',
				'ZM' => 'Sambia',
				'ZW' => 'Simbabwe',
			),
			'hu' => array(
				'AF' => 'Afganisztán',
				'AX' => 'Aland-szigetek',
				'AL' => 'Albánia',
				'DZ' => 'Algéria',
				'AS' => 'Amerikai Szamoa',
				'AD' => 'Andorra',
				'AO' => 'Angola',
				'AI' => 'Anguilla',
				'AQ' => 'Antarktisz',
				'AG' => 'Antigua és Barbuda',
				'AR' => 'Argentína',
				'AM' => 'Örményország',
				'AW' => 'Aruba',
				'AU' => 'Ausztrália',
				'AT' => 'Ausztria',
				'AZ' => 'Azerbajdzsán',
				'BS' => 'Bahamák',
				'BH' => 'Bahrein',
				'BD' => 'Bangladesh',
				'BB' => 'Barbados',
				'BY' => 'Fehéroroszország',
				'BE' => 'Belgium',
				'BZ' => 'Belize',
				'BJ' => 'Benin',
				'BM' => 'Bermuda',
				'BT' => 'Bhután',
				'BO' => 'Bolívia',
				'BQ' => 'Bonaire, Sint Eustatius és Saba',
				'BA' => 'Bosznia és Hercegovina',
				'BW' => 'Botswana',
				'BV' => 'Bouvet-sziget',
				'BR' => 'Brazília',
				'IO' => 'Brit Indiai-óceáni Terület',
				'BN' => 'Brunei Darussalam',
				'BG' => 'Bulgária',
				'BF' => 'Burkina Faso',
				'BI' => 'Burundi',
				'CV' => 'Cabo Verde',
				'KH' => 'Kambodzsa',
				'CM' => 'Kamerun',
				'CA' => 'Kanada',
				'KY' => 'Kajmán-szigetek',
				'CF' => 'Közép-afrikai Köztársaság',
				'TD' => 'Csád',
				'CL' => 'Chile',
				'CN' => 'Kína',
				'CX' => 'Karácsony-sziget',
				'CC' => 'Kókusz (Keeling)-szigetek',
				'CO' => 'Kolumbia',
				'KM' => 'Comore-szigetek',
				'CG' => 'Kongó',
				'CD' => 'Kongó, Demokratikus Köztársaság',
				'CK' => 'Cook-szigetek',
				'CR' => 'Costa Rica',
				'CI' => 'Elefántcsontpart',
				'HR' => 'Horvátország',
				'CU' => 'Kuba',
				'CW' => 'Curaçao',
				'CY' => 'Ciprus',
				'CZ' => 'Csehország',
				'DK' => 'Dánia',
				'DJ' => 'Djibouti',
				'DM' => 'Dominika',
				'DO' => 'Dominikai Köztársaság',
				'EC' => 'Ecuador',
				'EG' => 'Egyiptom',
				'SV' => 'El Salvador',
				'GQ' => 'Egyenlítői-Guinea',
				'ER' => 'Eritrea',
				'EE' => 'Észtország',
				'SZ' => 'Eswatini',
				'ET' => 'Etiópia',
				'FK' => 'Falkland-szigetek (Malvinas)',
				'FO' => 'Feröer-szigetek',
				'FJ' => 'Fidzsi-szigetek',
				'FI' => 'Finnország',
				'FR' => 'Franciaország',
				'GF' => 'Francia Guyana',
				'PF' => 'Francia Polinézia',
				'TF' => 'Francia déli területek',
				'GA' => 'Gabon',
				'GM' => 'Gambia',
				'GE' => 'Georgia',
				'DE' => 'Németország',
				'GH' => 'Ghána',
				'GI' => 'Gibraltár',
				'GR' => 'Görögország',
				'GL' => 'Grönland',
				'GD' => 'Grenada',
				'GP' => 'Guadeloupe',
				'GU' => 'Guam',
				'GT' => 'Guatemala',
				'GG' => 'Guernsey',
				'GN' => 'Guinea',
				'GW' => 'Bissau-Guinea',
				'GY' => 'Guyana',
				'HT' => 'Haiti',
				'HM' => 'Heard-sziget és Mcdonald-szigetek',
				'VA' => 'Szentszék (Vatikánvárosi Állam)',
				'HN' => 'Honduras',
				'HK' => 'Hong Kong',
				'HU' => 'Magyarország',
				'IS' => 'Izland',
				'IN' => 'India',
				'ID' => 'Indonézia',
				'IR' => 'Iran, Islamic Republic Of',
				'IQ' => 'Irak',
				'IE' => 'Írország',
				'IM' => 'Isle Of Man',
				'IL' => 'Izrael',
				'IT' => 'Olaszország',
				'JM' => 'Jamaica',
				'JP' => 'Japán',
				'JE' => 'Mez',
				'JO' => 'Jordánia',
				'KZ' => 'Kazahsztán',
				'KE' => 'Kenya',
				'KI' => 'Kiribati',
				'KP' => 'Korea (Népi Demokratikus Köztársaság)',
				'KR' => 'Korea, Köztársaság',
				'KW' => 'Kuwait',
				'KG' => 'Kirgizisztán',
				'LA' => 'Laoszi Népi Demokratikus Köztársaság',
				'LV' => 'Lettország',
				'LB' => 'Libanon',
				'LS' => 'Lesotho',
				'LR' => 'Libéria',
				'LY' => 'Líbia',
				'LI' => 'Liechtenstein',
				'LT' => 'Litvánia',
				'LU' => 'Luxemburg',
				'MO' => 'Makaó',
				'MG' => 'Madagaszkár',
				'MW' => 'Malawi',
				'MY' => 'Malajzia',
				'MV' => 'Maldív-szigetek',
				'ML' => 'Mali',
				'MT' => 'Málta',
				'MH' => 'Marshall-szigetek',
				'MQ' => 'Martinique',
				'MR' => 'Mauritania',
				'MU' => 'Mauritius',
				'YT' => 'Mayotte',
				'MX' => 'Mexikó',
				'FM' => 'Mikronézia, Szövetségi Államok',
				'MD' => 'Moldova, Köztársaság',
				'MC' => 'Monaco',
				'MN' => 'Mongólia',
				'ME' => 'Montenegró',
				'MS' => 'Montserrat',
				'MA' => 'Marokkó',
				'MZ' => 'Mozambik',
				'MM' => 'Mianmar',
				'NA' => 'Namíbia',
				'NR' => 'Nauru',
				'NP' => 'Nepál',
				'NL' => 'Hollandia',
				'NC' => 'Új-Kaledónia',
				'NZ' => 'Új-Zéland',
				'NI' => 'Nicaragua',
				'NE' => 'Niger',
				'NG' => 'Nigéria',
				'NU' => 'Niue',
				'NF' => 'Norfolk-sziget',
				'MK' => 'Észak-Macedónia',
				'MP' => 'Északi Mariana-szigetek',
				'NO' => 'Norvégia',
				'OM' => 'Omán',
				'PK' => 'Pakisztán',
				'PW' => 'Palau',
				'PS' => 'Palesztina, Állam',
				'PA' => 'Panama',
				'PG' => 'Pápua Új-Guinea',
				'PY' => 'Paraguay',
				'PE' => 'Peru',
				'PH' => 'Fülöp-szigetek',
				'PN' => 'Pitcairn',
				'PL' => 'Lengyelország',
				'PT' => 'Portugália',
				'PR' => 'Puerto Rico',
				'QA' => 'Katar',
				'RE' => 'Réunion',
				'RO' => 'Románia',
				'RU' => 'Orosz Föderáció',
				'RW' => 'Ruanda',
				'BL' => 'Saint Barthelemy',
				'SH' => 'Szent Helena',
				'KN' => 'Saint Kitts és Nevis',
				'LC' => 'Szent Lucia',
				'MF' => 'Szent Márton (francia rész)',
				'PM' => 'Saint Pierre és Miquelon',
				'VC' => 'Saint Vincent és a Grenadine-szigetek',
				'WS' => 'Szamoa',
				'SM' => 'San Marino',
				'ST' => 'Sao Tome és Principe',
				'SA' => 'Szaúd-Arábia',
				'SN' => 'Szenegál',
				'RS' => 'Szerbia',
				'SC' => 'Seychelle-szigetek',
				'SL' => 'Sierra Leone',
				'SG' => 'Szingapúr',
				'SX' => 'Sint Maarten (holland rész)',
				'SK' => 'Szlovákia',
				'SI' => 'Szlovénia',
				'SB' => 'Salamon-szigetek',
				'SO' => 'Somalia',
				'ZA' => 'Dél-Afrika',
				'GS' => 'South Georgia and Sandwich Islands',
				'SS' => 'Dél-Szudán',
				'ES' => 'Spanyolország',
				'LK' => 'Sri Lanka',
				'SD' => 'Szudán',
				'SR' => 'Suriname',
				'SJ' => 'Svalbard és Jan Mayen',
				'SE' => 'Svédország',
				'CH' => 'Svájc',
				'SY' => 'Szíriai Arab Köztársaság',
				'TW' => 'Tajvan',
				'TJ' => 'Tadzsikisztán',
				'TZ' => 'Tanzánia',
				'TH' => 'Thaiföld',
				'TL' => 'Timor-Kelet',
				'TG' => 'Togo',
				'TK' => 'Tokelau',
				'TO' => 'Tonga',
				'TT' => 'Trinidad és Tobago',
				'TN' => 'Tunézia',
				'TR' => 'Törökország',
				'TM' => 'Türkmenisztán',
				'TC' => 'Turks- és Caicos-szigetek',
				'TV' => 'Tuvalu',
				'UG' => 'Uganda',
				'UA' => 'Ukrajna',
				'AE' => 'Egyesült Arab Emírségek',
				'GB' => 'Nagy-Britannia Egyesült Királysága',
				'US' => 'Amerikai Egyesült Államok',
				'UM' => 'Amerikai Egyesült Államok külterületi szigetei',
				'UY' => 'Uruguay',
				'UZ' => 'Üzbegisztán',
				'VU' => 'Vanuatu',
				'VE' => 'Venezuela',
				'VN' => 'Vietnam',
				'VG' => 'Szűz-szigetek, brit',
				'VI' => 'Virgin Islands, U.S.',
				'WF' => 'Wallis és Futuna',
				'EH' => 'Nyugat-Szahara',
				'YE' => 'Jemen',
				'ZM' => 'Zambia',
				'ZW' => 'Zimbabwe',
			),
		);

		$this->usa_states = array(
			'US-AK' => 'Alaska',
			'US-AL' => 'Alabama',
			'US-AZ' => 'Arizona',
			'US-AR' => 'Arkansas',
			'US-CA' => 'California',
			'US-CO' => 'Colorado',
			'US-CT' => 'Connecticut',
			'US-DE' => 'Delaware',
			'US-FL' => 'Florida',
			'US-GA' => 'Georgia',
			'US-HI' => 'Hawaii',
			'US-ID' => 'Idaho',
			'US-IL' => 'Illinois',
			'US-IN' => 'Indiana',
			'US-IA' => 'Iowa',
			'US-KS' => 'Kansas',
			'US-KY' => 'Kentucky',
			'US-LA' => 'Louisiana',
			'US-ME' => 'Maine',
			'US-MD' => 'Maryland',
			'US-MA' => 'Massachusetts',
			'US-MI' => 'Michigan',
			'US-MN' => 'Minnesota',
			'US-MS' => 'Mississippi',
			'US-MO' => 'Missouri',
			'US-MT' => 'Montana',
			'US-NE' => 'Nebraska',
			'US-NV' => 'Nevada',
			'US-NH' => 'New Hampshire',
			'US-NJ' => 'New Jersey',
			'US-NM' => 'New Mexico',
			'US-NY' => 'New York',
			'US-NC' => 'North Carolina',
			'US-ND' => 'North Dakota',
			'US-OH' => 'Ohio',
			'US-OK' => 'Oklahoma',
			'US-OR' => 'Oregon',
			'US-PA' => 'Pennsylvania',
			'US-RI' => 'Rhode Island',
			'US-SC' => 'South Carolina',
			'US-SD' => 'South Dakota',
			'US-TN' => 'Tennessee',
			'US-TX' => 'Texas',
			'US-UT' => 'Utah',
			'US-VT' => 'Vermont',
			'US-VA' => 'Virginia',
			'US-WA' => 'Washington',
			'US-WV' => 'West Virginia',
			'US-WI' => 'Wisconsin',
			'US-WY' => 'Wyoming'
		);

		$this->canada_provinces = array(
			'CA-AB' => 'Alberta',
			'CA-BC' => 'British Columbia',
			'CA-MB' => 'Manitoba',
			'CA-NB' => 'New Brunswick',
			'CA-NL' => 'Newfoundland and Labrador',
			'CA-NT' => 'Northwest Territories',
			'CA-NS' => 'Nova Scotia',
			'CA-NU' => 'Nunavut',
			'CA-ON' => 'Ontario',
			'CA-PE' => 'Prince Edward Island',
			'CA-QC' => 'Quebec',
			'CA-SK' => 'Saskatchewan',
			'CA-YT' => 'Yukon Territory'
		);
	}

	public function get_customer_country_name( $customer, $locale = '' ) {
		$country_name = '';
		if ( ! $locale ) {
			$locale = get_locale();
		}
		$locale_alpha_2 = $this->get_known_locale_alpha_2( $locale );
		if ( isset( $this->countries[ $locale_alpha_2 ][ $customer['country_iso'] ] ) ) {
			$country_name = $this->countries[ $locale_alpha_2 ][ $customer['country_iso'] ];
			if ( $customer['country_iso'] == 'US' ) {
				$country_name .= ' (' . $this->usa_states[ $customer['usa_state_iso'] ] . ')';
			} else if ( $customer['country_iso'] == 'CA' ) {
				$country_name .= ' (' . $this->canada_provinces[ $customer['canada_province_iso'] ] . ')';
			}
		}
		return $country_name;
	}

	public function get_list_admin_side() {
		return $this->get_list( true );
	}

	public function get_list( $is_admin = false, $locale = '' ) {
		if ( ! $locale ) {
			if ( $is_admin && ( $is_admin == 'yes' ) ) {
				$locale = get_user_locale();
			} else {
				$locale = get_locale();
			}
		}
		$locale_alpha_2 = $this->get_known_locale_alpha_2( $locale );
		$countries = $this->countries[ $locale_alpha_2 ];
		asort( $countries );
		return apply_filters( 'hb_countries_list', $countries, $locale );
	}

	public function get_known_locale_alpha_2( $locale ) {
		$locale_alpha_2 = substr( $locale, 0, 2 );
		if ( in_array( $locale_alpha_2, array_keys( $this->countries ) ) ) {
			return $locale_alpha_2;
		} else {
			return 'en';
		}
	}
}