<?php
if ( ! function_exists( '_recaptcha_qsencode' ) ) {
    require_once( rtrim( dirname( __FILE__ ), '/' ) . '/recaptchalib.php' );
}

header( "Content-type: application/json" );
$_data = WP_Contact_Widget::get_instance_data( @$_POST['instance'] );

/**
 * Validate email address
 *
 * @param $email
 *
 * @return bool|mixed
 */
function wpcw_validate_email( $email ) {

    if ( function_exists( 'filter_var' ) && defined( 'FILTER_VALIDATE_EMAIL' ) ) {
        return filter_var( $email, FILTER_VALIDATE_EMAIL );
    }

    $regex = '/([a-z0-9_.-]+)' .
             '@' .
             '([a-z0-9.-]+){1,255}' .
             '.' .
             "([a-z]+){2,10}/i";

    if ( $email == '' ) {
        return false;
    } else {
        $eregi = preg_replace( $regex, '', $email );
    }

    return empty( $eregi ) ? true : false;
}

function wpcw_validate_text_field( $subject ) {
    return str_ireplace( array( "\r", "\n", "%0a", "%0d" ), '', stripslashes( $subject ) );
}


if ( 'on' == $_data['wp_contact_widget_captcha'] ) {
    $resp   = null;
    $secret = $_data['wp_contact_widget_private_key'];
    if ( empty( $secret ) ) {
        //Send error
        wp_send_json_error();
    }
    $reCaptcha = new ReCaptcha( $secret );

    $response = ! empty( $_POST["g-recaptcha-response"] ) ? $_POST["g-recaptcha-response"] : '';
    $resp = $reCaptcha->verifyResponse(
            $_SERVER["REMOTE_ADDR"],
            $response
    );
    if ( $resp->success ) {
        $resp->is_valid = 1;
    }
}

if ( empty( $_POST ) ) {
    return;
}

$error = '';
$message = '';
$subscribe_message = '';
$default_fields = array( 'name', 'email', 'subject', 'phone', 'consent', 'message' );

$email   = ! empty( $_POST['email'] ) ? $_POST['email'] : '';

if ( empty( $email ) ) {
    $error .= '<p class="mts-contact-error">' . __( 'Please enter an e-mail address.', 'wp_contact_widget' ) . '</p>';
}
if ( $email && ! wpcw_validate_email( $email ) ) {
    $error .= '<p class="mts-contact-error">' . __( 'Please enter a valid e-mail address.', 'wp_contact_widget' ) . '</p>';
}

if ( !empty( $_POST['name'] ) ) {
    $name = wpcw_validate_text_field( stripslashes( $_POST['name'] ) );
    $message .= __('Name:', 'wp_contact_widget' ).' '.$name."\n\n";
} else {
    $name = '';
    if ( 'on' == $_data['wp_contact_widget_name_enable'] ) {
        $error .= '<p class="mts-contact-error">' . __( 'Please enter your name.', 'wp_contact_widget' ) . '</p>';
    }
}

if ( !empty( $_POST['subject'] ) ) {
    $subject = wpcw_validate_text_field( stripslashes( $_POST['subject'] ) );
} else {
    $subject = '';
    if ( 'on' == $_data['wp_contact_widget_subject_enable'] ) {
        $error .= '<p class="mts-contact-error">' . __( 'Please enter a subject.', 'wp_contact_widget' ) . '</p>';
    }
}

if ( !empty( $_POST['phone'] ) ) {
    $phone = wpcw_validate_text_field( stripslashes( $_POST['phone'] ) );
    $message .= __('Phone:', 'wp_contact_widget' ).' '.$phone."\n\n";
} else {
    $phone = '';
    if ( 'on' == $_data['wp_contact_widget_phone_enable'] ) {
        $error .= '<p class="mts-contact-error">' . __( 'Please enter your phone number.', 'wp_contact_widget' ) . '</p>';
    }
}

if ( empty( $_POST['consent'] ) ) {
    $consent = '';
    if ( 'on' == $_data['wp_contact_widget_consent_enable'] ) {
        $error .= '<p class="mts-contact-error">' . __( 'Please check the consent checkbox.', 'wp_contact_widget' ) . '</p>';
    }   
}

$referrer = !empty( $_POST['referrer'] ) ? $_POST['referrer'] : '';
if ( !empty( $referrer ) ) $message .= __('Referrer:', 'wp_contact_widget' ).' '.$referrer."\n\n";

$wp_contact_widget_fields_order = explode('#|%',$_data['wp_contact_widget_fields_order']);
$wp_contact_widget_fields_order = array_diff( $wp_contact_widget_fields_order, $default_fields );

foreach ( $wp_contact_widget_fields_order as $field ) { // custom fields
    if ( !empty( $_POST[ sanitize_title( $field ) ] ) ) {
        $field_val = wpcw_validate_text_field( stripslashes( $_POST[ sanitize_title( $field ) ] ) );
        $message .= $field.': '.$field_val."\n\n";
    } else {
        $error .= '<p class="mts-contact-error">' . __( 'Please fill field: ', 'wp_contact_widget' ) . $field .'</p>';
    }
}

if ( !empty( $_POST['message'] ) ) {
    $msg = stripslashes( stripslashes( $_POST['message'] ) );
    $message .= __('Message:', 'wp_contact_widget' ).' '.$msg;
} else {
    $msg = '';
    if ( 'on' == $_data['wp_contact_widget_message_enable'] ) {
        $error .= '<p class="mts-contact-error">' . __( 'Please enter your message.', 'wp_contact_widget' ) . '</p>';
    }
}

if ( $_data['wp_contact_widget_captcha'] == 'on' ) {
    if ( empty( $resp->is_valid ) || ! $resp->is_valid ) {
        $error .= '<p class="mts-contact-error">' . __( 'Please enter a valid captcha.', 'wp_contact_widget' ) . '</p>';
    }
}

// If any errors, return
if ( $error ) {
    echo json_encode( array(
        "status"  => 0,
        "message" => $error
    ) );
}

$subscribe = ( isset( $_POST['wp_contact_widget_newsletter_subscribe_toggle'] ) && 'on' === $_POST['wp_contact_widget_newsletter_subscribe_toggle'] ) ? true : false;
/**
 * Subscription Services
 */
$subscription_service = (!empty($_data['subscription_service'])) ? $_data['subscription_service'] : false;

if($subscription_service && $subscribe) {
    switch ($subscription_service) {
        case 'getresponse':
            $getresponse_api_key = $_data['getresponse_api_key'];
            $getresponse_campaign = $_data['getresponse_campaign'];

            require(WPCW_PLUGIN_BASE_DIR . '/scripts/getresponse/jsonRPCClient.php');

            $api = new jsonRPCClient('http://api2.getresponse.com');

            try {
                $api->add_contact(
                    $getresponse_api_key,
                    array (
                        'campaign'  => $getresponse_campaign,
                        'name'      => $name,
                        'email'     => $email,
                    )
                );

                setcookie( 'wpcw_email_success_', true, 0, '/');

                break;

            } catch (RuntimeException $exc) {

                $msg = $exc->getMessage();
                $msg = substr($msg, 0, strpos($msg, ";"));

                $subscribe_message .= '<p>' . $msg . '</p>';

                break;
            }

        break;
        case 'mailchimp':
            $mailchimp_api_key = $_data['mailchimp_api_key'];
            $mailchimp_list_id = $_data['mailchimp_list_id'];

            require_once WPCW_PLUGIN_BASE_DIR . '/scripts/mailchimp/MailChimp.php';

            if (!isset($mailchimp_api_key) || $mailchimp_api_key == '') {
                $subscribe_message .= '<p class="mts-contact-error">' . __( 'Please enter an e-mail address.', 'wp_contact_widget' ) . '</p>';
                break;
            }

            if (!isset($mailchimp_list_id) || $mailchimp_list_id == '') {
                
                $subscribe_message .= '<p class="mts-contact-error">' . __( 'Please enter an e-mail address.', 'wp_contact_widget' ) . '</p>';

                break;
            }

            $MailChimp = new WPS_MailChimp($mailchimp_api_key);
            $result = $MailChimp->call('lists/subscribe', array(
                'id'                => $mailchimp_list_id,
                'email'             => array('email'=>$email),
                'double_optin'      => true,
                'update_existing'   => false,
                'replace_interests' => false,
                'send_welcome'      => true,
            ));

            if ($result) {

                if (isset($result['email'])) {

                    setcookie('wpcw_email_success_', true, 0, '/');

                }

                else if (isset($result['status']) && $result['status'] == 'error') {

                    $subscribe_message .= '<p>' . $result['error'] . '</p>';

                    break;
                }
            } else {
                $subscribe_message .= '<p class="mts-contact-error">' . __( 'Unable to subscribe.', 'wp_contact_widget' ) . '</p>';

                break;
            }
        break;
        case 'aweber':
            $aweber_auth_code = $_data['aweber_auth_code'];
            $aweber_list_id = $_data['aweber_list_id'];
            $aweber_consumer_key = $_data['aweber_consumer_key'];
            $aweber_consumer_secret = $_data['aweber_consumer_secret'];
            $aweber_access_key = $_data['aweber_access_key'];
            $aweber_access_secret = $_data['aweber_access_secret'];

            require(WPCW_PLUGIN_BASE_DIR . '/scripts/aweber/aweber_api.php');

            if (!isset($aweber_consumer_key) || $aweber_consumer_key == '') {

                $subscribe_message .= '<p class="mts-contact-error">' . __( 'Aweber account is not setup properly.', 'wp_contact_widget' ) . '</p>';

                break;
            }

            $aweber = new AWeberAPI($aweber_consumer_key, $aweber_consumer_secret);

            try {
                $account = $aweber->getAccount($aweber_access_key, $aweber_access_secret);
                $list = $account->loadFromUrl('/accounts/' . $account->id . '/lists/' . $aweber_list_id);

                $subscriber = array(
                    'email'     => $email,
                    'name'      => $name,
                    'ip'        => $_SERVER['REMOTE_ADDR']
                );

                $newSubscriber = $list->subscribers->create($subscriber);

                setcookie( 'wpcw_email_success_', true, 0, '/');

                break;

            } catch (AWeberAPIException $exc) {

                $subscribe_message .= '<p class="mts-contact-success">' . $exc->message . '</p>';

                break;
            }
        break;
    }
}

if ( ! $error ) {
    $custom_email = trim( $_data['wp_contact_widget_delivered_to_mail'] );
    $admin_email  = $custom_email ? $custom_email : get_option( 'admin_email' );
    $headers      = 'MIME-Version: 1.0\r\n';
    $headers .= 'Content-type: text/html; charset=utf-8\r\n';

    $reply_to = $from = $email;

    $headers .= "To: <{$admin_email}>\r\n";
    $headers .= "From: <{$from}>\r\n";
    $headers .= "Reply-To: <{$reply_to}>\r\n";

    $mail = wp_mail( $admin_email, $subject, $message, $headers );
    if ( $mail ) {
        $success = @$_data['wp_contact_widget_success_message'] ? '<p class="mts-contact-success">' . $_data['wp_contact_widget_success_message'] . '</p>' : '<p class="mts-contact-success">' . __( 'Your message has been sent. Thank you!', 'wp_contact_widget' ) . '</p>';
        echo json_encode( array(
            "status"  => 1,
            "message" => $success . $subscribe_message,
        ) );
    } else {
        echo json_encode( array(
            "status"  => 0,
            "message" => '<p class="mts-contact-error">' . __( 'Mail not sent', 'wp_contact_widget' ) . '</p>' . $subscribe_message
        ) );
    }
}

?>