(function( $ ) {
    $(function() {

        // Force soft widget update inside customizer UI by clicking on hidden widget update button
        function wpcwUpdateCustomizerView( el ) {
            if ( $('body').hasClass('wp-customizer') ) {

                el.closest('.form').find('input.widget-control-save').click();
            }
        }

        $('.wp-contact-widget-inside').each(function() {

            var $sortableFields = $(this).find('.wpcw-form-items');
            // Sortable fields
            $sortableFields.sortable({
                items: '.wpcw-form-item',
                axis: 'y',
                opacity: '0.6',
                cursor: 'move',
                handle: '.wpcw-sort-handle',
            });

            $sortableFields.on('sortupdate', function(event, ui) {
                var order = $(this).sortable( 'toArray', { attribute: 'data-label' } ).join('#|%');
                $(this).closest('.widget-content').find('.wpcw_order').val( order );
                wpcwUpdateCustomizerView( $(this) );
            });

            // Add Fields Button
            $(document).on( 'click', '.add_field_button', function(e) {

                e.preventDefault();

                var $this = $(this),
                    $newItemLabelField = $this.parent().find('.add_field_input'),
                    newItemLabel = $newItemLabelField.val(),
                    $orderField = $this.closest('.widget-content').find('.wpcw_order'),
                    orderFieldVal = $orderField.val();

                if ( '' === newItemLabel ) {
                    //alert('Please enter custom field label');
                    $newItemLabelField.focus();
                } else {
                    var newItem = '<div class="wpcw-form-item" data-label="'+newItemLabel+'"><div class="wpcw-sort-header"><span class="wpcw-custom-field-label"><span class="wpcw-custom-field-remove"><i class="dashicons dashicons-no"></i></span>'+newItemLabel+'<span class="wpcw-sort-handle"><i class="dashicons dashicons-sort"></i></span></div></div>';

                    $(this).parent().prev().append(newItem);
                    $orderField.val( orderFieldVal+'#|%'+newItemLabel );
                    $newItemLabelField.val('');
                    $sortableFields.sortable('refresh');
                }

                wpcwUpdateCustomizerView( $this );
            });

            $(document).on( 'click', '.wpcw-custom-field-remove', function(e) {

                e.preventDefault();

                $(this).closest('.wpcw-form-item').remove();
                $sortableFields.trigger('sortupdate');
            });
        });

        $(document).on('keyup', '.add_field_input', function (event) {
            var $this = $(this),
                val = $this.val(),
                $btn = $this.parent().find('.add_field_button');

            if ( '' === val ) {
                $btn.prop( "disabled", true );
            } else {
                $btn.prop( "disabled", false );
            }
        });

        // Checkbox toggles
        $(document).on('change', '.wpcw-checkbox-toggle', function(e) {
            var $this = $(this),
                targetSelector = '[data-checkbox="'+$this.attr('id')+'"]';

            $( targetSelector ).toggleClass('active');
        });

        // Select which shows/hides options based on its value
        function wpcwShowHodeChildOptions( el ) {
            var $this = $(el),
                tempValue = $this.val(),
                targetSelector = '[data-parent-select-id="'+$this.attr('id')+'"]',
                activeSelector = '[data-parent-select-value="'+tempValue+'"]';

            $( targetSelector ).removeClass('active');

            if ( tempValue && activeSelector ) {

                $( targetSelector+activeSelector ).addClass('active');
            }
        }

        $('.wpcw-has-child-opt select').each(function() {
            wpcwShowHodeChildOptions( $(this) );
        });

        $(document).on('change', '.wpcw-has-child-opt select', function(e) {
            wpcwShowHodeChildOptions( $(this) );
        });
        

        /**
         * Subscribe APIs
         */
         // Get all MailChimp Lists
        $(document).on('keyup', '.mailchimp_api_key', function (event) {
            var $this = $(this),
                $mcList = $this.parent().next().find('.mailchimp_list_id');
            if ( $this.parent().next().find('.wpcw-spinner').length > 0 ) {
                return;
            }
            $('<i class="wpcw-spinner dashicons dashicons-update"></i>').insertAfter( $mcList );
            var data = {
                'action': 'wpcw_get_mailchimp_lists',
                'api_key': $this.val()
            };
            $.post(ajaxurl, data, function (response) {
                $this.parent().next().find('.wpcw-spinner').remove();
                $mcList.html(response);
            });
        });

        // Get all Get Response Lists
        $(document).on('keyup', '.getresponse_api_key', function (event) {
            var $this = $(this),
                $grList = $this.parent().next().find('.getresponse_campaign');
            // Do nothing if we already retrieved the lists
            if ($this.parent().next().find('.wpcw-spinner').length != 0) {
                return;
            }

            $('<i class="wpcw-spinner dashicons dashicons-update"></i>').insertAfter($grList);

            var data = {
                'action': 'wpcw_get_getresponse_lists',
                'api_key': $this.val()
            };
            
            $.post( ajaxurl, data, function(response) {
                $this.parent().next().find('.wpcw-spinner').remove();
                $grList.html(response);
            });
        });

        // Get all aweber Lists
        $(document).on('keyup', '.aweber_auth_code', function (event) {
            var $this = $(this),
                $awList = $this.parent().next().find('.aweber_list_id');

            // Do nothing if we already retrieved the lists
            if ($this.parent().next().find('.wpcw-spinner').length != 0) {
                return;
            }

            // Do nothing if the user did not input a code
            if ($(this).val() == '') {
                return;
            }

            $awList.html('');

            $('<i class="wpcw-spinner dashicons dashicons-update"></i>').insertAfter($awList);

            var data = {
                'action': 'wpcw_get_aweber_lists',
                'consumer_key':  $this.parent().prev().find('.aweber_consumer_key').val(),
                'consumer_secret': $this.parent().prev().find('.aweber_consumer_secret').val(),
                'access_key': $this.parent().prev().find('.aweber_access_key').val(),
                'access_secret': $this.parent().prev().find('.aweber_access_secret').val(),
                'code': $this.val(),
            };
            
            $.post( ajaxurl, data, function(response) {

                response = $.parseJSON(response);

                $this.parent().next().find('.wpcw-spinner').remove();
                $awList.html(response.html);
                $this.parent().prev().find('.aweber_consumer_key').val(response.consumer_key);
                $this.parent().prev().find('.aweber_consumer_secret').val(response.consumer_secret);
                $this.parent().prev().find('.aweber_access_key').val(response.access_key);
                $this.parent().prev().find('.aweber_access_secret').val(response.access_secret);

                if (response.consumer_key != '') {
                    $this.addClass('hidden');
                }

            });
        });
        

        function wpcwShowLists() {

            // MailChimp
            $('.mailchimp_api_key').each(function() {

                var $this = $(this),
                    $mcList = $this.parent().next().find('.mailchimp_list_id');

                if ( '' !== $this.val() ) {

                    $('<i class="wpcw-spinner dashicons dashicons-update"></i>').insertAfter( $mcList );

                    var data = {
                        'action': 'wpcw_get_mailchimp_lists',
                        'api_key': $this.val(),
                        'list': $mcList.data('list'),
                    };
                    
                    $.post( ajaxurl, data, function(response) {
                        $this.parent().next().find('.wpcw-spinner').remove();
                        $mcList.html(response);
                    });
                }
            });

            // Get Response
            $('.getresponse_api_key').each(function() {

                var $this = $(this),
                    $grList = $this.parent().next().find('.getresponse_campaign');

                if ( '' !== $this.val() ) {

                    $('<i id="wpcw-spinner dashicons dashicons-update"></i>').insertAfter( $grList );

                    var data = {
                        'action': 'wpcw_get_getresponse_lists',
                        'api_key': $this.val(),
                        'campaign': $grList.data('list')
                    };
                    
                    $.post( ajaxurl, data, function(response) {
                        $this.parent().next().find('.wpcw-spinner').remove();
                        $grList.html(response);
                    });
                }
            });

            // Aweber
            $('.aweber_auth_code').each(function() {
                var $this = $(this),
                    $awList = $this.parent().next().find('.aweber_list_id');

                $awList.html('');

                $('<i id="wpcw-spinner dashicons dashicons-update"></i>').insertAfter($awList);

                var data = {
                    'action': 'wpcw_get_aweber_lists',
                    'consumer_key':  $this.parent().prev().find('.aweber_consumer_key').val(),
                    'consumer_secret': $this.parent().prev().find('.aweber_consumer_secret').val(),
                    'access_key': $this.parent().prev().find('.aweber_access_key').val(),
                    'access_secret': $this.parent().prev().find('.aweber_access_secret').val(),
                    'code': $this.val(),
                    'list': $awList.attr('data-list'),
                };
                
                $.post( ajaxurl, data, function(response) {

                    response = $.parseJSON(response);

                    $this.parent().next().find('.wpcw-spinner').remove();
                    $awList.html(response.html);

                    $this.parent().prev().find('.aweber_consumer_key').val(response.consumer_key);
                    $this.parent().prev().find('.aweber_consumer_secret').val(response.consumer_secret);
                    $this.parent().prev().find('.aweber_access_key').val(response.access_key);
                    $this.parent().prev().find('.aweber_access_secret').val(response.access_secret);

                    if (response.consumer_key != '') {
                        $this.addClass('hidden');
                    }

                });
            });
        }

        // Async Functions
        setTimeout(function() {
            wpcwShowLists();
        } ,1);

        // When widget is saved or added
        $(document).on('widget-updated widget-added', function(e) {

            $('.wp-contact-widget-inside').each(function() {

                var $sortableFields = $(this).find('.wpcw-form-items');
                // Sortable fields
                $sortableFields.sortable({
                    items: '.wpcw-form-item',
                    axis: 'y',
                    opacity: '0.6',
                    cursor: 'move',
                    handle: '.wpcw-sort-handle',
                });

                $sortableFields.on('sortupdate', function(event, ui) {
                    var order = $(this).sortable( 'toArray', { attribute: 'data-label' } ).join('#|%');
                    $(this).closest('.widget-content').find('.wpcw_order').val( order );
                    wpcwUpdateCustomizerView( $(this) );
                });

                // Add Fields Button
                $(document).on( 'click', '.add_field_button', function(e) {

                    e.preventDefault();

                    var $this = $(this),
                        $newItemLabelField = $this.parent().find('.add_field_input'),
                        newItemLabel = $newItemLabelField.val(),
                        $orderField = $this.closest('.widget-content').find('.wpcw_order'),
                        orderFieldVal = $orderField.val();
                        
                    if ( '' === newItemLabel ) {
                        //alert('Please enter custom field label');
                        $newItemLabelField.focus();
                    } else {
                        var newItem = '<div class="wpcw-form-item" data-label="'+newItemLabel+'"><div class="wpcw-sort-header"><span class="wpcw-custom-field-label"><span class="wpcw-custom-field-remove"><i class="dashicons dashicons-no"></i></span>'+newItemLabel+'<span class="wpcw-sort-handle"><i class="dashicons dashicons-sort"></i></span></div></div>';

                        $(this).parent().prev().append(newItem);
                        $orderField.val( orderFieldVal+'#|%'+newItemLabel );
                        $newItemLabelField.val('');
                        $sortableFields.sortable('refresh');
                    }

                    wpcwUpdateCustomizerView( $(this) );
                });

                $(document).on( 'click', '.wpcw-custom-field-remove', function(e) {

                    e.preventDefault();

                    $(this).closest('.wpcw-form-item').remove();
                    $sortableFields.trigger('sortupdate');
                });
            });

            $('.wpcw-has-child-opt select').each(function() {
                wpcwShowHodeChildOptions( $(this) );
            });

            $('.mailchimp_list_id').each(function() {
                if ( $(this).val() )
                    $(this).data( 'list', $(this).val() );
            });

            $('.getresponse_campaign').each(function() {
                if ( $(this).val() )
                    $(this).data( 'list', $(this).val() );
            });

            $('.aweber_list_id').each(function() {
                if ( $(this).val() )
                    $(this).data( 'list', $(this).val() );
            });

            wpcwShowLists();
        });
    });
})( jQuery );