(function ($) {

	function wpcw_submit_form() {
		var $me = jQuery(this);
		var $form = $me.parents("form.wpcw-contact-form");
		var str = $form.serialize();console.log(str);
		jQuery.post(wp_contact_widget.ajax_url, {
			"action": "wpcw_send_mail",
			"data": str
		}, function (data) {
			var status = 0;
			var msg = '';
			try {
				status = parseInt(data.status, 10);
			} catch (e) {
				status = 0;
			}
			try {
				msg = data.message;
			} catch (e) {
				msg = '';
			}
			if (status) {
				jQuery(':input', $form).not(':button, :submit, :reset, :hidden').val('');
				$form.trigger('wpcw-mail_sent');
			}
			$form.find('.wpcw-message').html(msg);
			if (typeof Recaptcha != 'undefined') {
				Recaptcha.reload();
			} else if ( typeof grecaptcha != 'undefined' ) {
				grecaptcha.reset();
			}
		}, 'json');
		return false;
	}

	function wpcw_spawn_captcha() {
		if (typeof Recaptcha == "undefined") return;

		var $me = $(this);
		var $new = $me.parents("form.wpcw-contact-form");
		if (!$new.is(".wpcw-has_captcha")) return;

		var $old = $("#wpcw-recaptcha_widget").parents("form.wpcw-contact-form");
		if ($new.attr("id") == $old.attr("id")) return;

		Recaptcha.destroy();
		$new.append($("#wpcw-recaptcha_widget"));
		if ($new.is(".wpcw-compact_form")) $("#wpcw_refresh").hide();
		else  $("#wpcw_refresh a").text($new.find(".wpcw-refresh_link").val()).show();
		Recaptcha.create(
			'6LcHObsSAAAAAIfHD_wQ92EWdOV0JTcIN8tYxN07',
			'wpcw-recaptcha_widget',
			RecaptchaOptions
		);
		$("#recaptcha_image").attr("title", $new.find(".wpcw-refresh_message").val());
	}


	$(function () {

		if (typeof Recaptcha != "undefined") {
			$("#recaptcha_image").click(Recaptcha.reload);
		}

		// Initialize forms
		$("form.wpcw-contact-form").each(function () {
			var $form = $(this);
			if (!$form.length) return true;

			if ($form.find("#wpcw-recaptcha_widget").length) {
				if ($form.is(".wpcw-compact_form")) $("#wpcw_refresh").hide();
				else $("#wpcw_refresh a").text($form.find(".wpcw-refresh_link").val()).show();

				$("#recaptcha_image").attr("title", $form.find(".wpcw-refresh_message").val());
			}
			$form.find('input[name="submit"]').bind('click', wpcw_submit_form); // Bind submission
			$form.find(":input").bind('focus', wpcw_spawn_captcha);

			if (!$form.is(".wpcw-compact_form")) return true; // Compacting forms below

			$form.find("label").each(function () {
				var $me = $(this);
				$me.hide();
				if (!$me.attr("for")) return true;
				var $obj = $("#" + $me.attr("for"));
				if (!$obj.length) return true;
				$obj
					.addClass('wpcw_inactive')
					.val($me.text())
					.focus(function () {
						if ($obj.val() == $me.text()) $obj.val('');
						$obj.removeClass('wpcw_inactive');
					})
					.blur(function () {
						if ($obj.val()) return true;
						$obj.addClass('wpcw_inactive').val($me.text());
					})
				;
			});
		});

	});
})(jQuery);